/*
 * Decompiled with CFR 0.152.
 */
package gov.dot.fhwa.saxton.utils.data.asn1;

import gov.dot.fhwa.saxton.utils.Either;
import gov.dot.fhwa.saxton.utils.data.BitStreamUnpacker;
import gov.dot.fhwa.saxton.utils.data.asn1.Asn1Object;
import gov.dot.fhwa.saxton.utils.data.asn1.Asn1ParseException;
import gov.dot.fhwa.saxton.utils.data.asn1.Asn1Tag;
import java.util.ArrayList;
import java.util.Arrays;

public class Asn1Unpacker {
    private BitStreamUnpacker bsu;
    private static final int LONG_FORM_LENGTH_MASK = 127;
    private static final int LONG_FORM_LENGTH_INDICATOR = 128;
    private static final int TAG_CONTINUATION_FLAG_MASK = 128;
    private static final int CONSTRUCTED_FLAG_MASK = 32;
    private static final int TAG_IDENTIFIER_MASK = 31;
    private static final int LONG_FORM_TAG_INDICATOR = 31;

    public Asn1Unpacker(BitStreamUnpacker bsu) {
        this.bsu = bsu;
    }

    public Asn1Unpacker(byte[] data) {
        this.bsu = new BitStreamUnpacker(data);
    }

    public Asn1Unpacker(byte[] data, int offset) {
        this.bsu = new BitStreamUnpacker(data);
        this.bsu.skipBytes(offset);
    }

    public Asn1Object unpack() throws Asn1ParseException {
        Asn1Object out = new Asn1Object();
        out.setTag(this.unpackTag());
        out.setLength(this.unpackLength());
        int currentObjectStartIdx = this.bsu.getCurrentByte();
        int currentObjectEndIdx = currentObjectStartIdx + out.getLength();
        if (out.getTag().isConstructed()) {
            ArrayList<Asn1Object> children = new ArrayList<Asn1Object>();
            while (this.bsu.getCurrentByte() < currentObjectEndIdx) {
                children.add(this.unpack());
            }
            out.setValue(Either.right(children));
        } else {
            try {
                out.setValue(Either.left(Arrays.copyOfRange(this.bsu.getBytes(), this.bsu.getCurrentByte(), this.bsu.getCurrentByte() + out.getLength())));
                this.bsu.skipBytes(out.getLength());
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new Asn1ParseException(Asn1ParseException.Asn1ParseError.BUFFER_OVERRUN);
            }
        }
        return out;
    }

    private Asn1Tag unpackTag() throws Asn1ParseException {
        boolean longFormTagEncoding;
        Asn1Tag out = new Asn1Tag();
        int rawTagByte = this.bsu.readByte();
        boolean bl = longFormTagEncoding = (rawTagByte & 0x1F) == 31;
        if (longFormTagEncoding) {
            int curByte = 0;
            int offset = 0;
            int tagAccumulator = 0;
            do {
                curByte = this.bsu.readByte();
                tagAccumulator <<= offset++ * 7;
                tagAccumulator |= curByte & 0xFFFFFF7F;
            } while ((curByte & 0x80) > 0);
            if (tagAccumulator == 0) {
                throw new Asn1ParseException(Asn1ParseException.Asn1ParseError.MALFORMED_TAG);
            }
            out.setIdentifier(tagAccumulator);
        } else {
            out.setIdentifier(rawTagByte & 0x1F);
        }
        out.setIsConstructed((rawTagByte & 0x20) > 0);
        out.setObjectClass(Asn1Tag.Asn1ObjectClass.valueOf(rawTagByte >>> 6));
        return out;
    }

    private int unpackLength() throws Asn1ParseException {
        boolean longFormLengthEncoding;
        int rawLengthByte = this.bsu.readByte();
        boolean bl = longFormLengthEncoding = (rawLengthByte & 0x80) == 128;
        if (longFormLengthEncoding) {
            int lengthLength = rawLengthByte & 0x7F;
            int lengthAccumulator = 0;
            for (int i = lengthLength - 1; i >= 0; --i) {
                int curByte = this.bsu.readByte();
                lengthAccumulator |= curByte << i * 8;
            }
            return lengthAccumulator;
        }
        return rawLengthByte;
    }
}

