/*
 * Decompiled with CFR 0.152.
 */
package gov.dot.fhwa.saxton.utils.data.asn1;

public class Asn1Tag {
    private Asn1ObjectClass objectClass;
    private boolean isConstructed;
    private int identifier;

    public Asn1ObjectClass getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Asn1ObjectClass objectClass) {
        this.objectClass = objectClass;
    }

    public boolean isConstructed() {
        return this.isConstructed;
    }

    public void setIsConstructed(boolean isConstructed) {
        this.isConstructed = isConstructed;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Asn1Tag asn1Tag = (Asn1Tag)o;
        if (this.isConstructed != asn1Tag.isConstructed) {
            return false;
        }
        if (this.identifier != asn1Tag.identifier) {
            return false;
        }
        return this.objectClass == asn1Tag.objectClass;
    }

    public int hashCode() {
        int result = this.objectClass != null ? this.objectClass.hashCode() : 0;
        result = 31 * result + (this.isConstructed ? 1 : 0);
        result = 31 * result + this.identifier;
        return result;
    }

    public String toString() {
        return "Asn1Tag{objectClass=" + (Object)((Object)this.objectClass) + ", isConstructed=" + this.isConstructed + ", identifier=" + this.identifier + '}';
    }

    public static enum Asn1ObjectClass {
        UNIVERSAL(0),
        APPLICATION(1),
        CONTEXT_SPECIFIC(2),
        PRIVATE(3);

        private final int value;

        private Asn1ObjectClass(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Asn1ObjectClass valueOf(int value) {
            for (Asn1ObjectClass objectClass : Asn1ObjectClass.values()) {
                if (objectClass.getValue() != value) continue;
                return objectClass;
            }
            return null;
        }
    }
}

