/*
 * Decompiled with CFR 0.152.
 */
package gov.dot.fhwa.saxton.utils.data.asn1;

import gov.dot.fhwa.saxton.utils.Either;
import gov.dot.fhwa.saxton.utils.data.asn1.Asn1Tag;
import java.util.List;

public class Asn1Object {
    private Asn1Tag tag;
    private int length;
    private Either<byte[], List<Asn1Object>> value;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Either<byte[], List<Asn1Object>> getValue() {
        return this.value;
    }

    public void setValue(Either<byte[], List<Asn1Object>> value) {
        this.value = value;
    }

    public Asn1Tag getTag() {
        return this.tag;
    }

    public void setTag(Asn1Tag tag) {
        this.tag = tag;
    }

    public Asn1Object findObjectById(int id) {
        if (this.tag.getIdentifier() == id) {
            return this;
        }
        return this.value.apply(p -> null, c -> {
            for (Asn1Object child : c) {
                Asn1Object tmp = child.findObjectById(id);
                if (tmp == null) continue;
                return tmp;
            }
            return null;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Asn1Object that = (Asn1Object)o;
        if (this.length != that.length) {
            return false;
        }
        if (this.tag != null ? !this.tag.equals(that.tag) : that.tag != null) {
            return false;
        }
        return !(this.value == null ? that.value != null : !this.value.equals(that.value));
    }

    public int hashCode() {
        int result = this.tag != null ? this.tag.hashCode() : 0;
        result = 31 * result + this.length;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Asn1Object{tag=" + this.tag + ", length=" + this.length + ", value=" + this.value + '}';
    }
}

