/*
 * Decompiled with CFR 0.152.
 */
package gov.dot.fhwa.saxton.utils.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class UnpackUtils {
    public static int unpack8(byte theByte) {
        return theByte;
    }

    public static int unpackU8(byte theByte) {
        return theByte & 0xFF;
    }

    public static int unpack16(byte[] bytes) {
        if (bytes.length != 2) {
            return 0;
        }
        short shortValue = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getShort();
        return shortValue;
    }

    public static int unpack16BigEndian(byte[] bytes) {
        if (bytes.length != 2) {
            return 0;
        }
        short shortValue = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).getShort();
        return shortValue;
    }

    public static int unpackU16(byte[] bytes) {
        if (bytes.length != 2) {
            return 0;
        }
        short shortValue = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getShort();
        int intValue = shortValue & 0xFFFF;
        return intValue;
    }

    public static int unpackU16BigEndian(byte[] bytes) {
        if (bytes.length != 2) {
            return 0;
        }
        short shortValue = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).getShort();
        int intValue = shortValue & 0xFFFF;
        return intValue;
    }

    public static int unpack24(byte[] bytes) {
        if (bytes.length != 3) {
            return 0;
        }
        int value = bytes[2] << 16;
        value |= bytes[1] << 8;
        return value |= bytes[0];
    }

    public static int unpack32(byte[] bytes) {
        if (bytes.length != 4) {
            return 0;
        }
        int intValue = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        return intValue;
    }

    public static int unpack32BigEndian(byte[] bytes) {
        if (bytes.length != 4) {
            return 0;
        }
        int intValue = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).getInt();
        return intValue;
    }

    public static long unpackU32(byte[] bytes) {
        if (bytes.length != 4) {
            return 0L;
        }
        int intValue = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        return (long)intValue & 0xFFFFFFFFL;
    }

    public static long unpackU32BigEndian(byte[] bytes) {
        if (bytes.length != 4) {
            return 0L;
        }
        int intValue = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).getInt();
        return (long)intValue & 0xFFFFFFFFL;
    }
}

