/*
 * Decompiled with CFR 0.152.
 */
package gov.dot.fhwa.saxton.utils.data;

public class BitStreamUnpacker {
    private int size;
    private int currentBit = 0;
    private byte[] bytes;
    private static int leastSignificantBitMask = 1;
    private boolean littleEndian = false;

    public BitStreamUnpacker(byte[] bytes) {
        this.bytes = bytes;
        this.size = bytes.length * 8;
    }

    public BitStreamUnpacker(byte[] bytes, boolean littleEndian) {
        this(bytes);
        this.littleEndian = littleEndian;
    }

    public int readBit() {
        if (this.currentBit >= this.size) {
            throw new IndexOutOfBoundsException("Attempted read beyond end of bitstream.");
        }
        byte container = this.bytes[this.currentBit / 8];
        int bitIndex = this.currentBit % 8;
        int value = container >>> 7 - bitIndex & leastSignificantBitMask;
        ++this.currentBit;
        return value;
    }

    public boolean readBool() {
        return this.readBit() == 1;
    }

    public int readBits(int numBits) {
        if (numBits > 32) {
            throw new IndexOutOfBoundsException("Attempted to read larger than 32 bits of data into an int return value");
        }
        int out = 0;
        for (int i = 0; i < numBits; ++i) {
            out += this.readBit() << numBits - i - 1;
        }
        return out;
    }

    public int readByte() {
        return this.readBits(8);
    }

    public byte[] readByteArray(int numBytes) {
        byte[] out = new byte[numBytes];
        for (int i = 0; i < numBytes; ++i) {
            out[i] = (byte)this.readByte();
        }
        return out;
    }

    public int readShort() {
        int out = this.readBits(16);
        if (this.littleEndian) {
            out = this.swapEndianShort(out);
        }
        return out;
    }

    public int readInt() {
        int out = this.readBits(32);
        if (this.littleEndian) {
            out = this.swapEndianInt(out);
        }
        return out;
    }

    private int swapEndianInt(int i) {
        return ((i & 0xFF) << 24) + ((i & 0xFF00) << 8) + ((i & 0xFF0000) >> 8) + (i >>> 24);
    }

    private int swapEndianShort(int i) {
        return ((i & 0xFF) << 8) + ((i & 0xFF00) >>> 8);
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public void setBigEndian() {
        this.littleEndian = false;
    }

    public void setLittleEndian() {
        this.littleEndian = true;
    }

    public boolean hasBits() {
        return this.currentBit < this.size;
    }

    public int getCurrentByte() {
        return this.currentBit / 8;
    }

    public int getCurrentBit() {
        return this.currentBit;
    }

    public void skipBytes(int bytes) {
        this.currentBit += 8 * bytes;
    }

    public void skipBits(int bits) {
        this.currentBit += bits;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

