/*
 * Decompiled with CFR 0.152.
 */
package gov.dot.fhwa.saxton.utils.data;

import java.util.ArrayList;

public class BitStreamPacker {
    ArrayList<Byte> bytes = new ArrayList();
    byte cur;
    int bitIndex = 0;
    private boolean littleEndian = false;

    public BitStreamPacker() {
    }

    public BitStreamPacker(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    public void writeBit(int data) {
        this.cur = (byte)(this.cur | data << this.bitIndex);
        ++this.bitIndex;
        this.bitIndex %= 8;
        if (this.bitIndex == 0) {
            this.bytes.add(this.cur);
            this.cur = 0;
        }
    }

    public void writeBits(int data, int size) {
        int index = 1;
        for (int i = 0; i < size; ++i) {
            this.writeBit((index & data) >> i);
            index <<= 1;
        }
    }

    public void writeByte(int data) {
        this.writeBits(data, 8);
    }

    public void writeShort(int data) {
        if (!this.littleEndian) {
            data = this.swapEndianShort(data);
        }
        this.writeBits(data, 16);
    }

    public void writeInt(int data) {
        if (!this.littleEndian) {
            data = this.swapEndianInt(data);
        }
        this.writeBits(data, 32);
    }

    public void writeBool(boolean data) {
        this.writeBit(data ? 1 : 0);
    }

    public void writeByteArray(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.writeByte(data[i]);
        }
    }

    public byte[] getBytes() {
        byte[] data = this.bitIndex == 0 ? new byte[this.bytes.size()] : new byte[this.bytes.size() + 1];
        for (int i = 0; i < this.bytes.size(); ++i) {
            data[i] = this.bytes.get(i);
        }
        if (this.bitIndex != 0) {
            data[this.bytes.size()] = (byte)(this.cur << 8 - this.bitIndex);
        }
        return data;
    }

    private int swapEndianInt(int i) {
        return ((i & 0xFF) << 24) + ((i & 0xFF00) << 8) + ((i & 0xFF0000) >> 8) + (i >>> 24);
    }

    private int swapEndianShort(int i) {
        return ((i & 0xFF) << 8) + ((i & 0xFF00) >>> 8);
    }

    public void setBigEndian() {
        this.littleEndian = false;
    }

    public void setLittleEndian() {
        this.littleEndian = true;
    }
}

