/*
 * Copyright (C) 2018-2019 LEIDOS.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

#pragma once
#include "guidance/guidance_state_machine.hpp"

namespace guidance
{
    class GuidanceStateMachineFactory {
        public:
            /*!
             * \brief Create Guidance state machine for HardwareEngagedAutomation
             */
            std::unique_ptr<GuidanceStateMachine> createHardwareEngagedAutomationInstance();

            /*!
             * \brief Create Guidance state machine for SoftwareOnlyEngagedStateMachine
             */
            std::unique_ptr<GuidanceStateMachine> createSoftwareOnlyEngagedStateMachineInstance();

            /*!
             * \brief Create Guidance state machine
             */
            std::unique_ptr<GuidanceStateMachine> createStateMachineInstance(std::string vehicle_state_machine_type);
    };

}