/*
 * Decompiled with CFR 0.152.
 */
package gov.dot.fhwa.saxton.utils;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Either<L, R> {
    private Optional<L> left;
    private Optional<R> right;

    private Either(Optional<L> left, Optional<R> right) {
        this.left = left;
        this.right = right;
    }

    public static <L, R> Either<L, R> left(L left) {
        return new Either(Optional.of(left), Optional.empty());
    }

    public static <L, R> Either<L, R> right(R right) {
        return new Either(Optional.empty(), Optional.of(right));
    }

    public <T> T apply(Function<? super L, ? extends T> lFunc, Function<? super R, ? extends T> rFunc) {
        if (this.left.isPresent()) {
            return lFunc.apply(this.left.get());
        }
        return rFunc.apply(this.right.get());
    }

    public void consume(Consumer<? super L> lConsumer, Consumer<? super R> rConsumer) {
        this.left.ifPresent(lConsumer);
        this.right.ifPresent(rConsumer);
    }

    public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> func) {
        return new Either<T, R>(this.left.map(func), this.right);
    }

    public <T> Either<L, T> mapRight(Function<? super R, ? extends T> func) {
        return new Either<L, T>(this.left, this.right.map(func));
    }

    public String toString() {
        return "Either{left=" + this.left.map(Object::toString).orElse("empty") + ",right=" + this.right.map(Object::toString).orElse("empty");
    }
}

