/*
 * Decompiled with CFR 0.152.
 */
package gov.dot.fhwa.saxton.utils;

import java.util.ArrayList;
import java.util.List;

public class ComponentVersion {
    private String name_ = "GenericComponentName";
    private String suffix_ = "";
    private int majorRev_ = 0;
    private int intermediateRev_ = 0;
    private int minorRev_ = 0;
    private int build_ = 0;
    private boolean useIntermediate_ = false;
    private boolean useMinor_ = false;
    private boolean useBuild_ = false;
    private List<ComponentVersion> deps_ = new ArrayList<ComponentVersion>();

    public void setName(String name) {
        this.name_ = name;
    }

    public void setSuffix(String suffix) {
        this.suffix_ = suffix;
    }

    public void setMajorRevision(int major) {
        this.majorRev_ = major;
    }

    public void setIntermediateRevision(int intermediate) {
        this.intermediateRev_ = intermediate;
        this.useIntermediate_ = true;
    }

    public void setMinorRevision(int minor) {
        this.minorRev_ = minor;
        this.useMinor_ = true;
    }

    public void setBuild(int build) {
        this.build_ = build;
        this.useBuild_ = true;
    }

    public void addDependent(ComponentVersion dep) {
        this.deps_.add(dep);
    }

    public int majorRevision() {
        return this.majorRev_;
    }

    public int intermediateRevision() {
        return this.intermediateRev_;
    }

    public int minorRevision() {
        return this.minorRev_;
    }

    public int build() {
        return this.build_;
    }

    public String componentName() {
        return this.name_;
    }

    public String revisionString() {
        String rtn = String.valueOf(this.majorRev_);
        if (this.useIntermediate_) {
            rtn = rtn + "." + this.intermediateRev_;
        }
        if (this.useMinor_) {
            rtn = rtn + "." + this.minorRev_;
        }
        if (this.useBuild_) {
            rtn = rtn + "." + this.build_;
        }
        if (!this.suffix_.equals("")) {
            rtn = rtn + "-" + this.suffix_;
        }
        return rtn;
    }

    public String suffix() {
        return this.suffix_;
    }

    public String toString() {
        return this.name_ + " " + this.revisionString();
    }

    public String toStringWithDependencies() {
        String res = this.toString();
        if (this.deps_.size() > 0) {
            res = res + ", which includes";
            for (ComponentVersion dep : this.deps_) {
                res = res + "\n    " + dep.toStringWithDependencies();
            }
        }
        return res;
    }

    public List<String> toListWithDependencies() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.toString());
        if (this.deps_.size() > 0) {
            for (ComponentVersion dep : this.deps_) {
                list.addAll(dep.toListWithDependencies());
            }
        }
        return list;
    }

    public List<ComponentVersion> getDependencies() {
        return this.deps_;
    }
}

