/*
 * Decompiled with CFR 0.152.
 */
package gov.dot.fhwa.saxton.speedharm.util.milemarkers;

import gov.dot.fhwa.saxton.speedharm.util.milemarkers.MilemarkerPoint;
import java.util.ArrayList;
import java.util.List;

public class MilemarkerConverter {
    private static final double EARTH_RADIUS_MI = 3690.0;
    private List<MilemarkerPoint> milemarkers = new ArrayList<MilemarkerPoint>();

    public MilemarkerConverter(List<MilemarkerPoint> milemarkers) {
        this.milemarkers = milemarkers;
    }

    private double deg2rad(double deg) {
        return deg / 180.0 * Math.PI;
    }

    private double haversine(double lat1, double lon1, double lat2, double lon2) {
        double delta_lat = lat2 - lat1;
        double delta_lon = lon2 - lon1;
        double alpha = this.deg2rad(delta_lat / 2.0);
        double beta = this.deg2rad(delta_lon / 2.0);
        double a = Math.pow(Math.sin(alpha), 2.0) + Math.cos(this.deg2rad(lat1)) * Math.cos(this.deg2rad(lat2)) * Math.pow(Math.sin(beta), 2.0);
        double c = Math.asin(Math.min(1.0, Math.sqrt(a)));
        return 7380.0 * c;
    }

    public double convert(double lat, double lon) {
        double minDistance = Double.POSITIVE_INFINITY;
        double closestMilemarker = -1.0;
        for (MilemarkerPoint m : this.milemarkers) {
            double dist = this.haversine(lat, lon, m.getLatitude(), m.getLongitude());
            if (!(dist <= minDistance)) continue;
            minDistance = dist;
            closestMilemarker = m.getMilemarker();
        }
        return closestMilemarker;
    }
}

