/*
 * Decompiled with CFR 0.152.
 */
package gov.dot.fhwa.saxton.speedharm.algorithms;

import gov.dot.fhwa.saxton.speedharm.algorithms.AlgorithmOutputCallback;
import gov.dot.fhwa.saxton.speedharm.algorithms.IAlgorithm;
import gov.dot.fhwa.saxton.speedharm.api.objects.InfrastructureStatusUpdate;
import gov.dot.fhwa.saxton.speedharm.api.objects.VehicleCommand;
import gov.dot.fhwa.saxton.speedharm.api.objects.VehicleSession;
import gov.dot.fhwa.saxton.speedharm.api.objects.VehicleStatusUpdate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractAlgorithm
implements IAlgorithm {
    private List<VehicleSession> vehicles = new ArrayList<VehicleSession>();
    private Queue<VehicleStatusUpdate> vsuQueue = new LinkedBlockingQueue<VehicleStatusUpdate>();
    private Queue<InfrastructureStatusUpdate> isuQueue = new LinkedBlockingQueue<InfrastructureStatusUpdate>();
    private List<AlgorithmOutputCallback> outputCallbacks = new ArrayList<AlgorithmOutputCallback>();

    @Override
    public void initVehicle(VehicleSession v) {
        if (!this.vehicles.contains(v)) {
            this.vehicles.add(v);
        }
    }

    @Override
    public void terminateVehicle(VehicleSession v) {
        this.vehicles.remove(v);
    }

    @Override
    public synchronized void updateVehicleStatus(VehicleStatusUpdate vsu) {
        this.vsuQueue.add(vsu);
    }

    @Override
    public synchronized void updateInfrastructureStatus(InfrastructureStatusUpdate isu) {
        this.isuQueue.add(isu);
    }

    @Override
    public void registerOutputCallback(AlgorithmOutputCallback aoc) {
        if (!this.outputCallbacks.contains(aoc)) {
            this.outputCallbacks.add(aoc);
        }
    }

    public List<VehicleSession> getVehicles() {
        return new ArrayList<VehicleSession>(this.vehicles);
    }

    protected synchronized List<VehicleStatusUpdate> getPendingVehicleStatusUpdates() {
        ArrayList<VehicleStatusUpdate> out = new ArrayList<VehicleStatusUpdate>(this.vsuQueue);
        this.vsuQueue = new LinkedBlockingQueue<VehicleStatusUpdate>();
        return out;
    }

    protected synchronized List<InfrastructureStatusUpdate> getPendingInfrastructureStatusUpdates() {
        ArrayList<InfrastructureStatusUpdate> out = new ArrayList<InfrastructureStatusUpdate>(this.isuQueue);
        this.isuQueue = new LinkedBlockingQueue<InfrastructureStatusUpdate>();
        return out;
    }

    protected void fireOutputCallbacks(VehicleCommand vsc) {
        for (AlgorithmOutputCallback aoc : this.outputCallbacks) {
            aoc.newAlgorithmOutput(vsc);
        }
    }

    protected void produceOutput(Long vehId, Double speed, Double commandConfidence) {
        VehicleCommand vc = new VehicleCommand();
        vc.setCommandConfidence(commandConfidence);
        vc.setSpeed(speed);
        vc.setTimestamp(LocalDateTime.now());
        vc.setVehId(vehId);
        this.fireOutputCallbacks(vc);
    }

    @Override
    public int getNumCurrentVehicles() {
        return this.vehicles.size();
    }
}

