# README for `DOT SMART Grant MHA Nation Drone Project: Planning and Protocol Development`  
Strengthening Mobility and Revolutionizing Transportation (SMART) Program, U.S. Department of Transportation (USDOT)
2026-01-27  


## Links to Dataset  
Dataset Archive Link: <10.5281/zenodo.18318686>  
Data Management Plan DOI: https://doi.org/10.48321/D17381ca06  

## Summary of Dataset  

This collection of data include all data relevant to this project.  These are organized into three primary areas (modeling, test & demonstration, and text & tabular).  These data include reports, planning documents, survey results, and flight demonstration data (planning and data associated with actual flights).


## Tables of Contents  
##### A. General Information  
##### B. Sharing/Access & Policies Information  
##### C. Data and Related Files Overview  
##### D. Methodological Information  
##### E. Data-Specific Information for: `DOT SMART Grant MHA Nation Drone Project: Planning and Protocol Development`  
##### F. Update Log  


## A. General Information  

**Title of Dataset:**  `DOT SMART Grant MHA Nation Drone Project: Planning and Protocol Development`  

**Description of the Dataset:** `The dataset contains the project planning, execution, and output for the DOT SMART Grant MHA Nation Drone Project: Planning and Protocol Development project.`  

**Dataset Archive Link:** <10.5281/zenodo.18318686>  

**Authorship Information:**  

>  *Principal Data Creator or Data Manager Contact Information*  
>  Name: `Kerry Hartman` `[0000-0003-0098-3927](0000-0003-0098-3927)`    
>  Address: `301 College Drive, P.O. Box 490, New Town, North Dakota, 58763`  
>  Email: `[khartman@nhsc.edu](mailto: khartman@nhsc.edu)`  

>  *Data Distributor Contact Information*  
>  Name: `Kerry Hartman` `[0000-0003-0098-3927](0000-0003-0098-3927)`    
>  Institution: `Nueta Hidatsa Sahnish College`  
>  Address: `301 College Drive, P.O. Box 490, New Town, North Dakota, 58763`    
>  Email: `[khartman@nhsc.edu](mailto: khartman@nhsc.edu)`    

>  *Organizational Contact Information*  
>  Name: `Kerry Hartman` `[0000-0003-0098-3927](0000-0003-0098-3927)`  
>  Institution: `Nueta Hidatsa Sahnish College`  
>  Address: `301 College Drive, P.O. Box 490, New Town, North Dakota, 58763`   
>  Email: `[khartman@nhsc.edu](mailto: khartman@nhsc.edu)`    

**Date of data collection and update interval:** `15 August 2023 to 30 June 2025`  

**Geographic location of data collection:** `North Dakota`  

**Information about funding sources that supported the collection of the data:** `This dataset package was funded through the USDOT Strengthening Mobility and Revolutionizing Transportation (SMART) Program. The grant number for this project is: 69A3552341027`  

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  `Hartman, Kerry; Heitkamp, Thomasine; Askelson, Mark; Brandt, Amanda; Cherian, Mathew; Gufford, Joseph` (`2026`). `DOT SMART Grant MHA Nation Drone Project: Planning and Protocol Development`. Strengthening Mobility and Revolutionizing Transportation (SMART) Program. <10.5281/zenodo.18318686>  

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof. To protect the privacy of subject participants and conform to the restrictions of the Institutional Review Board, raw and individual-level data will not be made available.  

**Was data derived from another source?:** `No`  

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's `Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1`(https://doi.org/10.21949/1520559) and `guidelines suggested by the DOT Public Access website`(https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  

File List for the `Data.zip`  

>  1. Filename: `Modeling (Generating because flight happened)`  
>  Short Description:  `These files include after action reports, and hotwashes.`   

>  2. Filename: `Test&Demonstration (Generated to make flight happen)`  
>  Short Description:  `This section includes ADSB Data, contracts needed for project execution, flight planning data, in-flight data, and project planning data.`  

>  3. Filename: `Text&Tabular (Actual tables , charts, diagrams)`  
>  Short Description:  `This section is for reports, tables, charts, and diagrams.`  

## D. Methodological Information  

**Description of methods used for collection/generation of data:** `Information from listening sessions in a World Café format will be gathered in a public forum to internally inform the project staff and advisory board. General themes from the listening sessions will be reported to DOT as advised by UND’s IRB. In public forums (i.e., World Cafe listening sessions), it will be clearly stated that it is a public forum. Given the focus of operations on tribal lands, there is significant sensitivity regarding data management and control. In addition, flight tests data and GIS data involve privacy concerns.
2. MHA tribal resolution and UND’s IRB approval was secured. Additional focus groups and depth interviews were conducted over the course of the project with guidance from the advisory board. This resulted in data from individuals at MHA Nation who provide informed consent to participate within the guidelines of UND IRB and tribal protocols. The project followed guidance provided by CARE Principles for Indigenous Data Governance (https://www.gida-global.org/care). 3. All data will only be accessible by research personnel and protected by passwords and encryption.`

**Instrument or software-specific information needed to interpret the data:** `.docx: The .docx file is a Microsoft Word file, which can be opened with Word and other free word processor programs, such as Kingsoft Writer, OpenOffice Writer, Apache OpenOffice, and ONLYOFFICE.`  

## E. Data-Specific Information  

## F. Update Log  

This README.txt file was originally created on `2026-01-25` by `Joseph Gufford` (<0009-0007-1462-9888>), `Research Scientist - Data Analyst`, (joseph.gufford@und.edu)[mailto:joseph.gufford@und.edu]  

`2026-01-25`: Original file created
`2026-01-28`: File updated
