# README for `Open Data Approach to Curbside Management`
Strengthening Mobility and Revolutionizing Transportation (SMART) Program, U.S. Department of Transportation (USDOT)
`2026-01-14`


## Links to Dataset
Dataset Archive Link: `The dataset generated under this SMART Stage 1 project has been submitted to USDOTs ROSA P repository for public release. A DOI will be assigned by ROSA P upon publication.`
Data Management Plan DOI: (https://dmphub.uc3prd.cdlib.net/dmps/10.48321/D1E2E905BF)

## Summary of Dataset

`Develop a collection of multi-faceted, open-source APIs to communicate Minneapolis policies and regulations, real-time changes to curb usage, and provide a historical view of curb usage, impacts, and efficiencies. Dataset includes: Final Implementation Plan, Air quality data, Predictive curb occupancy data from ParkMobile/Arrive, Manual inventory and occupancy data collection, NexCity curb inventory and event data.`


## Tables of Contents
##### A. General Information
##### B. Sharing/Access & Policies Information
##### C. Data and Related Files Overview
##### D. Methodological Information
##### E. Data-Specific Information for: `Open Data Approach to Curbside Management`
##### F. Update Log


## A. General Information 

**Title of Dataset:**  `Open Data Approach to Curbside Management`

**Description of the Dataset:** `Develop a collection of multi-faceted, open-source APIs to communicate Minneapolis policies and regulations, real-time changes to curb usage, and provide a historical view of curb usage, impacts, and efficiencies. Dataset includes: Final Implementation Plan, Air quality data, Predictive curb occupancy data from ParkMobile/Arrive, Manual inventory and occupancy data collection, NexCity curb inventory and event data.`

**Dataset Archive Link:** `The dataset generated under this SMART Stage 1 project has been submitted to USDOTs ROSA P repository for public release. A DOI will be assigned by ROSA P upon publication.`

**Authorship Information:**

>  *Principal Data Creator Contact Information*
>  Name: `Dillon Fried` `https://orcid.org/0009-0002-4951-2712`
>  Institution: `City of Minneapolis`
>  Address: `City Hall, 350 S Fifth Street, Room 203, Minneapolis, MN 55415`
>  Email: `dillon.fried@minneapolismn.gov`

>  *Associate Data Creator*
>  Name: `Bryce Edmond`
>  Institution: `City of Minneapolis`
>  Address: `City Hall, 350 S Fifth Street, Room 203, Minneapolis, MN 55415`
>  Email: `bryce.edmond@minneapolismn.gov`

>  *Project Member*
>  Name: `Maxwell Holperin` `https://orcid.org/0009-0001-7676-3624` 
>  Institution: `Walker Consultants`
>  Address: `7760 France Avenue South, Suite 820, Minneapolis, MN 55435`
>  Email: `mholperin@walkerconsultants.com`

>  *Data Collector*
>  Name: `Rick Neubauer`
>  Institution: `Umojo, Inc.`
>  Address: `40 Shuman Blvd. Suite 200 Naperville, IL 60563`
>  Email: `rneubauer@umojo.com`

>  *Organizational Contact Information*  
>  Name: `City of Minneapolis`
>  Institution: `City of Minneapolis, Department of Public Works, Traffic and Parking Services`
>  Address: `City Hall, 350 S Fifth Street, Room 203`
>  Email: `minneapolis311@minneapolismn.gov`

**Date of data collection and update interval:** `Data was collected between May 2024 and September 15, 2025.`  

**Geographic location of data collection:** `United States of America`  

**Information about funding sources that supported the collection of the data:** `This dataset package was funded through the USDOT Strengthening Mobility and Revolutionizing Transportation (SMART) Program. The grant number for this project is: SMARTFY22N1P1G35`  

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  `Fried, Dillon. Demond, Bryce. Holperin, Max (2026). Open Data Approach to Curbside Management.`. Strengthening Mobility and Revolutionizing Transportation (SMART) Program.

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof. To protect the privacy of subject participants and conform to the restrictions of the Institutional Review Board, raw and individual-level data will not be made available.  

**Was data derived from another source?:** `Yes. Data was derived from data collected by private vendors: Umojo, Inrix, and Parkmobile. Data is intended to be made public in the interest of the exchange of information.`  

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's `Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1`(https://doi.org/10.21949/1520559) and `guidelines suggested by the DOT Public Access website`(https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  

File List for the `Insert Full Dataset ZIP File Name Here: Ex: 12348_DATASET`  

>  1. Filename: `AirQuality`
>  Short Description:  `Air pollution data in six-hour intervals for the period of August 15 to September 15, 2025.`

>  2. Filename: `Inrix_areas`
>  Short Description:  `Curb areas consisting of one or more curb zone per area.`

>  3. Filename: `Inrix_meters`
>  Short Description:  `Location and attributes of parking meters. Includes the meter locations,  curb policies, curb zones and spaces, and information about ownership and maintenance of the meters.`

>  4. Filename: `Inrix_signs`
>  Short Description:  `Location and attributes of parking and traffic signs. Includes location,  curb polices, curb zones and spaces, and information about ownership and maintenance of the signs.`

>  5. Filename: `Inrix_zones`
>  Short Description:  `Describes the location and policies associated with curb zones.`

>  6. Filename: `Manual_data_collection`
>  Short Description:  `Data collected manually as a reference and comparison for other data collection techniques. Manual data collected between May 1 and May 4, 2024.`

>  7. Filename: `Minneapolis_Occupancy_report`
>  Short Description:  `Predictive parking availability by street and time-of-day. Dataset not complete citywide, and lacks block number.`

>  8. Filename: `NexCity_areas`
>  Short Description:  `Polygons of grouped curb areas for analysis purposes.`

>  9. Filename: `NexCity_events`
>  Short Description:  `Curb event data of the Nicollet Avenue Focus area (between 18th Street and the Midtown Greenway), from July 1 to September 15, 2025. Records between 6:00 and 17:59 daily.`

>  10. Filename: `NexCity_policies_rules`
>  Short Description:  `Policies and rules associated with curb zones.`

>  11. Filename: `NexCity_policies_timespans`
>  Short Description:  `Defines the times when a given policy or rule (from the NexCity policies_rules dataset) is effective.`

>  12. Filename: `NexCity_zones`
>  Short Description:  `Curb zones, indicating length, number of spaces, and space IDs.`

>  13. Filename: `OpenData_policies`
>  Short Description:  `Policies associated with curb zones.`

>  14. Filename: `OpenData_policies_timespans`
>  Short Description:  `Defines the times when a given policy or rule (from the OpenData_policies dataset) is effective.`

>  15. Filename: `OpenData_spaces`
>  Short Description:  `Location, length, width, and ID associated with curb spaces.`

>  16. Filename: `OpenData_zones`
>  Short Description:  `Curb zones, indicating length, number of spaces, and space IDs.`

>  17. Filename: `twincities-minneapolis_smart_project_area_export`
>  Short Description:  `Location of Inrix curb zones, areas, and spaces. Includes the Nicollet Avenue focus area.`

>  18. Filename: `Open Data Approach to Curbside Management_Implementation Report`
>  Short Description:  `The Implementation Report for Stage 1 of Minneapolis SMART grant. Covers what we did, the technologies deployed, data applicability, lessons learned, and at-scale/Stage 2 deployment readiness.`

>  19. Filename: `DMP Open_Data_Approach_to_Curbside_Management`
>  Short Description:  `The final data management plan for Stage 1 of Minneapolis SMART grant.`

## D. Methodological Information

**Description of methods used for collection/generation of data:** `Events data derived from computer-vision edge computing cameras located along the corridor, provided by Umojo. Digital twin inventory data collected using LiDAR scan. Inrix data utilizes an API connection with the citys asset management platform to locate signs, meters, and apply the associated policies to curb zones. ParkMobile data is based on sensors mounted to city fleet vehicles that scan and detect curb occupancies to generate predictive availability by time of day and day of week. Manual data collection was conducted by estimating the number of undelimited spaces along the corridor, and counting parked vehicle occupancy.`

**Instrument or software-specific information needed to interpret the data:** `All files are open source and do not require proprietary systems to open and interpret.`

## E. Data-Specific Information

1. `AirQuality`
- Number of variables (columns): `19`
- Number of cases/rows: `1,273`
- Each row represents: `Reading of one air quality monitor/pod for a six-hour interval.`
- Data Dictionary/Variable List: `AirQuality Data Dictionary`
- Missing data codes: `Null values are left blank.`

2. `Inrix_areas`
- Number of variables (columns): `6`
- Number of cases/rows: `84`
- Each row represents: `Curb area IDs and related curb zones.`
- Data Dictionary/Variable List: `Inrix_areas Data Dictionary`
- Missing data codes: `Null values are left blank.`

3. `Inrix_meters`
- Number of variables (columns): `20`
- Number of cases/rows: `49`
- Each row represents: `Location and attributes of parking meters.`
- Data Dictionary/Variable List: `Inrix_meters Data Dictionary`
- Missing data codes: `Null values are left blank.`

4. `Inrix_signs`
- Number of variables (columns): `20`
- Number of cases/rows: `185`
- Each row represents: `Location and attributes of parking and traffic signs.`
- Data Dictionary/Variable List: `Inrix_signs Data Dictionary`
- Missing data codes: `Null values are left blank.`

5. `Inrix_zones`
- Number of variables (columns): `26`
- Number of cases/rows: `562`
- Each row represents: `Curb zone ids and related information or descriptions.`
- Data Dictionary/Variable List: `Inrix_zones Data Dictionary`
- Missing data codes: `Null values are left blank.`

6. `Manual_data_collection`
- Number of variables (columns): `25`
- Number of cases/rows: `22`
- Each row represents: `A blockface within the study corridor.`
- Data Dictionary/Variable List: `Manual_data_collection Data Dictionary`
- Missing data codes: `Null values are left blank. Zero values are actual data, indicating a lack of presence of parked vehicles.`

7. `Minneapolis_Occupancy_report`
- Number of variables (columns): `5`
- Number of cases/rows: `249,312`
- Each row represents: `Predicted parking availability on a given street, by time of day and day of week. Each street is associated with 48 times and 7 days a week, for a total of 336 records associated with each street.`
- Data Dictionary/Variable List: `Minneapolis_Occupancy_report Data Dictionary`
- Missing data codes: `Block numbers are missing from the data, as they were omitted by the vendor.`

8. `NexCity_areas`
- Number of variables (columns): `6`
- Number of cases/rows: `33`
- Each row represents: `Curb Area ID.`
- Data Dictionary/Variable List: `NexCity_areas Data Dictionary`
- Missing data codes: `Null values are left blank.`

9. `NexCity_events`
- Number of variables (columns): `26`
- Number of cases/rows: `273,956`
- Each row represents: `Event ID.`
- Data Dictionary/Variable List: `NexCity_events Data Dictionary`
- Missing data codes: `Null values are left blank.`

10. `NexCity_policies_rules`
- Number of variables (columns): `20`
- Number of cases/rows: `273`
- Each row represents: `Policy ID (rules).`
- Data Dictionary/Variable List: `NexCity_polices_rules Data Dictionary`
- Missing data codes: `Null values are left blank.`

11. `NexCity_policies_timespans`
- Number of variables (columns): `10`
- Number of cases/rows: `256`
- Each row represents: `Policy ID (timespans).`
- Data Dictionary/Variable List: `NexCity_polices_timespans Data Dictionary`
- Missing data codes: `Null values are left blank.`

12. `NexCity_zones`
- Number of variables (columns): `24`
- Number of cases/rows: `4,292`
- Each row represents: `CurbZones ID.`
- Data Dictionary/Variable List: `NexCity_zones Data Dictionary`
- Missing data codes: `Null values are left blank.`

13. `OpenData_policies`
- Number of variables (columns): `32`
- Number of cases/rows: `181`
- Each row represents: `Policy ID (rules).`
- Data Dictionary/Variable List: `OpenData_policies Data Dictionary`
- Missing data codes: `Null values are listed as NULL.`

14. `OpenData_policies_timespans`
- Number of variables (columns): `27`
- Number of cases/rows: `173`
- Each row represents: `Policy ID (timespan).`
- Data Dictionary/Variable List: `OpenData_policies_timespan Data Dictionary`
- Missing data codes: `Null values are listed as NULL.`

15. `OpenData_spaces`  
- Number of variables (columns): `11`
- Number of cases/rows: `330`
- Each row represents: `Curb Space ID.`
- Data Dictionary/Variable List: `OpenData_spaces Data Dictionary`
- Missing data codes: `Null values are listed as NULL.`

16. `OpenData_zones`
- Number of variables (columns): `24`
- Number of cases/rows: `97`
- Each row represents: `Curb Zone ID.`
- Data Dictionary/Variable List: `OpenData_zones Data Dictionary`
- Missing data codes: `Null values are listed as NULL.`

## F. Update Log

This Open Data Approach to Curbside Management README.txt file was originally created on `2026-01-14` by `Dillon Fried`(https://orcid.org/0009-0002-4951-2712), `Mobility and Curbside Manager, City of Minneapolis`, (dillon.fried@minneapolismn.gov).

`2026-01-14`: Original file created
