# SMART Grant: GPS-based Cloud TSP and EVP System — Stage 1 Dataset (RTC Southern Nevada)

## Overview

This repository contains the sample Stage 1 dataset produced by the Regional Transportation Commission of Southern Nevada (RTC-FAST) as part of the U.S. DOT FY22 SMART Grant project **“Safer, Smarter, Faster: Pairing Cloud-Based Transit Signal Priority (TSP) and Advanced Intersection Analytics (AIA)”**. 
The dataset supports the project’s evaluation of cloud-based TSP along RTC Transit Route 206 and AI-driven Advanced Intersection Analytics at 20 intersections in downtown Las Vegas and the Las Vegas Medical District. 
No personally identifiable information (PII) is included.

## Abstract
RTC’s Safer, Smarter, Faster smart technology traffic signal project utilized a cloud-based signal timing optimization system that supports transit signal priority (TSP) and enhances safety using artificial intelligence intersection analytics (AIA).  The limits for Stage 1 pilot project encompass UMC hospital and downtown Las Vegas. Intersection analytics were deployed at 20 signalized intersections within the project limits.  TSP was deployed along RTC Transit Route 206 at 17 signalized intersections along Charleston Boulevard and Casino Center Boulevard.  This route often experiences lower on-time performance (OTP) scores than many other routes in the region, while being the 3rd highest passenger route. 
Evaluation results showed weekday on-time performance improved by 3–6%, with delays reduced 7–13% and average savings of up to 78 seconds per trip. The AIA system achieved 92.2% accuracy for traffic detection and 97.6% precision in identifying red-light running and near-miss events.

## DOIs
- **Data Management Plan (DMP) DOI**: https://doi.org/10.48321/D1V37D
- **National Transportation Library (NTL) DOI**: https://doi.org/10.21949/1403458

## What’s here

* `Data_Dictionary.csv` — comprehensive schema for all tables

* `derq_arrivals_on_red_fact_table.csv` — data table (see `Data_Dictionary.csv`)
* `derq_queue_length_fact_table.csv` — data table (see `Data_Dictionary.csv`)
* `derq_safety_event_fact_table.csv` — data table (see `Data_Dictionary.csv`)
* `derq_vehicle_delay_fact_table.csv` — data table (see `Data_Dictionary.csv`)
* `derq_volume_fact_table.csv` — data table (see `Data_Dictionary.csv`)
* `intersection_dim_table.csv` — data table (see `Data_Dictionary.csv`)
* `swiftly_otp_fact_table.csv` — data table (see `Data_Dictionary.csv`)
* `traction_tsp_log_fact_table.csv` — data table (see `Data_Dictionary.csv`)
* `traffic_ware_log_fact_table.csv` — data table (see `Data_Dictionary.csv`)

## Coverage

* **Temporal**: Pre-implementation Dec 1–31, 2024; Post-implementation Feb 12–May 15, 2025

* **Spatial**: Downtown Las Vegas & Las Vegas Medical District; Clark County, NV


## Provenance & Generation

- **TSP** data originate from Kimley-Horn Traction Priority integrated with ATMS.now and RTC transit CAD/AVL/GTFS feeds.
- **AIA** data originate from Derq’s video analytics using existing intersection video detection.

## File-level schema previews

### derq_arrivals_on_red_fact_table

| Variable                      | DType   | Definition                                                        |
|:------------------------------|:--------|:------------------------------------------------------------------|
| date                          | date    | date                                                              |
| total_vehicles                | int     | Total number of vehicles arrived                                  |
| total_vehicles_arrived_on_red | int     | Total number of vehicles arrived on red                           |
| %_vehicles_arrived_on_red     | float   | Percent of vehicles arriving on red                               |
| intersection_id               | int     | Internal intersection ID for data relationships                   |
| time                          | time    | time                                                              |
| approach                      | string  | Vehicle direction of approach (NB, SB, EB, WB)                    |
| lane                          | float   | Vehicle lane of travel, counted from right most lane to center    |
| movement                      | string  | Vehicle movement at intersection (Right Turn, Left Turn, Through) |

_See `Data_Dictionary.csv` for full column list and definitions._

### derq_event_fact_table

| Variable       | DType   | Definition                                                                                         |
|:---------------|:--------|:---------------------------------------------------------------------------------------------------|
| event_id       | string  | Internal ID to track events                                                                        |
| event_type     | string  | Type of event (nearmiss, traffic violations, etc)                                                  |
| detection_area | string  | Where the event occurred in relation to the intersection                                           |
| speed_mph      | float   | Speed of vehicle involved in event (if a vehicle was involved)                                     |
| nearmiss_type  | string  | Impetus for near miss events (cut off, right of way)                                               |
| pet            | float   | Post Encroachment Time                                                                             |
| ttc            | float   | Time To Collision                                                                                  |
| gap_time       | float   | Time between lead vehicle/pedestrian passing a point and the following vehicle/pedestrian arriving |
| severity       | string  | Event severity (Low, Moderate, Severe)                                                             |
| involved       | string  | Involved parties (vehicle and/or VRU classifications)                                              |

_See `Data_Dictionary.csv` for full column list and definitions._

### derq_queue_length_fact_table

| Variable                  | DType   | Definition                                                        |
|:--------------------------|:--------|:------------------------------------------------------------------|
| date                      | date    | date                                                              |
| estimated_queue_length_ft | float   | Estimated queue length in ft                                      |
| intersection_id           | int     | Internal intersection ID for data relationships                   |
| time                      | time    | time                                                              |
| approach                  | string  | Vehicle direction of approach (NB, SB, EB, WB)                    |
| lane                      | float   | Vehicle lane of travel, counted from right most lane to center    |
| movement                  | string  | Vehicle movement at intersection (Right Turn, Left Turn, Through) |

_See `Data_Dictionary.csv` for full column list and definitions._

### derq_vehicle_delay_fact_table

| Variable                            | DType   | Definition                                                        |
|:------------------------------------|:--------|:------------------------------------------------------------------|
| date                                | date    | date                                                              |
| total_vehicle_delay                 | float   | Vehicle delay at signal                                           |
| total_delay_due_to_arrived_on_red   | float   | Vehicle delay at signal due to arrival on red                     |
| average_vehicle_delay               | float   | Per vehicle delay                                                 |
| average_delay_due_to_arrived_on_red | float   | Per vehicle delay due to arrival on red                           |
| intersection_id                     | int     | Internal intersection ID for data relationships                   |
| time                                | time    | time                                                              |
| approach                            | string  | Vehicle direction of approach (NB, SB, EB, WB)                    |
| lane                                | float   | Vehicle lane of travel, counted from right most lane to center    |
| movement                            | string  | Vehicle movement at intersection (Right Turn, Left Turn, Through) |

_See `Data_Dictionary.csv` for full column list and definitions._

### derq_volume_fact_table

| Variable        | DType   | Definition                                                              |
|:----------------|:--------|:------------------------------------------------------------------------|
| volume          | int     | Count of vehicles                                                       |
| date            | date    | date                                                                    |
| lane            | float   | Vehicle lane of travel, counted from right most lane to center          |
| approach        | string  | Vehicle direction of approach (NB, SB, EB, WB)                          |
| movement        | string  | Vehicle movement at intersection (Right Turn, Left Turn, Through)       |
| class           | string  | Vehicle or VRU classification (passenger vehicle, motorcycle, bus, etc) |
| time            | time    | Start time of five minute data collection interval                      |
| intersection_id | int     | Internal intersection ID for data relationships                         |

_See `Data_Dictionary.csv` for full column list and definitions._

### intersection_dim_table

| Variable        | DType   | Definition                                             |
|:----------------|:--------|:-------------------------------------------------------|
| intersection_id | int     | Internal intersection ID for data relationships        |
| evp             | string  | Whether or not EVP is enabled for the location         |
| tsp             | string  | Whether or not TSP is enabled for the location         |
| derq            | string  | Whether or not DERQ data is collected for the location |
| address         | string  | Full location address                                  |
| neighborhood    | string  | Neighborhood of location                               |
| longitude       | float   | intersection coordinate longitude                      |
| latitude        | float   | intersection coordinate latitude                       |
| street_1        | string  | Name of first cross street                             |
| street_2        | string  | name of second cross street                            |

_See `Data_Dictionary.csv` for full column list and definitions._

### swiftly_otp_fact_table

| Variable       | DType    | Definition                                                                                 |
|:---------------|:---------|:-------------------------------------------------------------------------------------------|
| early          | int      | Number of vehicles arrived early                                                           |
| late           | int      | Number of vehicles arrived late                                                            |
| total          | int      | Total number of vehicles arrived                                                           |
| directionid    | string   | Id for vehicle direction of travel                                                         |
| stopid         | string   | Id for stop                                                                                |
| stopname       | string   | Name for stop                                                                              |
| ontime         | int      | Number of vehicles arrived on time                                                         |
| window         | int      | Time in minutes that a vehicle can be early or late without being counted as early or late |
| start_datetime | datetime | Start datetime of fifteen minute data collection interval                                  |
| routeid        | string   | Route Id of vehicles                                                                       |

_See `Data_Dictionary.csv` for full column list and definitions._

### traction_tsp_log_fact_table

| Variable               | DType   | Definition                                                              |
|:-----------------------|:--------|:------------------------------------------------------------------------|
| route                  | string  | Route of specific bus                                                   |
| phase                  | int     | Current signal phase                                                    |
| approach               | string  | Vehicle direction of approach (NB, SB, EB, WB)                          |
| signal                 | string  | Internal signal ID                                                      |
| vehicle_id             | string  | Interval vehicle ID                                                     |
| geofence_entered       | string  | Time vehicle entered geofence                                           |
| geofence_exited        | string  | Time vehicle exited geofence                                            |
| tsp_granted            | bool    | Whether or not TSP was granted for the vehicle                          |
| signal_response        | string  | Signal behavior when TSP was granted (Monitor, Early or Extended Green) |
| geofence_travel_time_s | int     | Time vehicle took to travel the length of the geofence                  |

_See `Data_Dictionary.csv` for full column list and definitions._

### traffic_ware_log_fact_table

| Variable       | DType    | Definition                                                         |
|:---------------|:---------|:-------------------------------------------------------------------|
| id             | int      | Internal signal ID                                                 |
| name           | string   | Signal name                                                        |
| start_datetime | datetime | Start datetime of TSP event                                        |
| end_datetime   | datetime | End datetime of TSP event                                          |
| priority       | string   | Signal response to TSP event (LOCKOUT, REDUCE, EXTEND, FREE, NONE) |
| sec_s          | int      | Duration of TSP event (seconds)                                    |
| headway_mm:ss  | string   | Headway time of vehicle                                            |
| red_time_s     | int      | Vehicle time waiting at red                                        |
| cycle_s        | float    | Cycle length time                                                  |
| time_saved_s   | float    | Calculated time saved for vehicle from granting of TSP event       |

_See `Data_Dictionary.csv` for full column list and definitions._

## Data dictionary

See `Data_Dictionary.csv` in this package for complete schemas, data types, and field definitions.

## Quality notes & known limitations

- AIA traffic count accuracy exceeded 90% overall; VRU counts can be lower where the camera field of view is limited.
- Speed reporting requires additional vendor parameter controls for full validation.
- Signal Performance Measures (SPMs) from the AIA package were not validated in Stage 1 and should be used with caution.

## Licensing & access

Unless otherwise specified by USDOT submission guidance, this dataset is released for public access with attribution to RTC-FAST and project partners. No PII or license-plate data are present. 

## How to cite

Regional Transportation Commission of Southern Nevada (2025). SMART Grant: GPS-based Cloud TSP and EVP System — Stage 1 Dataset. RTC-FAST. 

## Contact

**Publisher**: Regional Transportation Commission of Southern Nevada (RTC-FAST)
**Contact**: Christina Karanikolas karanikolasc@rtcsnv.com

## Versioning

Metadata prepared 2025-08-21. This package contains sample extracts representative of the full dataset.
