# C2SMART Lab, NYU
# @file    Event_Test.py
# @author  Fan Zuo
# @date    2021-02-06

import traci
import os
import sys
import keyboard
import time


NetworkName = "Willoughby.sumocfg"

def StartSumo(network):
    if 'SUMO_HOME' in os.environ:
        tools = os.path.join(os.environ['SUMO_HOME'], 'tools')
        sys.path.append(tools)
    else:
        sys.exit("please declare environment variable 'SUMO_HOME'")

    sumoBinary = "C:/Program Files (x86)/Eclipse/Sumo/bin/sumo-gui"  # "C:/Sumo/bin/sumo-gui"
    FolderPath = "./"
    sumoCmd = [sumoBinary, "-c",
               FolderPath + network]#, "--start"]
    traci.start(sumoCmd)

    print("Sumo is running")

if __name__ == "__main__":
    StartSumo(NetworkName)
    #step = 0
    
    
    while traci.simulation.getMinExpectedNumber() > 0: 
        #keyboard.add_hotkey('space', print, args=['space was pressed',traci.simulation.getTime()])
        traci.simulationStep()
        print ("Acc Car's Leader:",traci.vehicle.getLeader("Accident"))
        #Generate the accident in front of the first barrel
        try:
            if traci.vehicle.getLaneID("Accident") == "802705820_2" and float(traci.vehicle.getLanePosition("Accident")) > 33 and float(traci.vehicle.getLanePosition("Accident")) < 35:
                print("Collision testing starting!")
                traci.vehicle.setSpeedMode("Accident", 0)
                traci.vehicle.setSpeed("Accident", 10)
        except:
            pass

        #Safezone speeding warning
        # if traci.lanearea.getLastStepVehicleNumber("WarnZone1")>0:
        #     for veh in traci.lanearea.getLastStepVehicleIDs("WarnZone1"):
        #         if traci.vehicle.getSpeed(veh) > 12:
        #             print ("Warning: Speeding Vehicle %s detected in the warning zone1!" % (veh))
        # if traci.lanearea.getLastStepVehicleNumber("WarnZone2")>0:
        #     for veh in traci.lanearea.getLastStepVehicleIDs("WarnZone2"):
        #         if traci.vehicle.getSpeed(veh) > 12:
        #             print ("Warning: Speeding Vehicle %s detected in the warning zone2!" % (veh))

        if keyboard.is_pressed('0'):
            print("Send the Accident Vehicle",traci.simulation.getTime())
            #traci.vehicle.moveToXY("Barrel1", "-gneE2", 0, 490.67, 429.49, keepRoute=2)
            traci.vehicle.moveToXY("Accident", "222246977.17", 0, 225.44, 454.43, keepRoute=2)
            # print ("before",traci.simulation.getTime())
            #traci.vehicle.setRoute('Barrel1', ['-gneE2'])
            time.sleep(0.1)
            traci.simulationStep()         
            #stop_pos = traci.vehicle.getLanePosition("Barrel1")
            # traci.vehicle.setRoute("Barrel1", ["-37394899#1 -37394899#0 gneE3 gneE0 -gneE2 -37394899#2 "])
            #traci.vehicle.setStop("Barrel1", "-gneE2", stop_pos+0.01, 0)
            traci.vehicle.setSpeed("Accident", 10)


        #if xxx.received_message=100001:
        # if keyboard.is_pressed('1'):
        #     print("Pressed",traci.simulation.getTime())
        #     #traci.vehicle.moveToXY("Barrel1", "-gneE2", 0, 490.67, 429.49, keepRoute=2)
        #     traci.vehicle.moveTo("Barrel1", "-gneE2_0", 73)
        #     #traci.vehicle.moveToXY("Barrel1", "-gneE2", 0, 489.56, 429.65, keepRoute=2)
        #     print ("before",traci.simulation.getTime())
        #     #traci.vehicle.setRoute('Barrel1', ['-gneE2'])
        #     time.sleep(0.1)
        #     traci.simulationStep()         
        #     #stop_pos = traci.vehicle.getLanePosition("Barrel1")
        #     # traci.vehicle.setRoute("Barrel1", ["-37394899#1 -37394899#0 gneE3 gneE0 -gneE2 -37394899#2 "])
        #     #traci.vehicle.setStop("Barrel1", "-gneE2", stop_pos+0.01, 0)
        #     traci.vehicle.setSpeed("Barrel1", 0)
        # elif keyboard.is_pressed('2'):
        #     print("Pressed",traci.simulation.getTime())
        #     traci.vehicle.moveToXY("Barrel2", "-gneE2", 0, 490.54, 434.43, keepRoute=2)
        #     print ("before",traci.simulation.getTime())
        #     #traci.vehicle.setRoute('Barrel2', ['-gneE2'])
        #     time.sleep(0.1)
        #     traci.simulationStep()         
        #     #stop_pos = traci.vehicle.getLanePosition("Barrel2")
        #     # traci.vehicle.setRoute("Barrel1", ["-37394899#1 -37394899#0 gneE3 gneE0 -gneE2 -37394899#2 "])
        #     #traci.vehicle.setStop("Barrel2", "-gneE2", stop_pos+0.01, 0)
        #     traci.vehicle.setSpeed("Barrel2", 0)
        # elif keyboard.is_pressed('3'):
        #     print("Pressed",traci.simulation.getTime())
        #     traci.vehicle.moveToXY("Barrel3", "-gneE2", 0, 490.06, 439.17, keepRoute=2)
        #     print ("before",traci.simulation.getTime())
        #     #traci.vehicle.setRoute('Barrel3', ['-gneE2'])
        #     time.sleep(0.1)
        #     traci.simulationStep()         
        #     #stop_pos = traci.vehicle.getLanePosition("Barrel3")
        #     # traci.vehicle.setRoute("Barrel1", ["-37394899#1 -37394899#0 gneE3 gneE0 -gneE2 -37394899#2 "])
        #     #traci.vehicle.setStop("Barrel3", "-gneE2", stop_pos+0.02, 0)
        #     traci.vehicle.setSpeed("Barrel3", 0)
        # elif keyboard.is_pressed('4'):
        #     print("Pressed",traci.simulation.getTime())
        #     traci.vehicle.moveToXY("Barrel4", "-gneE2", 0, 489.20, 444.21, keepRoute=2)
        #     print ("before",traci.simulation.getTime())
        #     #traci.vehicle.setRoute('Barrel4', ['-gneE2'])
        #     time.sleep(0.1)
        #     traci.simulationStep()         
        #     #stop_pos = traci.vehicle.getLanePosition("Barrel4")
        #     # traci.vehicle.setRoute("Barrel1", ["-37394899#1 -37394899#0 gneE3 gneE0 -gneE2 -37394899#2 "])
        #     #traci.vehicle.setStop("Barrel4", "-gneE2", stop_pos+0.02, 0)
        #     traci.vehicle.setSpeed("Barrel4", 0)
        # elif keyboard.is_pressed('5'):
        #     print("Pressed",traci.simulation.getTime())
        #     traci.vehicle.moveToXY("Barrel5", "-gneE2", 0, 487.87, 448.40, keepRoute=2)
        #     print ("before",traci.simulation.getTime())
        #     #traci.vehicle.setRoute('Barrel5', ['-gneE2'])
        #     time.sleep(0.1)
        #     traci.simulationStep()         
        #     #stop_pos = traci.vehicle.getLanePosition("Barrel5")
        #     # traci.vehicle.setRoute("Barrel1", ["-37394899#1 -37394899#0 gneE3 gneE0 -gneE2 -37394899#2 "])
        #     #traci.vehicle.setStop("Barrel5", "-gneE2", stop_pos+0.02, 0)
        #     traci.vehicle.setSpeed("Barrel5", 0)
        # elif keyboard.is_pressed('6'):
        #     print("Pressed",traci.simulation.getTime())
        #     traci.vehicle.moveToXY("Barrel6", "-gneE2", 0, 486.70, 453.00, keepRoute=2)
        #     print ("before",traci.simulation.getTime())
        #     #traci.vehicle.setRoute('Barrel6', ['-gneE2'])
        #     time.sleep(0.1)
        #     traci.simulationStep()         
        #     #stop_pos = traci.vehicle.getLanePosition("Barrel6")
        #     # traci.vehicle.setRoute("Barrel1", ["-37394899#1 -37394899#0 gneE3 gneE0 -gneE2 -37394899#2 "])
        #     #traci.vehicle.setStop("Barrel6", "-gneE2", stop_pos+0.02, 0)
        #     traci.vehicle.setSpeed("Barrel6", 0)
        # else:
        #     pass

        if traci.simulation.getCollidingVehiclesNumber()>0:
            print (traci.simulation.getCollidingVehiclesIDList())
            for accident in traci.simulation.getCollidingVehiclesIDList():
                if "Barrel" in accident:
                    print ("Warning: Vehicle hit the barrel!")
                    traci.vehicle.setSpeedMode("Accident", 31)

        print ("Barrel Loc:",traci.vehicle.getPosition('Barrel1'), "Barrel Lat:",traci.vehicle.getLateralLanePosition('Barrel1'))
        print ("Acc Loc:",traci.vehicle.getPosition('Accident'), "Acc Lat:",traci.vehicle.getLateralLanePosition('Accident'))

    traci.close()