# C2SMART Lab, NYU
# @file    Event_Test.py
# @author  Fan Zuo
# @date    2021-02-06

import traci
import os
import sys
import keyboard
import time


NetworkName = "Network_BQE2.sumocfg"

def StartSumo(network):
    if 'SUMO_HOME' in os.environ:
        tools = os.path.join(os.environ['SUMO_HOME'], 'tools')
        sys.path.append(tools)
    else:
        sys.exit("please declare environment variable 'SUMO_HOME'")

    sumoBinary = "C:/Program Files (x86)/Eclipse/Sumo/bin/sumo-gui"  # "C:/Sumo/bin/sumo-gui"
    FolderPath = "./"
    sumoCmd = [sumoBinary, "-c",
               FolderPath + network]#, "--start"]
    traci.start(sumoCmd)

    print("Sumo is running")

if __name__ == "__main__":
    StartSumo(NetworkName)
    #step = 0
    
    
    while traci.simulation.getMinExpectedNumber() > 0: 
        #keyboard.add_hotkey('space', print, args=['space was pressed',traci.simulation.getTime()])
        traci.simulationStep()
        # If you want to place the barrels, just adjust the coordinates in the "moveToXY" function.
        # if traci.simulation.getTime() == 0.1:
        #     traci.vehicle.moveToXY("Barrel1", "38254377", 0, 1053.09, 1266.28, keepRoute=2)
        #     traci.vehicle.setSpeed("Barrel1", 0)
        #     traci.vehicle.moveToXY("Barrel2", "38254377", 0, 1048.03, 1267.18, keepRoute=2)
        #     traci.vehicle.setSpeed("Barrel2", 0)
        #     traci.vehicle.moveToXY("Barrel3", "38254377", 1, 1043.26, 1265.32, keepRoute=2)
        #     traci.vehicle.setSpeed("Barrel3", 0)
        #     traci.vehicle.moveToXY("Barrel4", "38254377", 1, 1038.59, 1265.98, keepRoute=2)
        #     traci.vehicle.setSpeed("Barrel4", 0)
        #     traci.vehicle.moveToXY("Barrel5", "38254377", 1, 1034.70, 1266.93, keepRoute=2)
        #     traci.vehicle.setSpeed("Barrel5", 0)

        # If you want to retrieve the coordinates of the barrels, just use the following function:
        # traci.vehicle.getPosition("Barrel1")
        # It will return the coordinates of object "Barrel1" in meters.

        try:
            if traci.vehicle.getLaneID("Accident") == "38254377_0" and float(traci.vehicle.getLanePosition("Accident")) > 62 and float(traci.vehicle.getLanePosition("Accident")) < 65:
                print("Collision testing starting!")
                traci.vehicle.setSpeedMode("Accident", 0)
                traci.vehicle.setSpeed("Accident", 13)
            elif traci.vehicle.getLaneID("Accident") == "38254377_1" and float(traci.vehicle.getLanePosition("Accident")) > 70 and float(traci.vehicle.getLanePosition("Accident")) < 75:
                print("Collision testing starting!")
                traci.vehicle.setSpeedMode("Accident", 0)
                traci.vehicle.setSpeed("Accident", 13)
        except:
            pass

        #Safezone speeding warning
        if traci.lanearea.getLastStepVehicleNumber("WarnZone1")>0:
            for veh in traci.lanearea.getLastStepVehicleIDs("WarnZone1"):
                if traci.vehicle.getSpeed(veh) > 16:
                    print ("Warning: Speeding Vehicle %s detected in the warning zone 1!" % (veh))
        if traci.lanearea.getLastStepVehicleNumber("WarnZone2")>0:
            for veh in traci.lanearea.getLastStepVehicleIDs("WarnZone2"):
                if traci.vehicle.getSpeed(veh) > 16:
                    print ("Warning: Speeding Vehicle %s detected in the warning zone 2!" % (veh))
        # if traci.lanearea.getLastStepVehicleNumber("WarnZone3")>0:
        #     for veh in traci.lanearea.getLastStepVehicleIDs("WarnZone3"):
        #         if traci.vehicle.getSpeed(veh) > 16:
        #             print ("Warning: Speeding Vehicle %s detected in the warning zone 3!" % (veh))

        #Alt1: Workzone conflict warning
        # if traci.lanarea.getLastStepVehicleNumber("WorkZone")>0:
        #     for veh in traci.lanearea.getLastStepVehicleIDs("WorkZone"):
        #         print ("Warning: Vehicle %s hit the work zone!" % (veh))
        
        #Alt2: Collision simulation and warning
        if traci.simulation.getCollidingVehiclesNumber()>0:
            for accident in traci.simulation.getCollidingVehiclesIDList():
                if "Barrel" in accident:
                    print ("Warning: Vehicle hit the barrel!")
                    traci.vehicle.setSpeedMode("Accident", 31)

        #Reroute the vehicles
        if traci.edge.getLastStepVehicleNumber("46121845")>0:
            for veh in traci.edge.getLastStepVehicleIDs("46121845"):
                traci.vehicle.moveTo(veh, "46819498_1", 20)

    traci.close()