# Data from: Understanding real-world brake activity: A key to assessing non-tailpipe emission sources for sustainable transportation and communities

[https://doi.org/10.5061/dryad.41ns1rnrp](https://doi.org/10.5061/dryad.41ns1rnrp)

## Description of the data and file structure

This dataset compiles multi-sensor data collected to analyze vehicle braking events and associated non-tailpipe particulate matter emissions at urban intersections. Data sources include GPS logs, LiDAR point clouds, video recordings, and onboard vehicle sensors. The dataset supports research on vehicle dynamics, braking behavior analysis, trajectory refinement, and emission estimation.

### Files and variables

#### File: tableview\_250127\_050942.csv

**Description:** 

##### Variables

* Index: Sequential index of the data points.
* Lat (degrees): Latitude of the vehicle's location.
* Lon (degrees): Longitude of the vehicle's location.
* CoG (degrees): Course over ground (direction of movement).
* SoG (m/s): Speed over ground (vehicle speed).
* UTC ((hh:mm:ss)): Coordinated Universal Time timestamp.
* Alt (MSL) (m): Altitude above mean sea level.
* Alt (HAE) (m): Altitude above the WGS84 ellipsoid.

#### File: COM13\_250103\_014834.ubx

**Description:** This is raw GPS data of the probe vehicle collected by a u-blox GPS receiver. Similar to the CSV file above, it includes fields like `Index`, `Lat`, `Lon`, `CoG`, `SoG`, `UTC`, `Alt (MSL)`, and `Alt (HAE)`.

#### File: NCST250102\_0.7z

**Description:** A compressed (7z) archive of the raw LiDAR point cloud data (DB3 format), providing a compact alternative to the standalone DB3 file.

#### File: output\_2025-01-02\_18-01-03.txt

**Description**: This file contains brake status and brake pressure data of the probe vehicle.

##### Variables

* time: Universal Time timestamp.
* BRAKE_PRESSED: Status of the brake on/off
* BRAKE_PRESSURE (PSI): Brake pressure in PSI

#### File: egovehicle\_trip\_2.csv

**Description**: This is processed probe vehicle data in CSV format.

##### Variables

* Time (s): Time elapsed in seconds.
* Acceleration (m/s^2): Vehicle acceleration in meters per second squared.
* Speed (m/s): Vehicle speed in meters per second.
* Distance (m): Distance traveled in meters.
* Brake Pressure (PSI): Brake pressure in pounds per square inch.
* Brake Status: Status of the brake system.

#### File: egovehicle\_trip\_1.csv

**Description**: Same as the previous file (`egovehicle_trip_2.csv`), containing processed probe vehicle data.

#### File: egovehicle\_trip\_0.csv

**Description**: Same as the previous files (`egovehicle_trip_2.csv` and `egovehicle_trip_1.csv`), containing processed probe vehicle data.

#### File: preds.7z

**Description**: This is a compressed archive containing LiDAR detection bounding box results.
**Content**:

* The archive contains multiple files named by timestamps.
* Each file includes bounding box information
  * Bounding box center position (x, y, z in meter)
  * Bounding box size (length in meter)
  * Bounding box orientation (pitch, roll, yaw in degree)
  * classification (standardized vehicle categories)
  * confidence scores (0-1)

#### File: 155xy\_magnitude\_data\_10hz.csv

**Description**: LiDAR-detected, refined trajectory and brake status data (labeled via camera observations).

##### Variables

* Time (s): Time elapsed in seconds.
* Acceleration (m/s^2): Vehicle acceleration in meters per second squared.
* Speed (m/s): Vehicle speed in meters per second.
* Distance (m): Distance to intersection in meters.
* Brake Status: Status of the brake system.

#### File: 163xy\_magnitude\_data\_10hz.csv

**Description**: A similar refined trajectory file with brake status labels, in the same format as the 155xy file.

#### File: 403xy\_magnitude\_data\_10hz.csv

**Description**: A similar refined trajectory file with brake status labels, in the same format as the 155xy file.

#### File: 575xy\_magnitude\_data\_10hz.csv

**Description**: A similar refined trajectory file with brake status labels, in the same format as the 155xy file.

#### File: 718xy\_magnitude\_data\_10hz.csv

**Description**: A similar refined trajectory file with brake status labels, in the same format as the 155xy file.
