export default function PrivacyPolicy() {
  return (
    <div className="h-screen flex-auto flex-col">
      <h1>PRIVACY POLICY</h1>
      <h3>Last updated July 18, 2024</h3>

      <p>
        This privacy notice for UC Davis Mobility Study ( " <b>we</b> ," "{" "}
        <b>us</b> ," or " <b>our</b> " ), describes how and why we might
        collect, store, use, and/or share ( " <b>process</b> " ) your
        information when you use our services ( " <b>Services</b> " ), such as
        when you:
      </p>

      <ul>
        <li>
          Visit our website at
          https://odometer-reading-remix-dnfvejf9arcreaa9.westus-01.azurewebsites.net/privacy-policy/
          , or any website of ours that links to this privacy notice
        </li>
        <li>
          Engage with us in other related ways, including any sales, marketing,
          or events
        </li>
      </ul>

      <p>
        <b>Question or concerns?</b> Reading this privacy notice will help you
        understand your privacy rights and choices. If you do not agree with our
        policies and practices, please do not use our Services. If you still
        have any questions or concerns, please contact us at
        mobilitystudy@ucdavis.edu
      </p>

      <h2>SUMMARY OF KEY POINTS</h2>

      <p>
        <i>
          <b>
            This summary provides key points from our privacy notice, but you
            can find out more details about any of these topics by clicking the
            link following each key point or by using our table of contents
            below to find the section you are looking for.
          </b>
        </i>
      </p>

      <p>
        <b>What personal information do we process?</b> When you visit, use, or
        navigate our Services, we may process personal information depending on
        how you interact with us and the Services, the choices you make, and the
        products and features you use. Learn more about personal information you
        disclose to us.
      </p>

      <p>
        <b>Do we process any sensitive personal information?</b> We do not
        process sensitive personal information.
      </p>

      <p>
        <b>Do we collect any information from third parties?</b> We may collect
        information from public databases, marketing partners, social media
        platforms, and other outside sources. Learn more about information
        collected from other sources.
      </p>

      <p>
        <b>How do we process your information?</b> We process your information
        to provide, improve, and administer our Services, communicate with you,
        for security and fraud prevention, and to comply with law. We may also
        process your information for other purposes with your consent. We
        process your information only when we have a valid legal reason to do
        so. Learn more about how we process your information.
      </p>

      <p>
        <b>
          In what situations and with which parties do we share personal
          information?
        </b>{" "}
        We may share information in specific situations and with specific third
        parties. Learn more about when and with whom we share your personal
        information .
      </p>

      <p>
        <b>How do we keep your information safe?</b> We have organizational and
        technical processes and procedures in place to protect your personal
        information. However, no electronic transmission over the internet or
        information storage technology can be guaranteed to be 100% secure, so
        we cannot promise or guarantee that hackers, cybercriminals, or other
        unauthorized third parties will not be able to defeat our security and
        improperly collect, access, steal, or modify your information. Learn
        more about how we keep your information safe.
      </p>

      <p>
        <b>What are your rights?</b> Depending on where you are located
        geographically, the applicable privacy law may mean you have certain
        rights regarding your personal information. Learn more about your
        privacy rights.
      </p>

      <p>
        <b>How do you exercise your rights?</b> The easiest way to exercise your
        rights is by visiting
        https://odometer-reading-remix-dnfvejf9arcreaa9.westus-01.azurewebsites.net/user-request/,
        or by contacting us. We will consider and act upon any request in
        accordance with applicable data protection laws.
      </p>

      <p>
        Want to learn more about what we do with any information we collect?
        Review the privacy notice in full.
      </p>

      <h2>TABLE OF CONTENTS</h2>

      <ol>
        <li>WHAT INFORMATION DO WE COLLECT?</li>
        <li>HOW DO WE PROCESS YOUR INFORMATION?</li>
        <li>WHEN AND WITH WHOM DO WE SHARE YOUR PERSONAL INFORMATION?</li>
        <li>HOW LONG DO WE KEEP YOUR INFORMATION?</li>
        <li>HOW DO WE KEEP YOUR INFORMATION SAFE?</li>
        <li>DO WE COLLECT INFORMATION FROM MINORS?</li>
        <li>WHAT ARE YOUR PRIVACY RIGHTS?</li>
        <li>CONTROLS FOR DO-NOT-TRACK FEATURES</li>
        <li>DO UNITED STATES RESIDENTS HAVE SPECIFIC PRIVACY RIGHTS?</li>
        <li>DO WE MAKE UPDATES TO THIS NOTICE?</li>
        <li>HOW CAN YOU CONTACT US ABOUT THIS NOTICE?</li>
        <li>
          HOW CAN YOU REVIEW, UPDATE, OR DELETE THE DATA WE COLLECT FROM YOU?
        </li>
      </ol>

      <h2>1. WHAT INFORMATION DO WE COLLECT?</h2>

      <h3>Personal information you disclose to us</h3>

      <p>
        <i>
          <b>In Short:</b> We collect personal information that you provide to
          us.
        </i>
      </p>

      <p>
        We collect personal information that you voluntarily provide to us when
        you express an interest in obtaining information about us or our
        products and Services, when you participate in activities on the
        Services, or otherwise when you contact us.
      </p>

      <p>
        <b>Personal Information Provided by You.</b> The personal information
        that we collect depends on the context of your interactions with us and
        the Services, the choices you make, and the products and features you
        use. The personal information we collect may include the following:
      </p>

      <ul>
        <li>phone numbers</li>
      </ul>

      <p>
        <b>Sensitive Information.</b> We do not process sensitive information.
      </p>

      <p>
        All personal information that you provide to us must be true, complete,
        and accurate, and you must notify us of any changes to such personal
        information.
      </p>

      <p>
        <i>
          <b>In Short:</b> We may collect limited data from public databases,
          marketing partners, and other outside sources.
        </i>
      </p>

      <p>
        In order to enhance our ability to provide relevant marketing, offers,
        and services to you and update our records, we may obtain information
        about you from other sources, such as public databases, joint marketing
        partners, affiliate programs, data providers, and from other third
        parties. This information includes mailing addresses, job titles, email
        addresses, phone numbers, intent data (or user behavior data), Internet
        Protocol (IP) addresses, social media profiles, social media URLs, and
        custom profiles, for purposes of targeted advertising and event
        promotion.
      </p>

      <h2>2. HOW DO WE PROCESS YOUR INFORMATION?</h2>

      <p>
        <i>
          <b>In Short:</b> We process your information for purposes based on
          legitimate business interests, the fulfillment of our contract with
          you, compliance with our legal obligations, and/or your consent.
        </i>
      </p>

      <p>
        <b>
          We process your personal information for a variety of reasons,
          depending on how you interact with our Services, including:
        </b>
      </p>

      <ul>
        <li>
          <b>To administer prize draws and competitions.</b> We may process your
          information to administer prize draws and competitions.
        </li>
        <li>
          <b>Statistical analysis of vehicle miles traveled.</b> As a part of an
          academic research project, we will collect the user's odometer reading
          photos.
        </li>
      </ul>

      <h2>3. WHEN AND WITH WHOM DO WE SHARE YOUR PERSONAL INFORMATION?</h2>

      <p>
        <i>
          <b>In Short:</b> We may share information in specific situations
          described in this section and/or with the following third parties.
        </i>
      </p>

      <p>
        We may need to share your personal information in the following
        situations:
      </p>

      <ul>
        <li>
          <b>Business Transfers.</b> We may share or transfer your information
          in connection with, or during negotiations of, any merger, sale of
          company assets, financing, or acquisition of all or a portion of our
          business to another company.
        </li>
      </ul>

      <h2>4. HOW LONG DO WE KEEP YOUR INFORMATION?</h2>

      <p>
        <i>
          <b>In Short:</b> We keep your information for as long as necessary to
          fulfill the purposes outlined in this privacy notice unless otherwise
          required by law.
        </i>
      </p>

      <p>
        We will only keep your personal information for as long as it is
        necessary for the purposes set out in this privacy notice, unless a
        longer retention period is required or permitted by law (such as tax,
        accounting, or other legal requirements). No purpose in this notice will
        require us keeping your personal information for longer than 1 year .
      </p>

      <p>
        When we have no ongoing legitimate business need to process your
        personal information, we will either delete or anonymize such
        information, or, if this is not possible (for example, because your
        personal information has been stored in backup archives), then we will
        securely store your personal information and isolate it from any further
        processing until deletion is possible.
      </p>

      <h2>5. HOW DO WE KEEP YOUR INFORMATION SAFE?</h2>

      <p>
        <i>
          <b>In Short:</b> We aim to protect your personal information through a
          system of organizational and technical security measures.
        </i>
      </p>

      <p>
        We have implemented appropriate and reasonable technical and
        organizational security measures designed to protect the security of any
        personal information we process. However, despite our safeguards and
        efforts to secure your information, no electronic transmission over the
        Internet or information storage technology can be guaranteed to be 100%
        secure, so we cannot promise or guarantee that hackers, cybercriminals,
        or other unauthorized third parties will not be able to defeat our
        security and improperly collect, access, steal, or modify your
        information. Although we will do our best to protect your personal
        information, transmission of personal information to and from our
        Services is at your own risk. You should only access the Services within
        a secure environment.
      </p>

      <h2>6. DO WE COLLECT INFORMATION FROM MINORS?</h2>

      <p>
        <i>
          <b>In Short:</b> We do not knowingly collect data from or market to
          children under 18 years of age.
        </i>
      </p>

      <p>
        We do not knowingly collect, solicit data from, or market to children
        under 18 years of age, nor do we knowingly sell such personal
        information. By using the Services, you represent that you are at least
        18 or that you are the parent or guardian of such a minor and consent to
        such minor dependent's use of the Services. If we learn that personal
        information from users less than 18 years of age has been collected, we
        will deactivate the account and take reasonable measures to promptly
        delete such data from our records. If you become aware of any data we
        may have collected from children under age 18, please contact us at
        mobilitystudy@ucdavis.edu.
      </p>

      <h2>7. WHAT ARE YOUR PRIVACY RIGHTS?</h2>

      <p>
        <i>
          <b>In Short:</b> You may review, change, or terminate your account at
          any time, depending on your country, province, or state of residence.
        </i>
      </p>

      <p>
        <b>
          <u>Withdrawing your consent:</u>
        </b>{" "}
        If we are relying on your consent to process your personal information,
        which may be express and/or implied consent depending on the applicable
        law, you have the right to withdraw your consent at any time. You can
        withdraw your consent at any time by contacting us by using the contact
        details provided in the section "HOW CAN YOU CONTACT US ABOUT THIS
        NOTICE?" below.
      </p>

      <p>
        However, please note that this will not affect the lawfulness of the
        processing before its withdrawal nor, when applicable law allows, will
        it affect the processing of your personal information conducted in
        reliance on lawful processing grounds other than consent.
      </p>

      <p>
        If you have questions or comments about your privacy rights, you may
        email us at mobilitystudy@ucdavis.edu.
      </p>

      <h2>8. CONTROLS FOR DO-NOT-TRACK FEATURES</h2>

      <p>
        Most web browsers and some mobile operating systems and mobile
        applications include a Do-Not-Track ( "DNT" ) feature or setting you can
        activate to signal your privacy preference not to have data about your
        online browsing activities monitored and collected. At this stage, no
        uniform technology standard for recognizing and implementing DNT signals
        has been finalized . As such, we do not currently respond to DNT browser
        signals or any other mechanism that automatically communicates your
        choice not to be tracked online. If a standard for online tracking is
        adopted that we must follow in the future, we will inform you about that
        practice in a revised version of this privacy notice.
      </p>

      <p>
        California law requires us to let you know how we respond to web browser
        DNT signals. Because there currently is not an industry or legal
        standard for recognizing or honoring DNT signals, we do not respond to
        them at this time.
      </p>

      <h2>9. DO UNITED STATES RESIDENTS HAVE SPECIFIC PRIVACY RIGHTS?</h2>

      <p>
        <i>
          <b>In Short:</b> If you are a resident of California, Colorado,
          Connecticut, Delaware, Florida, Indiana, Iowa, Kentucky, Montana, New
          Hampshire, New Jersey, Oregon, Tennessee, Texas, Utah, or Virginia ,
          you may have the right to request access to and receive details about
          the personal information we maintain about you and how we have
          processed it, correct inaccuracies, get a copy of, or delete your
          personal information. You may also have the right to withdraw your
          consent to our processing of your personal information. These rights
          may be limited in some circumstances by applicable law. More
          information is provided below.
        </i>
      </p>

      <h3>Categories of Personal Information We Collect</h3>

      <p>
        We have collected the following categories of personal information in
        the past twelve (12) months:
      </p>

      <table>
        <th>
          <td>Category</td>
          <td>Examples</td>
          <td>Collected</td>
        </th>
        <tr>
          <td>A. Identifiers</td>
          <td>
            Contact details, such as real name, alias, postal address, telephone
            or mobile contact number, unique personal identifier, online
            identifier, Internet Protocol address, email address, and account
            name
          </td>
          <td>NO</td>
        </tr>
        <tr>
          <td>
            B. Personal information as defined in the California Customer
            Records statute
          </td>
          <td>
            Name, contact information, education, employment, employment
            history, and financial information
          </td>
          <td>NO</td>
        </tr>
        <tr>
          <td>
            C . Protected classification characteristics under state or federal
            law
          </td>
          <td>
            Gender, age, date of birth, race and ethnicity, national origin,
            marital status, and other demographic data
          </td>
          <td>NO</td>
        </tr>
        <tr>
          <td>D . Commercial information</td>
          <td>
            Transaction information, purchase history, financial details, and
            payment information
          </td>
          <td>NO</td>
        </tr>
        <tr>
          <td>E . Biometric information</td>
          <td>Fingerprints and voiceprints</td>
          <td>NO</td>
        </tr>
        <tr>
          <td>F . Internet or other similar network activity</td>
          <td>
            Browsing history, search history, online behavior , interest data,
            and interactions with our and other websites, applications, systems,
            and advertisements
          </td>
          <td>NO</td>
        </tr>
        <tr>
          <td>G . Geolocation data</td>
          <td>Device location</td>
          <td>NO</td>
        </tr>
        <tr>
          <td>H . Audio, electronic, sensory, or similar information</td>
          <td>
            Images and audio, video or call recordings created in connection
            with our business activities
          </td>
          <td>NO</td>
        </tr>
        <tr>
          <td>I . Professional or employment-related information</td>
          <td>
            Business contact details in order to provide you our Services at a
            business level or job title, work history, and professional
            qualifications if you apply for a job with us
          </td>
          <td>NO</td>
        </tr>
        <tr>
          <td>J . Education Information</td>
          <td>Student records and directory information</td>
          <td>NO</td>
        </tr>
        <tr>
          <td>K . Inferences drawn from collected personal information</td>
          <td>
            Inferences drawn from any of the collected personal information
            listed above to create a profile or summary about, for example, an
            individual's preferences and characteristics
          </td>
          <td>NO</td>
        </tr>
        <tr>
          <td>L . Sensitive personal Information </td>
          <td></td>
          <td>NO</td>
        </tr>
      </table>

      <p>
        We may also collect other personal information outside of these
        categories through instances where you interact with us in person,
        online, or by phone or mail in the context of:
      </p>

      <ul>
        <li>Receiving help through our customer support channels;</li>
        <li>Participation in customer surveys or contests; and</li>
        <li>
          Facilitation in the delivery of our Services and to respond to your
          inquiries.
        </li>
      </ul>

      <p>
        We will use and retain the collected personal information as needed to
        provide the Services or for:
      </p>

      <ul>
        <li>Category H - 1 year</li>
      </ul>

      <h3>Sources of Personal Information</h3>

      <p>
        Learn more about the sources of personal information we collect in "
        WHAT INFORMATION DO WE COLLECT? "
      </p>

      <h3>How We Use and Share Personal Information</h3>

      <p>
        Learn about how we use your personal information in the section, " HOW
        DO WE PROCESS YOUR INFORMATION? "
      </p>

      <h4>Will your information be shared with anyone else?</h4>

      <p>
        We may disclose your personal information with our service providers
        pursuant to a written contract between us and each service provider.
        Learn more about how we disclose personal information to in the section,
        " WHEN AND WITH WHOM DO WE SHARE YOUR PERSONAL INFORMATION? "
      </p>

      <p>
        We may use your personal information for our own business purposes, such
        as for undertaking internal research for technological development and
        demonstration. This is not considered to be "selling" of your personal
        information.
      </p>

      <p>
        We have not disclosed, sold, or shared any personal information to third
        parties for a business or commercial purpose in the preceding twelve
        (12) months. We will not sell or share personal information in the
        future belonging to website visitors, users, and other consumers.
      </p>

      <h3>Your Rights</h3>

      <p>
        You have rights under certain US state data protection laws. However,
        these rights are not absolute, and in certain cases, we may decline your
        request as permitted by law. These rights include:
      </p>

      <p>
        <b>Right to know</b> whether or not we are processing your personal data
      </p>

      <p>
        <b>Right to access</b> your personal data
      </p>

      <p>
        <b>Right to correct</b> inaccuracies in your personal data
      </p>

      <p>
        <b>Right to request</b> the deletion of your personal data
      </p>

      <p>
        <b>Right to obtain a copy</b> of the personal data you previously shared
        with us
      </p>

      <p>
        <b>Right to non-discrimination</b> for exercising your rights
      </p>

      <p>
        <b>Right to opt out</b> of the processing of your personal data if it is
        used for targeted advertising (or sharing as defined under California's
        privacy law) , the sale of personal data, or profiling in furtherance of
        decisions that produce legal or similarly significant effects (
        "profiling" )
      </p>

      <p>
        Depending upon the state where you live, you may also have the following
        rights:
      </p>

      <ul>
        <li>
          Right to obtain a list of the categories of third parties to which we
          have disclosed personal data (as permitted by applicable law,
          including California's and Delaware's privacy law)
        </li>
        <li>
          Right to obtain a list of specific third parties to which we have
          disclosed personal data (as permitted by applicable law, including
          Oregon's privacy law)
        </li>
        <li>
          Right to limit use and disclosure of sensitive personal data (as
          permitted by applicable law, including California's privacy law)
        </li>
        <li>
          Right to opt out of the collection of sensitive data and personal data
          collected through the operation of a voice or facial recognition
          feature (as permitted by applicable law, including Florida's privacy
          law)
        </li>
      </ul>

      <h3>How to Exercise Your Rights</h3>

      <p>
        To exercise these rights, you can contact us by visiting
        https://odometer-reading-remix-dnfvejf9arcreaa9.westus-01.azurewebsites.net/user-request/
        , by emailing us at mobilitystudy@ucdavis.edu , or by referring to the
        contact details at the bottom of this document.
      </p>

      <p>
        Under certain US state data protection laws, you can designate an
        authorized agent to make a request on your behalf. We may deny a request
        from an authorized agent that does not submit proof that they have been
        validly authorized to act on your behalf in accordance with applicable
        laws.
      </p>

      <h3>Request Verification</h3>

      <p>
        Upon receiving your request, we will need to verify your identity to
        determine you are the same person about whom we have the information in
        our system. We will only use personal information provided in your
        request to verify your identity or authority to make the request.
        However, if we cannot verify your identity from the information already
        maintained by us, we may request that you provide additional information
        for the purposes of verifying your identity and for security or
        fraud-prevention purposes.
      </p>

      <p>
        If you submit the request through an authorized agent, we may need to
        collect additional information to verify your identity before processing
        your request and the agent will need to provide a written and signed
        permission from you to submit such request on your behalf.
      </p>

      <h3>Appeals</h3>

      <p>
        Under certain US state data protection laws, if we decline to take
        action regarding your request, you may appeal our decision by emailing
        us at mobilitystudy@ucdavis.edu . We will inform you in writing of any
        action taken or not taken in response to the appeal, including a written
        explanation of the reasons for the decisions. If your appeal is denied,
        you may submit a complaint to your state attorney general.
      </p>

      <h3>Financial Incentives</h3>

      <p>
        "Financial incentive" means a program, benefit, or other offering,
        including payments to consumers as compensation, for the disclosure,
        deletion, sale, or sharing of personal information.
      </p>

      <p>
        The law permits financial incentives or a price or service difference if
        it is reasonably related to the value of the consumer's data. A business
        must be able to explain how the financial incentive or price or service
        difference is reasonably related to the value of the consumer's data.
        The explanation must include:
      </p>

      <ul>
        <li>
          a good-faith estimate of the value of the consumer's data that forms
          the basis for offering the financial incentive or price or service
          difference; and
        </li>
        <li>
          a description of the method the business used to calculate the value
          of the consumer's data.
        </li>
      </ul>

      <p>
        We may decide to offer a "bona fide loyalty program" under Colorado law
        , or a "financial incentive" under California law (e.g. , price or
        service difference) in exchange for the retention, sale, or sharing of a
        consumer's personal information.
      </p>

      <p>
        If we decide to offer a financial incentive, we will notify you of such
        financial incentive and explain the price difference, as well as
        material terms of the financial incentive or price of service
        difference, including the categories of personal information that are
        implicated by the financial incentive or price or service difference.
      </p>

      <p>
        Under California law, the value of your personal information to us is
        related to the value of the free or discounted products or services, or
        other benefits that you obtain or that are provided as part of the
        applicable program, less the expense related to offering those products,
        services, and benefits to program participants.
      </p>

      <p>
        If you choose to participate in the financial incentive you can withdraw
        from the financial incentive at any time by emailing us at
        mobilitystudy@ucdavis.edu , or by referring to the contact details at
        the bottom of this document.
      </p>

      <h3>California "Shine The Light" Law</h3>

      <p>
        California Civil Code Section 1798.83, also known as the "Shine The
        Light" law, permits our users who are California residents to request
        and obtain from us, once a year and free of charge, information about
        categories of personal information (if any) we disclosed to third
        parties for direct marketing purposes and the names and addresses of all
        third parties with which we shared personal information in the
        immediately preceding calendar year. If you are a California resident
        and would like to make such a request, please submit your request in
        writing to us by using the contact details provided in the section " HOW
        CAN YOU CONTACT US ABOUT THIS NOTICE? "
      </p>

      <h2>10. DO WE MAKE UPDATES TO THIS NOTICE?</h2>

      <p>
        <i>
          <b>In Short:</b> Yes, we will update this notice as necessary to stay
          compliant with relevant laws.
        </i>
      </p>

      <p>
        We may update this privacy notice from time to time. The updated version
        will be indicated by an updated "Revised" date at the top of this
        privacy notice. If we make material changes to this privacy notice, we
        may notify you either by prominently posting a notice of such changes or
        by directly sending you a notification. We encourage you to review this
        privacy notice frequently to be informed of how we are protecting your
        information.
      </p>

      <h2>11. HOW CAN YOU CONTACT US ABOUT THIS NOTICE?</h2>

      <p>
        If you have questions or comments about this notice, you may email us at
        mobilitystudy@ucdavis.edu or contact us by post at:
      </p>

      <p>
        UC Davis Mobility Study
        <br />
        1715 Tilia Street
        <br />
        Davis , CA 95616
        <br />
        United States
      </p>

      <h2>
        12. HOW CAN YOU REVIEW, UPDATE, OR DELETE THE DATA WE COLLECT FROM YOU?
      </h2>

      <p>
        Based on the applicable laws of your country or state of residence in
        the US , you may have the right to request access to the personal
        information we collect from you, details about how we have processed it,
        correct inaccuracies, or delete your personal information. You may also
        have the right to withdraw your consent to our processing of your
        personal information. These rights may be limited in some circumstances
        by applicable law. To request to review, update, or delete your personal
        information, please visit:
        https://odometer-reading-remix-dnfvejf9arcreaa9.westus-01.azurewebsites.net/user-request/
        .
      </p>
    </div>
  );
}
