from gymnasium.envs.registration import register

# max_episode_steps is always one step more than the actual number of steps 
# so the truncated flag is fully controlled by us

register(
      id="adv_driving/toy-v0",
      entry_point="gym_envs.toy_env:Environment",
      max_episode_steps=2000,
)


register( 
      id="adv_driving/gym-highway-v0",
      entry_point="gym_envs.gym_highway_env:Environment",
      max_episode_steps=2000,
)

register( 
      id="adv_driving/openpilot-v0",
      entry_point="gym_envs.openpilot_env:Environment",
      max_episode_steps=2000,
)

# for verifying the GFlowNet implementation
register(
      id="gfn_challenges/hypergrid-simple",
      entry_point="gym_envs.hypergrid_simple:Environment",
      max_episode_steps=2000,     # higher than max steps
)


# for verifying the GFlowNet implementation
register(
      id="adv_driving/metadrive_highway_env",
      entry_point="gym_envs.metadrive_highway_env:Environment",
      max_episode_steps=2000,     # higher than max steps
)