
# README for USDOT SMART Grant: Expand Work Zone Data Exchange to Local Roads in Wisconsin Using Smart Work Zone ITS
Wisconsin Department of Transportation, University of Wisconsin-Madison
2025-06-15
## Links to Dataset  
Dataset Archive Link: https://doi.org/10.21949/aevd-ef03
## Summary of Dataset  

This USDOT SMART Grant project will expand the existing Wisconsin WZDx data model to incorporate local road work zone characteristics and prototype the capability on a select set of rural and urban projects in Wisconsin using smart work zone devices purchased through the project. The project will also evaluate the ability to scale the proposed solution to all WisDOT improvement projects statewide with local road work zone components. Lastly, this project will provide a model to incorporate other work zones along the local road network into the Wisconsin WZDx using smart work zone technology.


## Tables of Contents  
##### A. General Information  
##### B. Sharing/Access & Policies Information  
##### C. Data and Related Files Overview  
##### D. Methodological Information  
##### E. Data-Specific Information for: USDOT SMART Grant: Expand Work Zone Data Exchange to Local Roads in Wisconsin Using Smart Work Zone ITS
##### F. Update Log  
## A. General Information  

**Title of Dataset:**  Wisconsin SMART Grant Project Data Repository

**Description of the Dataset:** This repository contains connected work zone datasets collected by the Wisconsin project team for the US DOT SMART Grant Stage 1 pilot evaluation.

**Dataset Archive Link:** https://doi.org/10.21949/aevd-ef03

**Authorship Information:**  

>  *Principal Data Creator or Data Manager Contact Information*  
>  Name: Erin Schwark 
>  Institution: Wisconsin Department of Transportation  
>  Address: 433 W. St. Paul Ave., Milwaukee, WI 53203  
>  Email: erin.schwark@dot.wi.gov  

>  *Data Distributor Contact Information*  
>  Name: Steven T. Parker [(0000-0003-3104-5116)](https://orcid.org/0000-0003-3104-5116)  
>  Institution: University of Wisconsin-Madison  
>  Address: 445 Henry Mall, Madison WI 53706  
>  Email: sparker@engr.wisc.edu  

**Date of data collection and update interval:** June 15, 2025  

**Geographic location of data collection:** Wisconsin  

**Information about funding sources that supported the collection of the data:** USDOT SMART Grant Program NOFO #20.941 Grant Number 69A3552341035A   

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  Wisconsin Department of Transportation and University of Wisconsin-Madison (2025). USDOT SMART Grant: Expand Work Zone Data Exchange to Local Roads in Wisconsin Using Smart Work Zone ITS. https://doi.org/10.21949/aevd-ef03  

**Licenses/restrictions placed on the data:** This data repository has been made available under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof. All contents are provided per the Creative Commons 4.0 International CC-BY License (https://creativecommons.org/licenses/by/4.0/).  

**Was data derived from another source?:** No.  

This dataset was made public under the requirements enumerated in the U.S. Department of Transportation's 'Plan to Increase Public Access to the Results of Federally-Funded Scientific Research' Version 1.1 <https://doi.org/10.21949/1520559> and guidelines suggested by the DOT Public Access website <https://doi.org/10.21949/1503647>, in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  

File List for the wi_dmp_rosa_p_20250615.zip

>  1. Filename: wi_dmp_wzdx_feed_20250615.csv  
>  Short Description:  Wisconsin WZDx data for the pilot local road work zones collected at 1-minute intervals in GeoJSON format per the WZDx 4.2 specification.

>  2. Filename: wi_dmp_wislcs_closure_records_20250615.csv
>  Short Description:  Wisconsin Lane Closure System (WisLCS) data for the pilot local road work zones in CSV (comma separated value) format.  

>  3. Filename: wi_dmp_wislcs_data_dictionary_20250615.pdf
>  Short Description:  Wisconsin Lane Closure System (WisLCS) dataset data dictionary.  

>  4. Filename: wi_dmp_vermac_device_feeds_20250615.csv
>  Short Description:  Connected work zone device data (connected arrow boards and location markers) from the Ver-Mac WZDx Device Feed for the pilot local road work zones collected at 1-minute intervals in GeoJSON format. 

>  5. Filename: wi_dmp_ground_truth_gps_20250615.csv
>  Short Description:  Ground truth GPS measurements collected by the project team through pilot work zone site visits. 

>  6. Filename: WI_SMART_Grant_Implementation Plan_03.31.2025_Final.pdf
>  Short Description:  Wisconsin SMART Grant Stage 1 Project Final Report.

>  7. Filename: WI_SMART_Grant_Data Management_Plan_06.07.2025_Final.pdf  
>  Short Description:  Wisconsin SMART Grant Stage 1 Data Management Plan. 

>  8. Filename: WI_SMART_Grant_DCAT_US.json
>  Short Description:  Wisconsin SMART Grant Data Repository metadata in DCAT-US format. 

>  9. Filename: WI_SMART_README.md
>  Short Description:  This README file in Markdown format. 

## D. Methodological Information  

**Description of methods used for collection/generation of data:** The datasets in this repository were collected through automated archiving processes and site visits by the Wisconsin project team.  

**Instrument or software-specific information needed to interpret the data:** The datasets are provided as CSV collections of individual GeoJSON records.  

## E. Data-Specific Information  

1. wi_dmp_wzdx_feed_20250615.csv 
- Number of variables (columns): 2  
- Number of cases/rows: 249479  
- Each row represents: A one-minute timestamped Wisconsin WZDx Work Zone Data Feed record for the pilot work zones.  
- Data Dictionary/Variable List: WZDx 4.2 Specification: https://github.com/usdot-jpo-ode/wzdx/blob/main/README.md

2. wi_dmp_wislcs_closure_records_20250615.csv  
- Number of variables (columns): 24  
- Number of cases/rows: 3 
- Each row represents: A single Wisconsin Lane Closure System record for the pilot work zone locations.  
- Data Dictionary/Variable List: wi_dmp_wislcs_data_dictionary_20250615.pdf   

3. wi_dmp_vermac_device_feeds_20250615.csv  
- Number of variables (columns): 2  
- Number of cases/rows: 249479  
- Each row represents: A one-minute timestamped WZDx Device Feed record for the pilot work zones.  
- Data Dictionary/Variable List: WZDx 4.2 Specification: https://github.com/usdot-jpo-ode/wzdx/blob/main/README.md  
 
4. wi_dmp_ground_truth_gps_20250615.csv  
- Number of variables (columns): 4  
- Number of cases/rows: 7  
- Each row represents: An individual ground truth GPS location for a connected work zone device. 
- Data Dictionary/Variable List: Device, Timestamp, Latitude, Longitude 


## F. Update Log  

This README.txt file was originally created on June 15, 2025 by Steven T. Parker  [(0000-0003-3104-5116)](https://orcid.org/0000-0003-3104-5116), Managing Directory, TOPS Laboratory, University of Wisconsin-Madison, sparker@engr.wisc.edu  

2025-06-15: Original file created  
