# README for Air Travel Consumer Report: October 1973 [supporting dataset]  
Office of Aviation Consumer Protection. Office of the Secretary of Transportation, U.S. Department of Transportation (USDOT)  
2025-05-29  

## Links to Dataset  
Dataset Archive Link: <https://doi.org/10.21949/fgm5-p386>  
Series Archive Link: <https://doi.org/10.21949/1530604>  

## Summary of Dataset  

The Air Travel Consumer Report is a monthly product of the Department of Transportation's Office of Aviation Enforcement and Proceedings. The report is designed to assist consumers with information on the quality of services provided by the airlines. 

>  Data Coverage  
>  October 1973    

## Table of Contents  
A. [General Information](#a-general-information)  
B. [Sharing/Access & Policies Information](#b-sharingaccess-and-policies-information)  
C. [Data and Related Files Overview](#c-data-and-related-files-overview)  
D. [Methodological Information](#d-methodological-information)  
E. [Data-Specific Information for: Air Travel Consumer Report: October 1973 [supporting dataset]](#e-data-specific-information)  
F. [Update Log](#f-update-log) 

**Title of Dataset:**  Air Travel Consumer Report: October 1973 [supporting dataset]  

**Description of the Dataset:** The Air Travel Consumer Report is a monthly product of the Department of Transportation's Office of Aviation Enforcement and Proceedings. The report is designed to assist consumers with information on the quality of services provided by the airlines.   

**Dataset Archive Link:** <https://doi.org/10.21949/fgm5-p386>  

**Authorship Information:**  

>  *Principal Data Creator Contact Information*   
>  Institution: Office of Aviation Consumer Protection. Department of Transportation ([ROR ID: https://ror.org/02xfw2e90](https://ror.org/02xfw2e90))  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Phone: (202) 366-2220  

>  *Data Distributor Contact Information*  
>  Institution: National Transportation Library ([ROR ID: https://ror.org/00snbrd52](https://ror.org/00snbrd52))   
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Email: <ntldatacurator@dot.gov> and ([National Transportation Library's Ask A Librarian](https://transportation.libanswers.com/))  

>  *Organizational Contact Information*  
>  Institution: Office of Aviation Consumer Protection. Department of Transportation ([ROR ID: https://ror.org/02xfw2e90](https://ror.org/02xfw2e90))  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Phone: (202) 366-2220  

**Date of data collection and update interval:**  
October 1973    

**Geographic location of data collection:** United States [(GeoNames URI: http://sws.geonames.org/6252001/)](http://sws.geonames.org/6252001/)   

**Information about funding sources that supported the collection of the data:** The Office of Aviation Consumer Protection is an office under the Office of the Secretary of Transportation, which is funded and overseen by the Department of Transportation.    

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  Office of Aviation Consumer Protection. Department of Transportation. *Air Travel Consumer Report: October 1973* [supporting dataset]. (1973). <https://doi.org/10.21949/fgm5-p386>  

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof.  

**Was data derived from another source?:** No  

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's [Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1](https://doi.org/10.21949/1520559) and [Guidelines Suggested by the DOT Public Access website](https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  

File List for the ATCR_1971_March.zip  

>  1. Filename: Air Travel Consumer Report October 1973 Consumer Complaint Report.csv  
>  Short Description:  March data in CSV format   

>  2. Filename: Air Travel Consumer Report October 1973 Consumer Complaint Report.xlsx   
>  Short Description:  March data in XLSX format.  

>  3. Filename: Air Travel Consumer Report October 1973 DCAT-US File.json   
>  Short Description:  DCAT-US metadata file.  

>  4. Filename: README.md  
>  Short Description:  README documentation file.     

## D. Methodological Information  

**Description of methods used for collection/generation of data:** The sections dealing with flight delays, mishandled baggage, wheelchairs, scooters, and oversales are based on data collected by the Department of Transportation. The section that deals with consumer complaints is based on data compiled by the Office of Aviation Consumer Protection (OACP). The OACP gathers and analyzes complaints submitted by passengers, addressing issues such as customer service, refunds, and other concerns.  

**Instrument or software-specific information needed to interpret the data:** These data tables were originally only available in PDF form. They have been extracted using ABBYY FineReader PDF Software and cleaned in Microsoft Excel. Both Excel and CSV versions of this data are available in this data package. Due to the merged columns and table structure, they are best viewed in XLSX form, but can be viewed in CSV form. If you do not have access to Microsoft Excel, please use an open-source alternative, such as OpenRefine or Notepad ++.  

## E. Data-Specific Information  

Because of the innumerate amount of data tables created for the Air Travel Consumer Report for October 1973, counting the number of rows and columns is too extraneous for this project. Additionally, because these data tables are summaries of the data and not the raw data itself, there are no variables to define, so there is no data dictionary. In the case of null or blank data, this means that the data was either not reported, not applicable, or as reported depending on the question. For these data tables, each null or blank value is explained with footnotes and in the reports.  

## F. Update Log  

This README.md file was originally created on 2025-05-29 by Peyton Tvrdy ([0000-0002-9720-4725](https://orcid.org/0000-0002-9720-4725)), Data Management and Data Curation Fellow, National Transportation Library <peyton.tvrdy.ctr@dot.gov>  
 
2025-05-29: Original file created  
