# README for Design and Implementation of Digital Twin Models for Continuous Monitoring and Performance Prediction of Precast Concrete Bridges [supporting dataset] 
University Transportation Centers Program, U.S. Department of Transportation (USDOT)  
2025-04-18  

## Links to Dataset  
Dataset Archive Link: <https://doi.org/10.21949/3pa3-fe38>  

## Summary of Dataset  
This project explores the design and implementation of digital twin models for the continuous monitoring and performance prediction of precast concrete (PC) bridges. Leveraging NVIDIA Omniverse, a cutting-edge 3D modeling platform, the research establishes a streamlined methodology for rapidly prototyping digital twin models using engineering drawings, inspection data, and real-world bridge configurations. The study includes case studies of two bridges in Illinois, showcasing the digital twin's ability to integrate bridge metadata, environmental and condition monitoring data, and inspection imagery into a cohesive digital representation. Additionally, the project extends the digital twin application to precast concrete beam testing, incorporating finite element analysis and crack segmentation into the simulation for enhanced structural assessment and visualization.  

## Table of Contents  
A. [General Information](#a-general-information)  
B. [Sharing/Access & Policies Information](#b-sharingaccess-and-policies-information)  
C. [Data and Related Files Overview](#c-data-and-related-files-overview)  
D. [Methodological Information](#d-methodological-information)   
E. [Update Log](#e-update-log)

**Title of Dataset:**  Design and Implementation of Digital Twin Models for Continuous Monitoring and Performance Prediction of Precast Concrete Bridges [supporting dataset]  

**Description of the Dataset:** This project explores the design and implementation of digital twin models for the continuous monitoring and performance prediction of precast concrete (PC) bridges. Leveraging NVIDIA Omniverse, a cutting-edge 3D modeling platform, the research establishes a streamlined methodology for rapidly prototyping digital twin models using engineering drawings, inspection data, and real-world bridge configurations. The study includes case studies of two bridges in Illinois, showcasing the digital twin's ability to integrate bridge metadata, environmental and condition monitoring data, and inspection imagery into a cohesive digital representation. Additionally, the project extends the digital twin application to precast concrete beam testing, incorporating finite element analysis and crack segmentation into the simulation for enhanced structural assessment and visualization.  

**Dataset Archive Link:** <https://doi.org/10.21949/3pa3-fe38>  

**Authorship Information:**  

>  *Principle Investigator*  
>  Name: Volodymyr Kindratenko [(0000-0002-9336-4756)](https://orcid.org/0000-0002-9336-4756)
>  Institution: University of Illinois Urbana-Champaign [(ROR ID: https://ror.org/047426m28)](https://ror.org/047426m28)  
>  Address: 901 West Illinois Street, Urbana, IL  

>  *Additional Author*  
>  Name: Bassem Andrawes [(0000-0002-8954-3751)](https://orcid.org/0000-0002-8954-3751)  
>  Institution: University of Illinois Urbana-Champaign [(ROR ID: https://ror.org/047426m28)](https://ror.org/047426m28)  
>  Address: 901 West Illinois Street, Urbana, IL   
>  Email: [andrawes@illinois.edu](mailto:andrawes@illinois.edu)  

>  *Data Distributor Contact Information*  
>  Name: National Transportation Library Data Curator  
>  Institution: National Transportation Library [(ROR ID: https://ror.org/00snbrd52)](https://ror.org/00snbrd52)  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Email: [NTLDataCurator@dot.gov](mailto:ntldatacurator@dot.gov)  

>  *Organizational Contact Information*  
>  Institution: Transportation Infrastructure Precast Innovation Center (TRANS-IPIC) Tier-1 University Transportation Center (UTC)  
>  Address: 901 West Illinois Street, Urbana, IL 61801  
>  Website: <https://trans-ipic.illinois.edu/>  
>  Email: [trans-ipic@illinois.edu](mailto:trans-ipic@illinois.edu)  

**Date of data collection and update interval:** 2024-2025

**Geographic location of data collection:** United States [(GeoNames URI: http://sws.geonames.org/6252001/)](http://sws.geonames.org/6252001/)  

**Information about funding sources that supported the collection of the data:** This project was funded through the US Department of Transportation University Transportation Centers Program and produced by the Transportation Infrastructure Precast Innovation Center (TRANS-IPIC) Tier-1 University Transportation Center (UTC). The contract number is: 69A3552348333.  

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  Kindratenko, Volodymyr and Bassem Andrawes (2025). *Design and Implementation of Digital Twin Models for Continuous Monitoring and Performance Prediction of Precast Concrete Bridges [supporting dataset]*. Transportation Infrastructure Precast Innovation Center (TRANS-IPIC) Tier-1 University Transportation Center. <https://doi.org/10.21949/3pa3-fe38>  

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof.  

**Was data derived from another source?:** No  

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's [Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1](https://doi.org/10.21949/1520559) and [Guidelines suggested by the DOT Public Access website](https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  

File List for the 104391.zip  

>  1. Filename: I-39 Bridge_09 New.cae
>  Short Description:  This is the CAE data file.     

>  2. Filename: Inspection Folder 
>  Short Description:  This folder contains photos from 2 inspection days June 4th and 5th, 2024.  

>  3. Filename: README.md  
>  Short Description:  README file containing importing information about the dataset and project.    

>  4. Filename: 104391.json  
>  Short Description:  DCAT-US JSON metadata file.   

>  5. References Folder
>  Short Description:  This folder contains PDFs the authors used as references for this project.  

>  6. SEM Images Folder
>  Short Description:  This folder contains SEM images in .TIF and .RTF format.   

>  7. XRF_XF0208_2024-07-08_Yaghmour.xlsx
>  Short Description: This file is the XLSX data file for this project.    


## D. Methodological Information   

**Description of methods used for collection/generation of data:** For information regarding the project's methodology, consult the report at <https://rosap.ntl.bts.gov/view/dot/80475>.  

**Instrument or software-specific information needed to interpret the data:** To access the TIF files, use any photo viewer. To view the XLSX, JSON, MD, and TXT files, use Notepad++ or OpenRefine.     

## E. Update Log  

This README.md file was originally created on 2025-04-18 by Peyton Tvrdy ([0000-0002-9720-4725](https://orcid.org/0000-0002-9720-4725)), Data Management and Data Curation Fellow, National Transportation Library <peyton.tvrdy.ctr@dot.gov>  
 
2025-04-18: Original file created  
