# README for Photogrammetry and LiDAR-Based Precast Railroad Crossties Abrasion Damage Detections [supporting dataset] 
University Transportation Centers Program, U.S. Department of Transportation (USDOT)  
2025-04-04  

## Links to Dataset  
Dataset Archive Link: <https://doi.org/10.21949/1eqg-jh21>  

## Summary of Dataset  
Recent derailment accident that happened in East Palestine, Ohio has drawn huge public attention to railroad system safety. While this accident is under investigation, one of the major contributions to many other derailment accidents is the precast concrete crossties abrasion damage. Concrete crossties can lose concrete sections on portions of the tie bottom and sides during service. Identifying the abrasion damage of precast concrete crossties is critical to extend the railroad service life and prevent potential derailment. This project is a collaboration among Purdue University, Louisiana State University, Rocla Concrete Tie, and CSX. The ultimate goal of this research is to develop mitigation measures to reduce concrete railroad tie section loss at the ballast interface based on expected service life. As a first step to achieve this goal, this project develops a photogrammetry and LiDAR scanning-based precast concrete crossties abrasion damage detection system.  

## Table of Contents  
A. [General Information](#a-general-information)  
B. [Sharing/Access & Policies Information](#b-sharingaccess-and-policies-information)  
C. [Data and Related Files Overview](#c-data-and-related-files-overview)  
D. [Methodological Information](#d-methodological-information)   
E. [Update Log](#e-update-log)

**Title of Dataset:**  Photogrammetry and LiDAR-Based Precast Railroad Crossties Abrasion Damage Detections [supporting dataset]  

**Description of the Dataset:** Recent derailment accident that happened in East Palestine, Ohio has drawn huge public attention to railroad system safety. While this accident is under investigation, one of the major contributions to many other derailment accidents is the precast concrete crossties abrasion damage. Concrete crossties can lose concrete sections on portions of the tie bottom and sides during service. Identifying the abrasion damage of precast concrete crossties is critical to extend the railroad service life and prevent potential derailment. This project is a collaboration among Purdue University, Louisiana State University, Rocla Concrete Tie, and CSX. The ultimate goal of this research is to develop mitigation measures to reduce concrete railroad tie section loss at the ballast interface based on expected service life. As a first step to achieve this goal, this project develops a photogrammetry and LiDAR scanning-based precast concrete crossties abrasion damage detection system.  

**Dataset Archive Link:** <https://doi.org/10.21949/1eqg-jh21>  

**Authorship Information:**  

>  *Principle Investigator*  
>  Name: Shanyue Guan [(0000-0002-9358-0184)](https://orcid.org/0000-0002-9358-0184)    
>  Institution: Purdue University West Lafayette [(ROR ID: https://ror.org/02dqehb95)](https://ror.org/02dqehb95)  
>  Address: Dudley Hall, 363 N. Grant Street West Lafayette, Indiana 47907  
>  Email: [guansy@purdue.edu](mailto:guansy@purdue.edu)

>  *Additional Author*  
>  Name: Chao Sun [(0000-0003-3909-0325)](https://orcid.org/0000-0003-3909-0325)  
>  Institution: Louisiana State University [(ROR ID: https://ror.org/05ect4e57)](https://ror.org/05ect4e57)  
>  Address: Pleasant Hall, 1146, Baton Rouge, LA 70802   

>  *Data Distributor Contact Information*  
>  Name: National Transportation Library Data Curator  
>  Institution: National Transportation Library [(ROR ID: https://ror.org/00snbrd52)](https://ror.org/00snbrd52)  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Email: [NTLDataCurator@dot.gov](mailto:ntldatacurator@dot.gov)  

>  *Organizational Contact Information*  
>  Institution: Transportation Infrastructure Precast Innovation Center (TRANS-IPIC) Tier-1 University Transportation Center (UTC)  
>  Address: 901 West Illinois Street, Urbana, IL 61801  
>  Website: <https://trans-ipic.illinois.edu/>  
>  Email: [trans-ipic@illinois.edu](mailto:trans-ipic@illinois.edu)  

**Date of data collection and update interval:** 2023

**Geographic location of data collection:** United States [(GeoNames URI: http://sws.geonames.org/6252001/)](http://sws.geonames.org/6252001/)  

**Information about funding sources that supported the collection of the data:** This project was funded through the US Department of Transportation University Transportation Centers Program and produced by the Transportation Infrastructure Precast Innovation Center (TRANS-IPIC) Tier-1 University Transportation Center (UTC). The contract number is: 69A3552348333.  

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  Guan, Shanyue and Chao Sun (2025). *Photogrammetry and LiDAR-Based Precast Railroad Crossties Abrasion Damage Detections [supporting dataset]*. Transportation Infrastructure Precast Innovation Center (TRANS-IPIC) Tier-1 University Transportation Center <https://doi.org/10.21949/1eqg-jh21>  

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof. This material is made available  through the Creative Commons 4.0 International CC-BY-4.0 license. Use of this content is free and unrestricted with attribution. <https://creativecommons.org/licenses/by/4.0/>

**Was data derived from another source?:** No  

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's [Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1](https://doi.org/10.21949/1520559) and [Guidelines suggested by the DOT Public Access website](https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  

File List for the 104388_DATASET.zip  

This dataset contains 60 JPG images that were obtained for this project. It also contains 1 group photo in JPG format. To access these images, use your standard photo viewer. For a complete list of files, consult "filenames.txt."


## D. Methodological Information   

**Description of methods used for collection/generation of data:** For information regarding the project's methodology, consult the report at <https://rosap.ntl.bts.gov/view/dot/80476>.  

**Instrument or software-specific information needed to interpret the data:** To access the JPG files, use any photo viewer. To view the JSON, MD, and TXT files, use Notepad++.  

## E. Update Log  

This README.md file was originally created on 2025-04-04 by Peyton Tvrdy ([0000-0002-9720-4725](https://orcid.org/0000-0002-9720-4725)), Data Management and Data Curation Fellow, National Transportation Library <peyton.tvrdy.ctr@dot.gov>  
 
2025-04-04: Original file created  
