# README for Design, Manufacturing, and Characterization of Fiber Reinforced Shape Memory Polymer Rebars [supporting dataset] 
University Transportation Centers Program, U.S. Department of Transportation (USDOT)  
2025-03-13  

## Links to Dataset  
Dataset Archive Link: <https://doi.org/10.21949/ywgm-gb97>  
Series Archive Link: <Insert Series DOI Here>  

## Summary of Dataset  
Camber in precast and prestressed concrete is currently designed using best practices in structural engineering and subject to climate and loading uncertainties. Applying new technology of adaptive structures, large shape change in response to load, to precast concrete bridge girders would pioneer a new innovative field of research and design. This work building, analyzing, and validating an adaptive precast girder system that will use expanding anchors to camber the compression face of the girder to counteract imposed loads. By providing on-demand camber, sizing of the precast member for deflection criteria can be reduced. Through this form of topology optimization, reduction in concrete volume will increase the sustainability of the structural system. Laboratory experiments have lead to fundamental science and implementable technology. Adaptive precast girders can address long-term effects of creep and changing design loads over the lifetime of highway bridges.  

## Table of Contents  
A. [General Information](#a-general-information)  
B. [Sharing/Access & Policies Information](#b-sharingaccess-and-policies-information)  
C. [Data and Related Files Overview](#c-data-and-related-files-overview)  
D. [Methodological Information](#d-methodological-information)   
E. [Update Log](#e-update-log)

**Title of Dataset:**  Design, Manufacturing, and Characterization of Fiber Reinforced Shape Memory Polymer Rebars [supporting dataset]  

**Description of the Dataset:** Camber in precast and prestressed concrete is currently designed using best practices in structural engineering and subject to climate and loading uncertainties. Applying new technology of adaptive structures, large shape change in response to load, to precast concrete bridge girders would pioneer a new innovative field of research and design. This work building, analyzing, and validating an adaptive precast girder system that will use expanding anchors to camber the compression face of the girder to counteract imposed loads. By providing on-demand camber, sizing of the precast member for deflection criteria can be reduced. Through this form of topology optimization, reduction in concrete volume will increase the sustainability of the structural system. Laboratory experiments have lead to fundamental science and implementable technology. Adaptive precast girders can address long-term effects of creep and changing design loads over the lifetime of highway bridges.  

**Dataset Archive Link:** <https://doi.org/10.21949/ywgm-gb97>  

**Authorship Information:**  

>  *Principle Investigator*  
>  Name: Guoqiang Li   
>  Institution: University of Illinois Urbana-Champaign [(ROR ID: https://ror.org/047426m28)](https://ror.org/047426m28)  
>  Address: 901 West Illinois Street, Urbana, IL 61801   

>  *Data Distributor Contact Information*  
>  Name: National Transportation Library Data Curator 
>  Institution: National Transportation Library [(ROR ID: https://ror.org/00snbrd52)](https://ror.org/00snbrd52)  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Email: [NTLDataCurator@dot.gov](mailto:ntldatacurator@dot.gov)  

>  *Organizational Contact Information*  
>  Institution: Transportation Infrastructure Precast Innovation Center (TRANS-IPIC) Tier-1 University Transportation Center (UTC)  
>  Address: 901 West Illinois Street, Urbana, IL 61801  
>  Website: <https://trans-ipic.illinois.edu/>
>  Email: [trans-ipic@illinois.edu](mailto:trans-ipic@illinois.edu)  

**Date of data collection and update interval:** 2023

**Geographic location of data collection:** United States [(GeoNames URI: http://sws.geonames.org/6252001/)](http://sws.geonames.org/6252001/)  

**Information about funding sources that supported the collection of the data:** This project was funded through the US Department of Transportation University Transportation Centers Program and produced by the Transportation Infrastructure Precast Innovation Center (TRANS-IPIC) Tier-1 University Transportation Center (UTC). The contract number is: 69A3552348333.  

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  Li, Guoqiang (2025). *Design, Manufacturing, and Characterization of Fiber Reinforced Shape Memory Polymer Rebars [supporting dataset]*. Transportation Infrastructure Precast Innovation Center (TRANS-IPIC) Tier-1 University Transportation Center <https://doi.org/10.21949/ywgm-gb97>  

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof.  

**Was data derived from another source?:** No  

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's [Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1](https://doi.org/10.21949/1520559) and [Guidelines suggested by the DOT Public Access website](https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  

File List for the 104092_DATASET.zip  

>  1. Filename: Photos Folder
>  Short Description:  53 JPG and PNG image files.    

>  2. Filename: Data Folder  
>  Short Description:  Contains 12 CSVs and 1 TXT file that contains the project's data.   

>  3. Filename: README.md  
>  Short Description:  README file containing importing information about the dataset and project.    

>  4. Filename: 104092.json  
>  Short Description:  DCAT-US JSON metadata file.   

## D. Methodological Information   

**Description of methods used for collection/generation of data:** For information regarding the project's methodology, consult the report at <https://ws.dev.engr.illinois.edu/sitemanager/getfile.asp?id=7579>.  

**Instrument or software-specific information needed to interpret the data:** To access the JPG and PNG files, use any photo viewer. To view the CSV, JSON, MD, and TXT files, use Notepad++.    

## E. Update Log  

This README.md file was originally created on 2025-03-13 by Peyton Tvrdy ([0000-0002-9720-4725](https://orcid.org/0000-0002-9720-4725)), Data Management and Data Curation Fellow, National Transportation Library <peyton.tvrdy.ctr@dot.gov>  
 
2025-03-13: Original file created  
