# README for Adaptive Camber Precast Concrete Girder for Deflection Mitigation of Highway Bridges [supporting dataset]{  
University Transportation Centers Program, U.S. Department of Transportation (USDOT)  
2025-03-11  

## Links to Dataset  
Dataset Archive Link: <https://doi.org/10.21949/q75g-ya19>  
Series Archive Link: <Insert Series DOI Here>  

## Summary of Dataset  
Camber in precast and prestressed concrete is currently designed using best practices in structural engineering and subject to climate and loading uncertainties. Applying new technology of adaptive structures, large shape change in response to load, to precast concrete bridge girders would pioneer a new innovative field of research and design. This work building, analyzing, and validating an adaptive precast girder system that will use expanding anchors to camber the compression face of the girder to counteract imposed loads. By providing on-demand camber, sizing of the precast member for deflection criteria can be reduced. Through this form of topology optimization, reduction in concrete volume will increase the sustainability of the structural system. Laboratory experiments have lead to fundamental science and implementable technology. Adaptive precast girders can address long-term effects of creep and changing design loads over the lifetime of highway bridges.  

## Table of Contents  
A. [General Information](#a-general-information)  
B. [Sharing/Access & Policies Information](#b-sharingaccess-and-policies-information)  
C. [Data and Related Files Overview](#c-data-and-related-files-overview)  
D. [Methodological Information](#d-methodological-information)  
E. [Data-Specific Information for: What Do Americans Think About Federal Tax Options to Support Transportation? Results From Year Fifteen of a National Survey [supporting dataset]](#e-data-specific-information)  
F. [Update Log](#f-update-log)  

**Title of Dataset:**  Adaptive Camber Precast Concrete Girder for Deflection Mitigation of Highway Bridges [supporting dataset]{  

**Description of the Dataset:** Camber in precast and prestressed concrete is currently designed using best practices in structural engineering and subject to climate and loading uncertainties. Applying new technology of adaptive structures, large shape change in response to load, to precast concrete bridge girders would pioneer a new innovative field of research and design. This work building, analyzing, and validating an adaptive precast girder system that will use expanding anchors to camber the compression face of the girder to counteract imposed loads. By providing on-demand camber, sizing of the precast member for deflection criteria can be reduced. Through this form of topology optimization, reduction in concrete volume will increase the sustainability of the structural system. Laboratory experiments have lead to fundamental science and implementable technology. Adaptive precast girders can address long-term effects of creep and changing design loads over the lifetime of highway bridges.  

**Dataset Archive Link:** <https://doi.org/10.21949/q75g-ya19>  

**Authorship Information:**  

>  *Author*  
>  Name: Ann Sychterz ([0000-0003-4000-6362](https://orcid.org/0000-0003-4000-6362))   
>  Institution: University of Illinois Urbana-Champaign [(ROR ID: https://ror.org/047426m28)](https://ror.org/047426m28)  
>  Address: 901 West Illinois Street, Urbana, IL 61801   

>  *Author*  
>  Name: Jacob Henschen ([0000-0002-1031-2409](https://orcid.org/0000-0002-1031-2409))   
[(ROR ID: https://ror.org/047426m28)](https://ror.org/047426m28)  
>  Address: 901 West Illinois Street, Urbana, IL 61801   

>  *Data Distributor Contact Information*  
>  Name: National Transportation Library Data Curator 
>  Institution: National Transportation Library [(ROR ID: https://ror.org/00snbrd52)](https://ror.org/00snbrd52)  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Email: [NTLDataCurator@dot.gov](mailto:ntldatacurator@dot.gov)  

>  *Organizational Contact Information*  
>  Institution: Transportation Infrastructure Precast Innovation Center (TRANS-IPIC) Tier-1 University Transportation Center (UTC)  
>  Address: 901 West Illinois Street, Urbana, IL 61801  
>  Website: <https://trans-ipic.illinois.edu/>
>  Email: [trans-ipic@illinois.edu](mailto:trans-ipic@illinois.edu)  

**Date of data collection and update interval:** Fall 2023  

**Geographic location of data collection:** United States [(GeoNames URI: http://sws.geonames.org/6252001/)](http://sws.geonames.org/6252001/)  

**Information about funding sources that supported the collection of the data:** This project was funded through the US Department of Transportation University Transportation Centers Program and produced by the Transportation Infrastructure Precast Innovation Center (TRANS-IPIC) Tier-1 University Transportation Center (UTC). The contract number is: 69A3552348333.  

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  Transportation Infrastructure Precast Innovation Center (TRANS-IPIC) Tier-1 University Transportation Center (2025). *Adaptive Camber Precast Concrete Girder for Deflection Mitigation of Highway Bridges [supporting dataset]*. <https://doi.org/10.21949/q75g-ya19>  

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof.  

**Was data derived from another source?:** `Insert Derived from Source Yes or No`  

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's [Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1](https://doi.org/10.21949/1520559) and [Guidelines suggested by the DOT Public Access website](https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  

File List for the 104092_DATASET.zip  

>  1. Filename: JPEG Files Folder
>  Short Description:  46 JPEG image files.    

>  2. Filename: Lab testing output - Updated 09-24-2024.xlsx  
>  Short Description:  Excel Spreadsheet containing the lab testing output.   

>  3. Filename: LVDT Instrument Test's Output - 11-08.xlsx  
>  Short Description:  Excel Spreadsheet containing the LVDT Instrument Test Output.

>  4. Filename: Open Access Files Folder  
>  Short Description:  Folder containing CSV versions of each XLSX sheet, png versions of the charts, text documents containing the formulas, and HTML files showing the visual representation and layout of the original Excel files.   

>  5. Filename: README.md  
>  Short Description:  README file containing importing information about the dataset and project.    

>  6. Filename: 104092.json  
>  Short Description:  DCAT-US JSON metadata file.   

## D. Methodological Information   

**Description of methods used for collection/generation of data:** The theoretical modeling used a form finding method that used dynamic relaxation to predict the deformations from internal, localized forces. This method was chosen because of its ability to handle large deformations. Dynamic relaxation was success to model the shape change of a concrete beam the same size at the laboratory specimen. Comparison of the experimental data and simulation shows general correlation and gives rise to addressing uncertainty quantification in the system design. The lab-scale testing utilized 3 in. by 4 in. by 16 in. concrete beams as the specimens. To generate the internal compression forces, two systems were considered, a screw-based lab jack and steel wedge expansion anchors. While the wedge anchors are designed to resist pull-out, they were chosen because they generate appreciable lateral forces to resist those pullout forces. To accommodate the jack, some of the beams were cast with a 2.5 in. long by 1.5 in. deep notch. The wedge anchors were installed into holes drilled after casting. During these tests, the loading was applied by either expanding the lab jack in the notch or tightening the wedge anchors. With both mechanisms, resistive strain gages were used to monitor the stresses near the top and bottom of the beam. In the final round of testing an external LVDT was also used to directly measure the deflection of the beam. For more information read the report at <https://rosap.ntl.bts.gov/view/dot/80438>.  

**Instrument or software-specific information needed to interpret the data:** To access the JPEG files, use any photo viewer. To view the XLSX files, use an open access spreadsheet software such as Google Sheets, OpenRefine, or Apache OpenOffice. To view the CSV files, use Notepad++.    

## E. Data-Specific Information   

1. Lab testing output - Updated 09-24-2024.xlsx   
- Number of variables (columns): 110  
- Number of cases/rows: 787  
- Each row represents: Load, Anchors Tighten Strength    
- Data Dictionary/Variable List: No data dictionary included by the authors    
- Missing data codes: No null or blank values  

2. LVDT Instrument Test's Output - 11-08.xlsx  
- Number of variables (columns): 17  
- Number of cases/rows: 97  
- Each row represents: Anchor Tighten Strength, Load, Displacement  
- Data Dictionary/Variable List: No data dictionary included by the authors  
- Missing data codes: No null or blank values  

## F. Update Log  

This README.md file was originally created on 2025-03-11 by Peyton Tvrdy ([0000-0002-9720-4725](https://orcid.org/0000-0002-9720-4725)), Data Management and Data Curation Fellow, National Transportation Library <peyton.tvrdy.ctr@dot.gov>  
 
2025-03-11: Original file created  
