# README for Aircraft Air Quality and Bleed Air Contamination Detection: Phase 2, Volume 2: [supporting dataset]  
Federal Aviation Administration (FAA), U.S. Department of Transportation (USDOT)  
2025-02-14 
## Links to Dataset  
Dataset Archive Link: <https://doi.org/10.21949/rb92-6j61>  
## Summary of Dataset  

The purpose of this project was to provide a data driven process to identify sensor technologies with the potential for detecting and identifying low levels of contaminants that may occasionally be present in aircraft engine bleed air supplies. Bleed air from a ground-based aircraft propulsion engine and an auxiliary power unit (APU) were used to supply air through an ozone/volatile organic compound (VOC) converter to the environmental control system on a Boeing 747, while injecting controlled amounts of fluid contaminants (i.e., aircraft engine oil, hydraulic fluid, and deicing fluid). Measurements of contaminants were performed at the ozone/VOC converter inlet and exit, and at the air conditioning pack exit. Ultrafine particles (UFP) were found to be a sensitive marker for engine oil contamination with measurements at all three locations showing similar, highly elevated UFP concentrations with a mean diameter near 40nm and smaller when the sample stream was cooled to near room temperature. In situ measurements showed that UFPs are generated by condensation and high UFP concentrations were not detected in uncooled bleed air. Oil contamination VOC levels were very low upstream of the ozone/VOC converter at bleed air temperatures up to 220˚C and increased at bleed temperatures of around 315˚C; however, oil contamination VOC levels remained at sub-ppmv levels. Fine particle concentrations also increased with oil contamination at lower bleed air temperatures, but not with temperatures around 315 ˚C. Secondary contaminants including pentanoic acid, heptanoic acid, acetic acid, formaldehyde, and acetaldehyde formed in the ozone/VOC converter as the oil aerosol oxidized. Consideration must be given to contaminant deposition within the bleed air system and sample lines as this deposition may lead to delayed responses and contaminant release during temperature transients. Of the sensor technologies assessed, spectrometers provided the best opportunity to detect and identify contaminants. Carbon monoxide (CO) measurements confirmed that CO is not generated in sufficient quantities to be of value as a marker for engine oil or hydraulic fluid contamination of bleed air. CO may be useful as a marker for ingestion of engine exhaust in some cases. However, carbon dioxide (CO2) is a much better marker for engine exhaust ingestion.  

## Table of Contents  

A. [General Information](#a-general-information)  
B. [Sharing/Access & Policies Information](#b-sharingaccess-and-policies-information)  
C. [Data and Related Files Overview](#c-data-and-related-files-overview)  
D. [Methodological Information](#d-methodological-information)  
E. [Update Log](#e-update-log)  

**Title of Dataset:**  Aircraft Air Quality and Bleed Air Contamination Detection: Phase 2, Volume 2: [supporting dataset]  

**Description of the Dataset:** The purpose of this project was to provide a data driven process to identify sensor technologies with the potential for detecting and identifying low levels of contaminants that may occasionally be present in aircraft engine bleed air supplies. Bleed air from a ground-based aircraft propulsion engine and an auxiliary power unit (APU) were used to supply air through an ozone/volatile organic compound (VOC) converter to the environmental control system on a Boeing 747, while injecting controlled amounts of fluid contaminants (i.e., aircraft engine oil, hydraulic fluid, and deicing fluid). Measurements of contaminants were performed at the ozone/VOC converter inlet and exit, and at the air conditioning pack exit. Ultrafine particles (UFP) were found to be a sensitive marker for engine oil contamination with measurements at all three locations showing similar, highly elevated UFP concentrations with a mean diameter near 40nm and smaller when the sample stream was cooled to near room temperature. In situ measurements showed that UFPs are generated by condensation and high UFP concentrations were not detected in uncooled bleed air. Oil contamination VOC levels were very low upstream of the ozone/VOC converter at bleed air temperatures up to 220˚C and increased at bleed temperatures of around 315˚C; however, oil contamination VOC levels remained at sub-ppmv levels. Fine particle concentrations also increased with oil contamination at lower bleed air temperatures, but not with temperatures around 315 ˚C. Secondary contaminants including pentanoic acid, heptanoic acid, acetic acid, formaldehyde, and acetaldehyde formed in the ozone/VOC converter as the oil aerosol oxidized. Consideration must be given to contaminant deposition within the bleed air system and sample lines as this deposition may lead to delayed responses and contaminant release during temperature transients. Of the sensor technologies assessed, spectrometers provided the best opportunity to detect and identify contaminants. Carbon monoxide (CO) measurements confirmed that CO is not generated in sufficient quantities to be of value as a marker for engine oil or hydraulic fluid contamination of bleed air. CO may be useful as a marker for ingestion of engine exhaust in some cases. However, carbon dioxide (CO2) is a much better marker for engine exhaust ingestion.  

**Dataset Archive Link:** <https://doi.org/10.21949/rb92-6j61>  

**Authorship Information:**  

>  *Author Contact Information*  
>  Name: Fox, Richard B.  
>  Institution: Aircraft Environment Solutions Inc.  
>  Address: 1565 E Verde Blvd, Queen Creek, AZ 85140  

>  *Author Contact Information*  
>  Name: Byron Jones ([https://orcid.org/0000-0002-9791-9448](`https://orcid.org/0000-0002-9791-9448`))    
>  Institution: Kansas State University [(ROR ID: https://ror.org/05p1j8758)](https://ror.org/05p1j8758)  
>  Address: 110 Anderson Hall, 919 Mid-Campus Drive North, Manhattan, KS 66506-0110   
>  Email: [jones@k-state.edu](mailto:jones@k-state.edu)  

>  *Data Distributor Contact Information*  
>  Name: National Transportation Library Data Services Team  
>  Institution: National Transportation Library [(ROR ID: https://ror.org/00snbrd52)](https://ror.org/00snbrd52)  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Email: [NTLDataCurator@dot.gov](NTLDataCurator@dot.gov)  

>  *Organizational Contact Information*  
>  Name: Stadtmueller, Traci     
>  Institution: Federal Aviation Administration [(ROR ID: https://ror.org/05q0y0j38)](https://ror.org/05q0y0j38)  
>  Address: William J. Hughes Technical Center, Atlantic City International Airport, NJ 08405  
>  Email: [traci.stadtmueller@faa.gov](mailto:traci.stadtmueller@faa.gov)  

**Date of data collection and update interval:** 2023-2024  

**Geographic location of data collection:** United States [(GeoNames URI: http://sws.geonames.org/6252001/)](http://sws.geonames.org/6252001/)   

**Information about funding sources that supported the collection of the data:** This project was funded through the US Department of Transportation's Federal Aviation Administration through the William J. Hughes Technical Center. The contract number is: 693KA9-21-C-00010.  

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  William J. Hughes Technical Center (2025). *Aircraft Air Quality and Bleed Air Contamination Detection: Phase 2, Volume 2: [supporting dataset]*. <https://doi.org/10.21949/rb92-6j61>  

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof.  The usage of the data in this dataset requires attribution not only to the authors and the federal government, but the express attribution to the laboratories that provided the reports. When reusing and citing this research, ensure attribution to all parties is included. 

**Was data derived from another source?:** Partially, most is original data. Read more about the dataset in [Section C. Data and Related Files Overview](#c-data-and-related-files-overview)     

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's [Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1](https://doi.org/10.21949/1520559) and [Guidelines suggested by the DOT Public Access website](https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  
The dataset can best be described as a combination of 5 distinct laboratory reports with unique data. Each of these reports and their data have been revised and edited, except The Fraunhofer Institute Report. The final version of the report and data is provided in this dataset package. Revision history on what what incorrect, retracted, recalculated, and changed can be found in each of the "Revision History" .DOCX and .PDF files in this data package. 

The 3 laboratories used for this experiment were "AAC Laboratory", "RJ Lee Laboratory", and the "Fraunhofer Institute." Each of these files in this data package have a final naming structure to differentiate between the various laboratories and reports. 

AAC Laboratory has the Project Number of: 230962
RJ Lee Laboratory has the Laboratory Numbers of: W305169, W305170, and W305171
The Fraunhofer Institute has the prefix of "Fraunhofer"  

Each XLSX file has had each worksheet converted into a CSV file. Additionally, Excel sheets with formulas had their formulas preserved. These formulas can be found in .TXT files named after the Excel document in the folder "Formulas." HTML snapshots of the Excel files were also created so the visual structure of the data was not lost in the conversion to CSV. Additionally, all original files were retained for this dataset and are included in the final dataset package. The user has many options on how to view and use the data, whether in the original PDF report, the original Excel spreadsheet, or using the accessible CSV files. 

**File List for the 102832_DATASET.zip**  


|Report File Name|      Brief Contents Summary     |     Date Issued     |
| -------------  | ------------- | ---------------|
| **AAC Laboratory** |  **Original Files** |        |
| 230962AAC Rev2 EPA TO-11.pdf  | Carbonyls; EPA TO-11A results, (Field Blanks subtracted); 18 samples; 12 pages. Chemical sample location nomenclature corrected in chain of custody forms. Full report of Project 230962. | December 20, 2023  |
| 230962 AAC Rev-2 EPA TO-11-EDD.xls| Carbonyls Electronic Data Deliverable, EPA TO-11A | December 20, 2023
| 230962 Revision History AAC TO-11.docx | Explanation of Revisions | March 14, 2024
|  |  |  
| **AAC Laboratory** | **National Transportation Library Preservation and Access Files** | **February 14, 2025** |
| 230962 Rev 2-EPA TO-11-EDD.xlsx | Excel Version of 230962 AAC Rev-2 EPA TO-11-EDD.xls | February 14, 2025 |
| 230962 Rev 2-EPA TO-11-EDD_Report.csv| Page 2 of "230962 AAC Rev 2 EPA TO-11.pdf" in CSV form | February 14, 2025 |
| 230962 Rev 2-EPA TO-11-EDD_Report (2).csv | Page 3 of "230962 AAC Rev 2 EPA TO-11.pdf" in CSV form | February 14, 2025 |
| 230962 Rev 2-EPA TO-11-EDD_Report-Blank Subtracted.csv| Page 4 of "230962 AAC Rev 2 EPA TO-11.pdf" | February 14, 2025 |
| 230962 Rev 2-EPA TO-11-EDD_Report (2)-Blank Subtracted.csv | Page 5 of "230962 AAC Rev 2 EPA TO-11.pdf" | February 14, 2025 |
| 230962 Revision History AAC TO-11.pdf | PDF version of "230962 Revision History AAC TO-11.docx" | February 14, 2025|
| 230962 Rev 2-EPA TO-11-EDD.htm | HTM snapshot of the Excel File "230962 Rev 2-EPA TO-11-EDD.xls" to preserve the visual structure. | February 14, 2025 |
|  |  |  
| **RJ Lee Laboratory** | **Original Files** | | 
| W305169 Rev1 Report TO-13A Phosphates -Rev 240717.pdf | EPA TO-13A, OP TICs, SVOC TICs; 39 samples; 235 page. The Chain of custody and sample descriptions are found in the report from pages 184 through 193. Chromatograms are found on pages 194 through 235. Full report of Lab Number W305169. | July 17, 2024|
| W305169 Chromatograms.pdf | 39 samples, July 24 - 28, 2023. 42 pages. These are originally found in the report "W305169 Rev1 Report TO-13A Phosphates -Rev 240717.pdf" from pages 194 through 235. | October 9, 2023 |
| W305169 EDD Final 2025-02-11.xlsx | OP TIC; EPA TO-13A Results | July 17, 2024 |
| W305169 Revision History TO-13A.docx | Explanation of Revisions | March 14, 2024 |
|  |  |  
| **RJ Lee Laboratory** | **National Transportation Library Preservation and Access Files** | **February 14, 2025** |
| W305169 EDD Final 2025-02-11_W305169 QC.csv| CSV Version of the tab "W305169 QC" in "W305169 EDD Final 2025-02-11.xlsx." The data can be found in the report "W305169 Rev1 Report TO-13A Phosphates -Rev 240717.pdf" from pages 145 through 183. | February 14, 2025 |
| W305169 EDD Final 2025-02-11_W305169 Results.csv |CSV Version of the tab "W305169 Results" in "W305169 EDD Final 2025-02-11.xlsx." The data can be found in the report "W305169 Rev1 Report TO-13A Phosphates -Rev 240717.pdf" from pages 5 through 144. | February 14, 2025 |
| W305169 Revision History TO-13A.pdf| PDF version of "W305169 Revision History TO-13A.docx." The tables and forms can be found in the report "W305169 Rev1 Report TO-13A Phosphates -Rev 240717.pdf" from pages 180-193. The Chain of custody and sample descriptions are found in the report from pages 184 through 193 of the original report and are in this PDF. | February 14, 2025 |
| W305169 Results.txt| Text file containing all the formulas found in "W305169 EDD Final 2025-02-11.xlsx." | February 14, 2025 
| W305169 EDD Final 2025-02-11.htm | HTM snapshot of the Excel File "W305169 EDD Final 2025-02-11.xlsx" to preserve the visual structure. | February 14, 2025 |
|  |  |  
| **RJ Lee Laboratory** | **Original Files** | | 
| W305170 TO-13A PAH Rev 240717 -RevB.pdf | PAHs and OP Isomers; 33 Samples; EPA TO-13A; 139 pages. The Chromatograms can be found on pages 103 through 139. The Chain of custody and sample identifications are found on pages 92 through 102. Full report of Lab Number W305170. | July 17, 2024 |
| W305170 EDD Final 20250211.xlsx | PAHs and OP Isomers; Electronic Data Deliverable; 33 Samples; EPA TO-13A; | July 17, 2024 |
| W305170 Revision History EPA TO13A PAH.docx | Explanation of Revisions | March 14, 2024 |
|  |  |  
| **RJ Lee Laboratory** | **National Transportation Library Preservation and Access Files** | **February 14, 2025** |
| W305170 EDD Final 20250211_W305170 PAHs.csv | CSV Version of the tab "W305170 PAHs" in "W305170 EDD Final 20250211.xlsx". This CSV has 39 samples that are found in the report "W305170 TO-13A PAH Rev 240717 -RevB.pdf" on pages 4 through 69.| February 14, 2025 |
| W305170 EDD Final 20250211_W305170 PAHs QC.csv | CSV Version of the tab "W305170 PAHs QC" in "W305170 EDD Final 20250211.xlsx." This data can be found in the report "W305170 TO-13A PAH Rev 240717 -RevB.pdf" on pages 70 through 91.| February 14, 2025 |
| W305170 Revision History EPA TO13A PAH.pdf | PDF version of "W305170 Revision History EPA TO13A PAH.docx." The tables and forms can be found in the report "W305170 TO-13A PAH Rev 240717 -RevB.pdf" from pages 92 through 102. | February 14, 2025 |
| W305170 PAHs.txt | Text file containing all the formulas found in "W305170 EDD Final 20250211.xlsx." | February 14, 2025 |
| W305170 EDD Final 20250211.htm | HTM snapshot of the Excel File "W305170 EDD Final 20250211.xlsx" to preserve the visual structure. | February 14, 2025 |
|  |  |  
| **RJ Lee Laboratory** | **Original Files** | | 
| W305171_Final Report_Rev.3-2 EPA TO17 250209.pdf | VOCs; EPA TO-17 (one broken tube reported as less than the reporting limit); 34 samples; 206 pages. The Chain of custody and sample identifications are found on pages 195 through 206. Full report of Lab Number W305171. | May 1, 2024 |
| W305171 EDD TO-17Rev5_250209.xlsx | VOCs; EPA TO-17 Electronic Data Deliverable, TIC without CAS numbers removed | May 1, 2024 |
| W305171 Revision History EPA TO-17.docx | Explanation of Revisions | March 14, 2024 |
|  |  |  
| **RJ Lee Laboratory** | **National Transportation Library Preservation and Access Files** | **February 14, 2025** |
| W305171 EDD TO-17Rev5_250209_W305171 TO-17.csv | CSV Version of the tab "W305171 TO-17" in "W305171 EDD TO-17Rev5_250209.xlsx." This data can be found in the report "W305171_Final Report_Rev.3-2 EPA TO17 250209.pdf" on pages 5 through 118.| February 14, 2025 |
| W305171 EDD TO-17Rev5_250209_W305171 TO-17 Acids.csv | CSV Version of the tab "W305171 TO-17 Acids" in "W305171 EDD TO-17Rev5_250209.xlsx." This data can be found in the report "W305171_Final Report_Rev.3-2 EPA TO17 250209.pdf" on pages 119 through 152. | February 14, 2025 |
| W305171 EDD TO-17Rev5_250209_W305171 TO-17 QC.csv | CSV Version of the tab "W305171 TO-17 QC" in "W305171 EDD TO-17Rev5_250209.xlsx." This data can be found in the report "W305171_Final Report_Rev.3-2 EPA TO17 250209.pdf" on pages 153 through 193. | February 14, 2025 | 
| W305171 EDD TO-17Rev5_250209.htm| HTM snapshot of the Excel File "W305171 EDD TO-17Rev5_250209.xlsx" to preserve the visual structure. | February 14, 2025 |
|  |  |  
| **The Fraunhofer Institute** | **Original Files** | | 
| Fraunhofer Atlantic City 2023 Analysis Report_corr..pdf| PDF Report of that contains the analysis results of the Atlantic City measurement campaign. 2023 Analysis Report, chemical sample locations corrected (CA, OP/Oil, and Tenax,)Attribution is required for use of this report. | August 30, 2023 |
|  |  | 
| **The Fraunhofer Institute** | **National Transportation Library Preservation and Access Files** | | 
| Fraunhofer Table 1.csv| This is a CSV version of Table 1 from "Fraunhofer Atlantic City 2023 Analysis Report_corr..pdf"| February 14, 2025|
| Fraunhofer Table 1.xlsx| This is a XLSX version of Table 1 from "Fraunhofer Atlantic City 2023 Analysis Report_corr..pdf"| February 14, 2025|
| Fraunhofer Table 2.csv| This is a CSV version of Table 2 from "Fraunhofer Atlantic City 2023 Analysis Report_corr..pdf"| February 14, 2025|
| Fraunhofer Table 2.xlsx| This is a XLSX version of Table 2 from "Fraunhofer Atlantic City 2023 Analysis Report_corr..pdf"| February 14, 2025|
| Fraunhofer Table 3.csv| This is a CSV version of Table 3 from "Fraunhofer Atlantic City 2023 Analysis Report_corr..pdf"| February 14, 2025|
| Fraunhofer Table 3.xlsx| This is a XLSX version of Table 3 from "Fraunhofer Atlantic City 2023 Analysis Report_corr..pdf"| February 14, 2025|
| Fraunhofer Table 4.csv| This is a CSV version of Table 4 from "Fraunhofer Atlantic City 2023 Analysis Report_corr..pdf"| February 14, 2025|
| Fraunhofer Table 4.xlsx| This is a XLSX version of Table 4 from "Fraunhofer Atlantic City 2023 Analysis Report_corr..pdf"| February 14, 2025|
| Fraunhofer Table 5.csv| This is a CSV version of Table 5 from "Fraunhofer Atlantic City 2023 Analysis Report_corr..pdf"| February 14, 2025|
| Fraunhofer Table 5.xlsx| This is a XLSX version of Table 5 from "Fraunhofer Atlantic City 2023 Analysis Report_corr..pdf"| February 14, 2025|
| Fraunhofer Table 6.csv| This is a CSV version of Table 6 from "Fraunhofer Atlantic City 2023 Analysis Report_corr..pdf"| February 14, 2025|
| Fraunhofer Table 6.xlsx| This is a XLSX version of Table 6 from "Fraunhofer Atlantic City 2023 Analysis Report_corr..pdf"| February 14, 2025|


## D. Methodological Information   

**Description of methods used for collection/generation of data:** For the full methodology of each lab report, consult the full publication [https://doi.org/10.21949/v5p6-j307](https://doi.org/10.21949/v5p6-j307)  

**Instrument or software-specific information needed to interpret the data:** The data and graphs for this dataset package are stored in a variety of files to ensure access. The original formats of .DOCX, .XLSX, .XLS and .PDF were retained so that the original state of the final research can be preserved. However, additional copies of files were made, including .PDF copies of the .DOCX files and .CSV copies of each Excel Worksheet to ensure access and interoperability across programs and machines. Further, the formulas and a visual representation of the data's content and structured were created and preserved as well for users who do not have access to Excel. The formulas and .HTML pages ensure that the content that cannot be preserved by .CSVs, such as visual structure and calculations, are noted and archived in the final data package. Notepad++ can be used to access the .CSV and .TXT files. Your machine's web browser can be used to access the .HTML and .PDF files.  

## E. Update Log  

This README.md file was originally created on 2025-02-14by Peyton Tvrdy ([0000-0002-9720-4725](https://orcid.org/0000-0002-9720-4725)), Data Management and Data Curation Fellow, National Transportation Library <peyton.tvrdy.ctr@dot.gov>  
 
2025-02-14: Original file created  
