# README for Air Travel Consumer Report: July 2003 [supporting dataset]  
Office of Aviation Consumer Protection. Office of the Secretary of Transportation, U.S. Department of Transportation (USDOT)  
2024-12-02  
## Links to Dataset  
Dataset Archive Link: <https://doi.org/10.21949/1530662>  
Series Archive Link: <https://doi.org/10.21949/1530604>  

## Summary of Dataset  

The Air Travel Consumer Report is a monthly product of the Department of Transportation's Office of Aviation Enforcement and Proceedings. The report is designed to assist consumers with information on the quality of services provided by the airlines. 

>  Data Coverage  
>  Flight Delays: May 2003 / 12 Months Ending May 2003  
>  Mishandled Baggage: May 2003  
>  Oversales: 1st Quarter 2003  
>  Consumer Complaints: May 2003    

## Table of Contents  
A. [General Information](#a-general-information)  
B. [Sharing/Access & Policies Information](#b-sharingaccess-and-policies-information)  
C. [Data and Related Files Overview](#c-data-and-related-files-overview)  
D. [Methodological Information](#d-methodological-information)  
E. [Data-Specific Information for: Air Travel Consumer Report: July 2003 [supporting dataset]](#e-data-specific-information)  
F. [Update Log](#f-update-log) 

**Title of Dataset:**  Air Travel Consumer Report: July 2003 [supporting dataset]  

**Description of the Dataset:** The Air Travel Consumer Report is a monthly product of the Department of Transportation's Office of Aviation Enforcement and Proceedings. The report is designed to assist consumers with information on the quality of services provided by the airlines.   

**Dataset Archive Link:** <https://doi.org/10.21949/1530662>  

**Authorship Information:**  

>  *Principal Data Creator Contact Information*   
>  Institution: Office of Aviation Consumer Protection. Department of Transportation ([ROR ID: https://ror.org/02xfw2e90](https://ror.org/02xfw2e90))  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Phone: (202) 366-2220  

>  *Data Distributor Contact Information*  
>  Institution: National Transportation Library ([ROR ID: https://ror.org/00snbrd52](https://ror.org/00snbrd52))   
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Email: <ntldatacurator@dot.gov> and ([National Transportation Library's Ask A Librarian](https://transportation.libanswers.com/))  

>  *Organizational Contact Information*  
>  Institution: Office of Aviation Consumer Protection. Department of Transportation ([ROR ID: https://ror.org/02xfw2e90](https://ror.org/02xfw2e90))  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Phone: (202) 366-2220  

**Date of data collection and update interval:**  
Flight Delays: May 2003 / 12 Months Ending May 2003  
Mishandled Baggage: May 2003  
Oversales: 1st Quarter 2003  
Consumer Complaints: May 2003    

**Geographic location of data collection:** United States [(GeoNames URI: http://sws.geonames.org/6252001/)](http://sws.geonames.org/6252001/)   

**Information about funding sources that supported the collection of the data:** The Office of Aviation Consumer Protection is an office under the Office of the Secretary of Transportation, which is funded and overseen by the Department of Transportation.    

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  Office of Aviation Consumer Protection. Department of Transportation. *Air Travel Consumer Report: July 2003* [supporting dataset]. (2003). <https://doi.org/10.21949/1530662>  

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof.  

**Was data derived from another source?:** No  

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's [Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1](https://doi.org/10.21949/1520559) and [Guidelines Suggested by the DOT Public Access website](https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  

File List for the ATCR_2003_July.zip  

>  1. Filename: Air Travel Consumer Report May 2003 Table 1 Overall Percentage of Reported Flight Operations Arriving on Time By Carrier  
>  Short Description:  This is a table of the number of flights arriving on time by Carrier with percentage of arrivals on time.   

>  2. Filename: Air Travel Consumer Report May 2003 Table 1A. Overall Percentage of Reported Flight Operations   
>  Short Description:  This table has the overall percentage of flights arriving on time by quarter, month, and year.  

>  3. Filename: Air Travel Consumer Report May 2003 Table 2 Number Of Reported Flight Arrivals And Percentage Arriving On Time D   
>  Short Description:  This table is the number of arrivals on time by carrier and airport broken down by airport.  

>  4. Filename: Air Travel Consumer Report May 2003 Table 3 Percentage Of All Carriers' Reported Flight Operations Arriving OnTime D By  
>  Short Description:  This table is the percentage of all carriers' arriving on time by airport and time of day.  

>  5. Filename: Air Travel Consumer Report May 2003 Table 4 Percentage of All Carriers' Reported Flight operations Departing On Time  
>  Short Description:  This table is the percentage of all carriers' departing on time by airport and time of day.  

>  6. Filename: Air Travel Consumer Report May 2003 Table 5 List Of Regularly Scheduled Flights I Arriving Late 80% Of The Time Or More  
>  Short Description:  This is a table of the flights arriving late more than 80% of the time with percentage of how many arrive 15 minutes late or more.  

>  7. Filename: Air Travel Consumer Report May 2003 Table 6 Number And Percentage Of Regularly Schedule Flights I Arriving Late 70% Of The Time Or More  
>  Short Description:  This is the number and percentage of scheduled flights arriving late more than 70% of the time or more.  

>  8. Filename: Air Travel Consumer Report May 2003 Table 7 On-Time Arrival And Departure Percentage By Airport   
>  Short Description:  This table contains all of the percentage of arrivals and departures are on time by airport.  

>  9. Filename: Air Travel Consumer Report May 2003 Table 8. Overall Number and Percentage of Flight Cancellations By Carrier   
>  Short Description:  This table contains the overall number and percentage of flight cancellations by carrier.  

>  10. Filename: Air Travel Consumer Report May 2003 and May 2002 Mishandled Baggage Reports Filed By Passengers  
>  Short Description:  This section gives the rate of mishandled-baggage reports per 1,000 passengers by carrier and for the industry.  

>  11. Filename: Air Travel Consumer Report January through March 2003 and January through March 2002 Passengers denied Boarding By U.S. Airlines  
>  Short Description:  Table of U.S. Airlines and how many passengers were enplaned and how many were denied boarding voluntarily and involuntary by Airline company.  

>  12. Filename: Air Travel Consumer Report May 2003 and May 2002 Consumer Complaints Summary  
>  Short Description:  This table gives a summary of the number of complaints, opinions, compliments, and information requests received by groups in the airlines industry.   

>  13. Filename: Air Travel Consumer Report May 2003 and May 2002 Complaint Categories  
>  Short Description:  Table of total complaints by category. Complaint categories and their complete definition are found at the end of the document.  

>  14. Filename: Air Travel Consumer Report May 2003 Complaints Against U.S. Airlines By Complaint Category  
>  Short Description:  Table of reported problems by complaint category against U.S. Airlines.     

>  15. Filename: Air Travel Consumer Report May 2003 Complaints Against U.S. Airlines By Incident Date  
>  Short Description:  Table of reported problems by incident date against U.S. Airlines  

>  16. Filename: Air Travel Consumer Report May 2003 Companies Other Than U.S. Airlines By Complaint Category  
>  Short Description:  Table of reported problems by complaint category against non-U.S. Airlines.  

>  17. Filename: Air Travel Consumer Report May 2003 Consumer Complaints Rankings U.S. Airlines   
>  Short Description:  Table of complaints by U.S. Airlines ranked from highest to lowest.   

## D. Methodological Information  

**Description of methods used for collection/generation of data:** The sections dealing with flight delays, mishandled baggage, wheelchairs, scooters, and oversales are based on data collected by the Department of Transportation. The section that deals with consumer complaints is based on data compiled by the Office of Aviation Consumer Protection (OACP). The OACP gathers and analyzes complaints submitted by passengers, addressing issues such as customer service, refunds, and other concerns.  

**Instrument or software-specific information needed to interpret the data:** These data tables were originally only available in PDF form. They have been extracted using ABBYY FineReader PDF Software and cleaned in Microsoft Excel. Both Excel and CSV versions of this data are available in this data package. Due to the merged columns and table structure, they are best viewed in XLSX form, but can be viewed in CSV form. If you do not have access to Microsoft Excel, please use an open-source alternative, such as OpenRefine or Notepad ++.  

## E. Data-Specific Information  

Because of the innumerate amount of data tables created for the Air Travel Consumer Report for July 2003, counting the number of rows and columns is too extraneous for this project. Additionally, because these data tables are summaries of the data and not the raw data itself, there are no variables to define, so there is no data dictionary. In the case of null or blank data, this means that the data was either not reported, not applicable, or as reported depending on the question. For these data tables, each null or blank value is explained with footnotes and in the reports.  

## F. Update Log  

This README.md file was originally created on 2024-12-02 by Peyton Tvrdy ([0000-0002-9720-4725](https://orcid.org/0000-0002-9720-4725)), Data Management and Data Curation Fellow, National Transportation Library <peyton.tvrdy.ctr@dot.gov>  
 
2024-12-02: Original file created  
