# README for Air Travel Consumer Report: June 2026 [supporting dataset]  
Office of Aviation Consumer Protection. Office of the Secretary of Transportation, U.S. Department of Transportation (USDOT)  
2024-08-20  
## Links to Dataset  
Dataset Archive Link: <https://doi.org/10.21949/1530673>  
Series Archive Link: <https://doi.org/10.21949/1530604>  

## Summary of Dataset  

The Air Travel Consumer Report is a monthly product of the Department of Transportation's Office of Aviation Enforcement and Proceedings. The report is designed to assist consumers with information on the quality of services provided by the airlines. 

>  Data Coverage  
>  Flight Delays: April 2024 
>  Mishandled Baggage / Wheelchairs and Scooters: April 2024
>  Oversales: 1st Quarter 2024 
>  Consumer Complaints:  See Report for Details
>  Customer Service Reports to the Dept. of Homeland Security: April 2024
>  Airline Animal Incident Reports: April 2024  

## Table of Contents  
A. [General Information](#a-general-information)  
B. [Sharing/Access & Policies Information](#b-sharingaccess-and-policies-information)  
C. [Data and Related Files Overview](#c-data-and-related-files-overview)  
D. [Methodological Information](#d-methodological-information)  
E. [Data-Specific Information for: Air Travel Consumer Report: June 2026 [supporting dataset]](#e-data-specific-information)  
F. [Update Log](#f-update-log) 

**Title of Dataset:**  Air Travel Consumer Report: June 2026 [supporting dataset]  

**Description of the Dataset:** The Air Travel Consumer Report is a monthly product of the Department of Transportation's Office of Aviation Enforcement and Proceedings. The report is designed to assist consumers with information on the quality of services provided by the airlines.   

**Dataset Archive Link:** <https://doi.org/10.21949/1530673>  

**Authorship Information:**  

>  *Principal Data Creator Contact Information*   
>  Institution: Office of Aviation Consumer Protection. Department of Transportation ([ROR ID: https://ror.org/02xfw2e90](https://ror.org/02xfw2e90))  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Phone: (202) 366-2220  

>  *Data Distributor Contact Information*  
>  Institution: National Transportation Library ([ROR ID: https://ror.org/00snbrd52](https://ror.org/00snbrd52))   
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Email: <ntldatacurator@dot.gov> and ([National Transportation Library's Ask A Librarian](https://transportation.libanswers.com/))  

>  *Organizational Contact Information*  
>  Institution: Office of Aviation Consumer Protection. Department of Transportation ([ROR ID: https://ror.org/02xfw2e90](https://ror.org/02xfw2e90))  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Phone: (202) 366-2220  

**Date of data collection and update interval:**  
Flight Delays: April 2024 
Mishandled Baggage / Wheelchairs and Scooters: April 2024
Oversales: 1st Quarter 2024 
Consumer Complaints:  See Report for Details
Customer Service Reports to the Dept. of Homeland Security: April 2024
Airline Animal Incident Reports: April 2024  

**Geographic location of data collection:** United States [(GeoNames URI: http://sws.geonames.org/6252001/)](http://sws.geonames.org/6252001/)   

**Information about funding sources that supported the collection of the data:** The Office of Aviation Consumer Protection is an office under the Office of the Secretary of Transportation, which is funded and overseen by the Department of Transportation.    

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  Office of Aviation Consumer Protection. Department of Transportation. *Air Travel Consumer Report: June 2026* [supporting dataset]. (2024). <https://doi.org/10.21949/1530673>  

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof.  

**Was data derived from another source?:** No  

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's [Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1](https://doi.org/10.21949/1520559) and [Guidelines Suggested by the DOT Public Access website](https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  

File List for the ATCR_2024_June.zip  

>  1. Filename: Air Travel Consumer Report April 2024 Table 1 Overall Percentage of Reported Flight Operations Arriving on Time By Reporting Marketing Carrier  
>  Short Description:  This table contains the overall percentage of flight operations arriving on time by reporting marketing carrier.   

>  2. Filename: Air Travel Consumer Report April 2024 Table 1A Overall Percentage of Reported Flight Operations Arrive on Time By Reporting Operating Carrier   
>  Short Description:  This table contains the overall percentage of reported flight operations arriving on-time by reporting operating carrier.  

>  3. Filename: Air Travel Consumer Report April 2024 Table 1B Overall Percentage of Reported Flight Operations Arriving on Time by Reporting Marketing Carrier   
>  Short Description:  This table contains the overall percentage of reported flight operations arriving on-time by reporting marketing carrier.  

>  4. Filename: Air Travel Consumer Report April 2024 Table 2 Number Of Reported Flight Arrivals And Percentage Arriving On Time D by Reporting Marketing Carrier  
>  Short Description:  This table contains the number of reported flight arrivals and percentage arriving on0time by reporting marketing carrier and airport.  

>  5. Filename: Air Travel Consumer Report April 2024 Table 2A. Number of Reported Flight Arrivals and Percentage Arriving On-Time  
>  Short Description:  This table contains the number of reported flight arrivals and percentage arriving on-time by reporting operating carrier and airport.  

>  6. Filename: Air Travel Consumer Report April 2024 Table 3 Percentage Of All Carriers' Reported Flight Operations Arriving OnTime D By  
>  Short Description:  This table contains the percentage of reporting operating carriers flight operations arriving on-time by airport and time of day.  

>  7. Filename: Air Travel Consumer Report April 2024 Table 4 Percentage of All Carriers' Reported Flight operations Departing On Time  
>  Short Description:  This table contains the percentage of reporting operating carriers flight operations departing on-time by airport and time of day.  

>  8. Filename: Air Travel Consumer Report April 2024 Table 5 List Of Regularly Scheduled Flights I Arriving Late 80% Of The Time Or More   
>  Short Description:  This table contains the on-time arrival and departure percentage by airport by reporting operating carrier.  

>  9. Filename: Air Travel Consumer Report April 2024 Table 6 Number And Percentage Of Regularly Schedule Flights I Arriving Late 70% Of The Time Or More   
>  Short Description:  This table contains the overall number and percentage of flight cancellations by reporting marketing carrier.  

>  10. Filename: Air Travel Consumer Report April 2024 Table 6A Overall Number and Percentage of Flight Cancellations by Reporting Operating Carrier  
>  Short Description:  This table contains the overall number and percentage of flight cancellations by reporting operating carrier.  

>  11. Filename: Air Travel Consumer Report April 2024 Table 7 On-Time Arrival And Departure Percentage By Airport  
>  Short Description:  This table contains the on-time arrival and departure percentage by airport.  

>  12. Filename: Air Travel Consumer Report April 2024 Table 7A Causes of Delay by Reporting Operating Carrier  
>  Short Description:  This table contains the causes of delay for flights by reporting operating carrier.     

>  13. Filename: Air Travel Consumer Report April 2024 Table 8. Overall Number and Percentage of Flight Cancellations By Carrier  
>  Short Description:  This table contains the list of domestic flights with tarmac delays over 3 hours by marketing/operating carrier.   

>  14. Filename: Air Travel Consumer Report April 2024 Table 8A List of International Flights with Tarmac Delays Over 4 Hours by Marketing Operating Carrier  
>  Short Description:  This table contains the list of international flights with tarmac delays over 3 hours by marketing/operating carrier.  

>  15. Filename: Air Travel Consumer Report April 2024 and April 2023 Mishandled Baggage Ranking of U.S. Reporting Marketing Carriers Monthly  
>  Short Description:  This report compares April  2023 and 2022 monthly mishandled baggage rankings among marketing airline carriers.  

>  16. Filename: Air Travel Consumer Report April 2024 and April 2023 Mishandled Baggage Ranking of U.S. Reporting Operating Carriers Monthly  
>  Short Description:  This report compares April  2023 and 2022 monthly mishandled baggage rankings among operating airline carriers.  

>  17. Filename: Air Travel Consumer Report April 2024 and April 2023 Mishandled Wheelchairs and Scooters Rankings Marketing Carriers Monthly   
>  Short Description:  This report compares April  2023 and 2022 monthly mishandled wheelchair and scooter rankings among marketing airline carriers.   

>  18. Filename: Air Travel Consumer Report April 2024 and April 2023 Mishandled Wheelchairs and Scooters Rankings Operating Carriers Monthly   
>  Short Description:  This report compares April  2023 and 2022 monthly mishandled wheelchair and scooter rankings among operating airline carriers.  

>  19. Filename: Air Travel Consumer Report January through March 2024 and January through March 2023 Passengers denied Boarding By Reporting Marketing   
>  Short Description:  This table contains data from January through March 2024 and January through March 2023 of passengers who were denied boarding by a marketing airline.  

>  20. Filename: Air Travel Consumer Report January through March 2024 and January through March 2023 Passengers denied Boarding By Reporting Operating  
>  Short Description:  This table contains data from January through December 2023 and January through December 2022 of passengers who were denied boarding by a operating airline.  

>  21. Filename: Air Travel Consumer Report April 2024 U.S. Department of Homeland Security Customer Experience Report  
>  Short Description:  This table contains the data from the Transportation Security Administration (TSA)'s customer experience report.  

## D. Methodological Information  

**Description of methods used for collection/generation of data:** The sections dealing with flight delays, mishandled baggage, wheelchairs, scooters, and oversales are based on data collected by the Department of Transportation. The section that deals with consumer complaints is based on data compiled by the Office of Aviation Consumer Protection (OACP). The OACP gathers and analyzes complaints submitted by passengers, addressing issues such as customer service, refunds, and other concerns.  

**Instrument or software-specific information needed to interpret the data:** These data tables were originally only available in PDF form. They have been extracted using ABBYY FineReader PDF Software and cleaned in Microsoft Excel. Both Excel and CSV versions of this data are available in this data package. Due to the merged columns and table structure, they are best viewed in XLSX form, but can be viewed in CSV form. If you do not have access to Microsoft Excel, please use an open-source alternative, such as OpenRefine or Notepad ++.  

## E. Data-Specific Information  

Because of the innumerate amount of data tables created for the Air Travel Consumer Report for June 2026, counting the number of rows and columns is too extraneous for this project. Additionally, because these data tables are summaries of the data and not the raw data itself, there are no variables to define, so there is no data dictionary. In the case of null or blank data, this means that the data was either not reported, not applicable, or as reported depending on the question. For these data tables, each null or blank value is explained with footnotes and in the reports.  

## F. Update Log  

This README.md file was originally created on 2024-08-20 by Peyton Tvrdy ([0000-0002-9720-4725](https://orcid.org/0000-0002-9720-4725)), Data Management and Data Curation Fellow, National Transportation Library <peyton.tvrdy.ctr@dot.gov>  
 
2024-08-20: Original file created  
