# README for Air Travel Consumer Report September 1999  
Office of Aviation Enforcement and Proceedings/Office of Aviation Consumer Protection. Office of the Secretary of Transportation, U.S. Department of Transportation (USDOT)  
2024-07-05  
## Links to Dataset  
Dataset Archive Link: <https://doi.org/10.21949/1530615>  
Series Archive Link: <https://doi.org/10.21949/1530604>  

## Summary of Dataset  

The Air Travel Consumer Report is a monthly product of the Department of Transportation's Office of Aviation Enforcement and Proceedings. The report is designed to assist consumers with information on the quality of services provided by the airlines. The report is divided into four sections. These sections deal with flight delays, mishandled baggage, oversales and consumer complaints. Each section of the report is preceded by a brief explanation of how to read and understand the information provided.  

>  Data Coverage  
>  Flight Delays: July 1999  
>  Mishandled Baggage: July 1999  
>  Oversales: 2nd Quarter 1999 / January - June 1999  
>  Consumer Complaints: July 1999 Tables 1-5 / July 1999 (Table 6)      

## Table of Contents  
##### A. General Information  
##### B. Sharing/Access & Policies Information  
##### C. Data and Related Files Overview  
##### D. Methodological Information  
##### E. Data-Specific Information for: Air Travel Consumer Report September 1999  
##### F. Update Log  
## A. General Information  

**Title of Dataset:**  Air Travel Consumer Report September 1999 

**Description of the Dataset:** The Air Travel Consumer Report is a monthly product of the Department of Transportation's Office of Aviation Enforcement and Proceedings. The report is designed to assist consumers with information on the quality of services provided by the airlines. The report is divided into four sections. These sections deal with flight delays, mishandled baggage, oversales and consumer complaints. Each section of the report is preceded by a brief explanation of how to read and understand the information provided.  

**Dataset Archive Link:** <https://doi.org/10.21949/1530615>

**Authorship Information:**  

>  *Principal Data Creator Contact Information*   
>  Institution: Office of Aviation Consumer Protection. Department of Transportation ([ROR ID: https://ror.org/02xfw2e90](https://ror.org/02xfw2e90))  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Phone: (202) 366-2220  

>  *Data Distributor Contact Information*  
>  Institution: National Transportation Library ([ROR ID: https://ror.org/00snbrd52](https://ror.org/00snbrd52))   
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Email: <ntldatacurator@dot.gov> and ([National Transportation Library's Ask A Librarian](https://transportation.libanswers.com/))  

>  *Organizational Contact Information*  
>  Institution: Office of Aviation Consumer Protection. Department of Transportation ([ROR ID: https://ror.org/02xfw2e90](https://ror.org/02xfw2e90))  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Phone: (202) 366-2220  

**Date of data collection and update interval:**  
Flight Delays: July 1999  
Mishandled Baggage: July 1999  
Oversales: 2nd Quarter 1999 / January - June 1999  
Consumer Complaints: July 1999 Tables 1-5 / July 1999 (Table 6)      

**Geographic location of data collection:** United States  

**Information about funding sources that supported the collection of the data:** The Office of Aviation Consumer Protection is an office under the Office of the Secretary of Transportation, which is funded and overseen by the Department of Transportation.    

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  Office of Aviation Consumer Protection. Department of Transportation. *Air Travel Consumer Report September 1999* [dataset]. (1999). <https://doi.org/10.21949/1530615>  

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof.  

**Was data derived from another source?:** No  

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's [Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1](https://doi.org/10.21949/1520559) and [Guidelines Suggested by the DOT Public Access website](https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  

File List for the ATCR_1999_September.zip  

>  1. Filename: Air Travel Consumer Report April 1999 and June 1999 and April 1998 and June 1998 Passengers denied Boarding By U.S. Airlines.xlsx  
>  Short Description:  Table of U.S. Airlines and how many passengers were enplaned and how many were denied boarding voluntarily and involuntary by Airline company.   

>  2. Filename: Air Travel Consumer Report January 1999 and June 1999 and January 1998 and June 1998 Passengers denied Boarding By U.S. Airlines.xlsx  
>  Short Description:  Table of U.S. Airlines and how many passengers were enplaned and how many were denied boarding voluntarily and involuntary by Airline company.  

>  3. Filename: Air Travel Consumer Report July 1999 and July 1998 Complaint Categories.xlsx  
>  Short Description:  Table of total complaints by category. Complaint categories and their complete definition are found at the end of the document.  

>  4. Filename: Air Travel Consumer Report July 1999 and July 1998 Consumer Complaints Summary.xlsx  
>  Short Description:  This table gives a summary of the number of complaints, opinions, compliments, and information requests received by groups in the airlines industry.  

>  5. Filename: Air Travel Consumer Report July 1999 and July 1998 Mishandled Baggage Reports Filed By Passengers.xlsx  
>  Short Description:  This section gives the rate of mishandled-baggage reports per 1,000 passengers by carrier and for the industry.  

>  6. Filename: Air Travel Consumer Report July 1999 Companies Other Than U.S. Airlines By Complaint Category.xlsx  
>  Short Description:  Table of reported problems by complaint category against non-U.S. Airlines. 

>  7. Filename: Air Travel Consumer Report July 1999 Complaints Against U.S. Airlines By Complaint Category.xlsx  
>  Short Description:  Table of reported problems by complaint category against non-U.S. Airlines.  

>  8. Filename: Air Travel Consumer Report July 1999 Complaints Against U.S. Airlines By Incident Date.xlsx  
>  Short Description:  Table of reported problems by incident date against U.S. Airlines.  

>  9. Filename: Air Travel Consumer Report July 1999 Consumer Complaints Rankings U.S. Airlines.xlsx  
>  Short Description:  Table of complaints by U.S. Airlines ranked from highest to lowest.  

>  10. Filename: Air Travel Consumer Report July 1999 Table 1 Overall Percentage of Reported Flight Operations Arriving on Time By Carrier.xlsx  
>  Short Description:  This is a table of the number of flights arriving on time by Carrier with percentage of arrivals on time.  

>  11. Filename: Air Travel Consumer Report July 1999 Table 1A. Overall Percentage of Reported Flight Operations.xlsx  
>  Short Description:  This table has the overall percentage of flights arriving on time by quarter, month, and year.  

>  12. Filename: Air Travel Consumer Report July 1999 Table 2 Number Of Reported Flight Arrivals And Percentage Arriving On Time D.xlsx  
>  Short Description:  This table is the number of arrivals on time by carrier and airport broken down by airport.  

>  13. Filename: Air Travel Consumer Report July 1999 Table 3 Percentage Of All Carriers' Reported Flight Operations Arriving OnTime D By.xlsx  
>  Short Description:  This table is the percentage of all carriers' arriving on time by airport and time of day. 

>  14. Filename: Air Travel Consumer Report July 1999 Table 4 Percentage of All Carriers' Reported Flight operations Departing On Time.xlsx  
>  Short Description:  This table is the percentage of all carriers' departing on time by airport and time of day.  

>  15. Filename: Air Travel Consumer Report July 1999 Table 5 List Of Regularly Scheduled Flights I Arriving Late 80% Of The Time Or More.xlsx  
>  Short Description:  This is a table of the flights arriving late more than 80% of the time with percentage of how many arrive 15 minutes late or more.  

>  16. Filename: Air Travel Consumer Report July 1999 Table 6 Number And Percentage Of Regularly Schedule Flights I Arriving Late 70% Of The Time Or More.xlsx  
>  Short Description:  This is the number and percentage of scheduled flights arriving late more than 70% of the time or more.

>  17. Filename: Air Travel Consumer Report July 1999 Table 7 On-Time Arrival And Departure Percentage By Airport.xlsx  
>  Short Description:  This table contains all of the percentage of arrivals and departures are on time by airport.  

## D. Methodological Information  

**Description of methods used for collection/generation of data:** The sections dealing with flight delays, mishandled baggage, wheelchairs, scooters, and oversales are based on data collected by the Department of Transportation. The section that deals with consumer complaints is based on data compiled by the Office of Aviation Consumer Protection (OACP). The OACP gathers and analyzes complaints submitted by passengers, addressing issues such as customer service, refunds, and other concerns.  

**Instrument or software-specific information needed to interpret the data:** These data tables were originally only available in PDF form. They have been extracted using ABBYY FineReader PDF Software and cleaned in Microsoft Excel. Both Excel and CSV versions of this data is available in this data package. These files are in CSV and XLSX form. Due to the merged columns and table structure, they are best viewed in XLSX form, but can be viewed in CSV form.  

## E. Data-Specific Information  

Because of the innumerate amount of data tables created for the Air Travel Consumer Report for September 1999, counting the number of rows and columns is too extraneous for this project. Additionally, because these data tables are summaries of the data and not the raw data itself, there are no variables to define, so there is no data dictionary. In the case of null or blank data, this means that the data was either not reported, not applicable, or as reported depending on the question. For these data tables, each null or blank value is explained with footnotes and in the reports.  

## F. Update Log  

This README.txt file was originally created on 2024-07-05 by Peyton Tvrdy ([0000-0002-9720-4725](https://orcid.org/0000-0002-9720-4725)), Data Management and Data Curation Fellow, National Transportation Library <peyton.tvrdy.ctr@dot.gov>  
 
2024-07-05: Original file created  
