
# README for A Machine Learning-Assisted Framework for Determination of Performance Degradation Causes and Selection of Channel Switching Strategy in Vehicular Networks [supporting datasets]  
Civil Aerospace Medical Institute, Federal Aviation Administration, U.S. Department of Transportation (USDOT)  
2024-06-13  

## Links to Dataset  
Dataset Archive Link: <https://doi.org/10.21949/1530875>  

## Summary of Dataset  

As all three major US mobile carriers have launched their own 5G networks and are working hard to expand their coverage nationwide, 5G has come into everyone’s daily life. 5G networks use millimeter-wave (mm-Wave) for higher speeds, while 4G long-term evolution (LTE) networks favor lower-band spectrum for better coverage. Vehicle-to-vehicle (V2V) communication enables wireless communication between cars and exchanges their speed, location, and acceleration information. 5G mm-Wave and 4G LTE bands are used in V2V sidelink transmissions. These two wireless channels are affected by different weather conditions, such as rain, snow, dust, and sand. Compared with 4G networks, 5G networks are designed to accommodate the increasing number of devices with higher transfer speed, lower latency, and improved security. However, our study shows that severe weather degrades the 5G performance more significantly than 4G. In this paper, we use NS-3 as a simulator to study the effect of harsh weather of dust or sand on the propagating loss of 5G mm-Wave and 4G LTE signal. We investigate their performance degradation and use a time-series machine learning technique, long short-term memory (LSTM), to predict future signal strength for 5G and 4G. Our simulation results show that LSTM performs well in forecasting signal strength, and we plan to design a system that can dynamically choose the better wireless channel in the future.  

## Tables of Contents  
A. [General Information](#a-general-information)  
B. [Sharing/Access & Policies Information](#b-sharingaccess-and-policies-information)  
C. [Data and Related Files Overview](#c-data-and-related-files-overview)  
D. [Methodological Information](#d-methodological-information)  
E. [Data-Specific Information for: What Do Americans Think About Federal Tax Options to Support Transportation? Results From Year Fifteen of a National Survey [supporting dataset]](#e-data-specific-information)  
F. [Update Log](#f-update-log)  

**Title of Dataset:**  A Machine Learning-Assisted Framework for Determination of Performance Degradation Causes and Selection of Channel Switching Strategy in Vehicular Networks [supporting datasets]  

**Description of the Dataset:** As all three major US mobile carriers have launched their own 5G networks and are working hard to expand their coverage nationwide, 5G has come into everyone’s daily life. 5G networks use millimeter-wave (mm-Wave) for higher speeds, while 4G long-term evolution (LTE) networks favor lower-band spectrum for better coverage. Vehicle-to-vehicle (V2V) communication enables wireless communication between cars and exchanges their speed, location, and acceleration information. 5G mm-Wave and 4G LTE bands are used in V2V sidelink transmissions. These two wireless channels are affected by different weather conditions, such as rain, snow, dust, and sand. Compared with 4G networks, 5G networks are designed to accommodate the increasing number of devices with higher transfer speed, lower latency, and improved security. However, our study shows that severe weather degrades the 5G performance more significantly than 4G. In this paper, we use NS-3 as a simulator to study the effect of harsh weather of dust or sand on the propagating loss of 5G mm-Wave and 4G LTE signal. We investigate their performance degradation and use a time-series machine learning technique, long short-term memory (LSTM), to predict future signal strength for 5G and 4G. Our simulation results show that LSTM performs well in forecasting signal strength, and we plan to design a system that can dynamically choose the better wireless channel in the future.  

**Dataset Archive Link:** <https://doi.org/10.21949/1530875>  

**Report Archive Link:** <https://rosap.ntl.bts.gov/view/dot/68107>  

**Technology Transfer Archive Link:** <https://rosap.ntl.bts.gov/view/dot/74013>  

This project and dataset also resulted in the creation of 3 seperate journal articles. They are as follows:  

**Switching Strategy for Connected Vehicles Under Variant Harsh Weather Conditions:**  <https://doi.org/10.1109/JRFID.2023.3274602>  

**Investigation of 5G and 4G V2V Communication Channel Performance Under Severe Weather:**  <https://doi.org/10.1109/WiSEE49342.2022.9926867>  

**The Effect of Dust and Sand on the Propagating EM Millimeter Plane Wave:**  <https://doi.org/10.1109/WiSEE49342.2022.9926914>  


**Authorship Information:**  

>  *Principal Data Creator or Data Manager Contact Information*  
>  Name: Chin Tser Huang [(0000-0003-3983-972X)](https://orcid.org/0000-0003-3983-972X)  
>  Institution: University of South Carolina [(ROR ID: https://ror.org/02b6qw903)](https://ror.org/02b6qw903)  
>  Address: 550 Assembly Street, Columbia, SC 2920  
>  Email: <HUANGCT@cse.sc.edu>  

>  *Data Distributor Contact Information*    
>  Institution: National Transportation Library  [(ROR ID: https://ror.org/00snbrd52)](https://ror.org/00snbrd52)  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Email: <NTLDataCurator@dot.gov>  

>  *Additional Author*  
>  Name: Gurcan Comert [(0000-0002-2373-5013)](https://orcid.org/0000-0002-2373-5013)  
>  Institution: Benedict College [(ROR ID: https://ror.org/045r9wn29)](https://ror.org/045r9wn29)   
>  Address: 1600 Harden Street, Columbia, SC 29204  

>  *Additional Author*  
>  Name: Esmail Abuhdima [(0000-0003-1121-6467)](https://orcid.org/0000-0003-1121-6467)  
>  Institution:  Benedict College [(ROR ID: https://ror.org/045r9wn29)](https://ror.org/045r9wn29)  
>  Address: 1600 Harden Street, Columbia, SC 29204   

>  *Additional Author*  
>  Name: Pierluigi Pisu [(0000-0003-4266-1336)](https://orcid.org/0000-0003-4266-1336)  
>  Institution: Clemson University [(ROR ID: https://ror.org/037s24f05)](https://ror.org/037s24f05)    
>  Address: 201 Sikes Hall, Clemson, SC 29634   

>  *Additional Author*  
>  Name: Jian Liu [(0000-0001-8368-6228)](https://orcid.org/0000-0001-8368-6228)  
>  Institution: University of South Carolina [(ROR ID: https://ror.org/02b6qw903)](https://ror.org/02b6qw903)  
>  Address: 514 Main St, Columbia, SC 29208   

>  *Additional Author*  
>  Name: Amirhossein Nazeri [(0000-0002-7396-2572)](https://orcid.org/0000-0002-7396-2572)  
>  Institution: Clemson University [(ROR ID: https://ror.org/037s24f05)](https://ror.org/037s24f05)    
>  Address: 201 Sikes Hall, Clemson, SC 29634   


**Geographic location of data collection:** United States [(GeoNames URI: http://sws.geonames.org/6252001/)](http://sws.geonames.org/6252001/)  

**Information about funding sources that supported the collection of the data:** This study is partially supported by the Center for Connected Multimodal Mobility (C2M2) (USDOT Tier 1 University Transportation Center) headquartered at Clemson University, Clemson, SC. Any opinions, findings, and conclusions or recommendations expressed in this paper are those of the authors and do not necessarily reflect the views of C2M2and the official policy or position of the USDOT/OST-R, or any State or other entity, and the U.S. Government assumes no liability for the contents or use thereof. It is also partially supported by U.S. Department of Energy-National Nuclear Security Administration (NNSA) PuMP, MSIPP IAM-EMPOWEREd, MSIPP, Department of Education MSEIP programs, NASA ULI (University of South Carolina-Lead), and NSF Grant Nos. 1719501, 1954532, and 2131080.  

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  United States. Department of Transportation. Federal Aviation Administration. Office of Aviation. Civil Aerospace Medical Institute (2024). *A Machine Learning-Assisted Framework for Determination of Performance Degradation Causes and Selection of Channel Switching Strategy in Vehicular Networks [supporting datasets]*. <https://doi.org/10.21949/1530875>  

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof.  

**Was data derived from another source?:** No  

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's [Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1](https://doi.org/10.21949/1520559) and [Guidelines suggested by the DOT Public Access website](https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  

**File List for the 97168_DATASET.zip**  

Data for Investigation of 5G and 4G V2V Communication Channel Performance Under Severe Weather  
>  1. Filename: 4G LTE.csv  
>  Short Description:  4G data file.   

>  2. Filename: 5G mmWave.csv   
>  Short Description:  5G data file.  

>  3. Filename: Arizona weather data.csv  
>  Short Description:  Arizona Weather data file.    

>  4. Filename: lstm.py  
>  Short Description:  Data model program.  

>  5. Filename: mlstm.py  
>  Short Description:  Data model program.  

Data for Switching Strategy for Connected Vehicles Under Variant Harsh Weather Conditions  
>  1. Filename: Fig10-severe medium 28G_Fig10.csv  
>  Short Description:  Data with figure.  

>  2. Filename: Fig3- moderate large_Fig3.csv  
>  Short Description:  Data with figure. 

>  3. Filename: Fig4-moderate medium_Fig4.csv  
>  Short Description:  Data with figure.  

>  4. Filename: Fig5-moderate small_Fig5.csv  
>  Short Description:  Data with figure.  

>  5. Filename: Fig6-severe large_Fig6.csv  
>  Short Description:  Data with figure.  

>  6. Filename: Fig7-severe medium_Fig7.csv  
>  Short Description:  Data with figure.   

>  7. Filename: Fig8-severe small_Fig8.csv  
>  Short Description:  Data with figure.  

>  8. Filename: Fig9-moderate large 39G_Fig9.csv   
>  Short Description:  Data with figure.  

>  9. Filename:  moderatelarge.png  
>  Short Description:  PNG version of chart.  

>  10. Filename:  moderatemedium.png  
>  Short Description:  PNG version of chart.   

>  11. Filename:  moderatesmall.png  
>  Short Description:  PNG version of chart.  

>  12. Filename:  severelarge.png  
>  Short Description:  PNG version of chart.  

>  13. Filename:  severemedium.png  
>  Short Description:  PNG version of chart.  

>  14. Filename:  severesmall.png  
>  Short Description:  PNG version of chart.  

Data for The Effect of Dust and Sand on the Propagating EM Millimeter Plane Wave
>  1. Filename: Data_Figures.pdf  
>  Short Description:  PDF version of figures and charts.  

>  2. Filename: The_effect_of_dust_and_sand_on_the_propagating_EM_milimeter_plane_wave_Dataset.csv  
>  Short Description:  CSV version of the data.  

>  3. Filename: The_effect_of_dust_and_sand_on_the_propagating_EM_milimeter_plane_wave_Dataset.xlsx  
>  Short Description:  XLSX version of the data.  

## D. Methodological Information  

**Description of methods used for collection/generation of data:** This report’s primary mathematical starting point is the attenuation model for weather impacts. Received Signal Strength Indicator is one novel metric we introduced in our model to study wireless transmission between transmitter and receiver in a V2V sidelink scenario. LSTM is the machine learning model we used to forecast future RSSI values.  

**Instrument or software-specific information needed to interpret the data:** All dataset files are in CSV form or have a CSV version. CSVs can be opened and viewed using openly using Notepad++ or OpenRefine. PDFs can be viewed with any standard PDF viewer or web browser. PNGs can be viewed using any photo viewer standard with your computer. Python files can be opened and viewed using Notepad++ and can be run with open software such as PyCharm.  

## E. Data-Specific Information  

Due to the large size and quanitity of the dataset, the variable definitions and counts will not be detailed in this section. Please consult each individual journal article, the overall report, and the READMEs included in each folder.  

## F. Update Log  

This README.txt file was originally created on 2024-06-13 by Peyton Tvrdy ([0000-0002-9720-4725](https://orcid.org/0000-0002-9720-4725)), Data Management and Data Curation Fellow, National Transportation Library <peyton.tvrdy.ctr@dot.gov>  
 
2024-06-13: Original file created  