# README for Aircraft Air Quality and Bleed Air Contamination Detection [supporting datasets]  
William J. Hughes Technical Center, Federal Aviation Administration (FAA), U.S. Department of Transportation (USDOT)    
2025-03-04 
## Links to Dataset  
Dataset Archive Link: <https://doi.org/10.21949/1524480>  
## Summary of Dataset  

The purpose of this project was to provide a data driven process to identify sensor technologies with the potential for detecting and identifying low levels of contaminants that may occasionally be present in aircraft engine bleed air supplies. Bleed air from a ground-based aircraft propulsion engine and an auxiliary power unit (APU) were used to supply air through an ozone/volatile organic compound (VOC) converter to the environmental control system on a Boeing 747, while injecting controlled amounts of fluid contaminants (i.e., aircraft engine oil, hydraulic fluid, and deicing fluid). Measurements of contaminants were performed at the ozone/VOC converter inlet and exit, and at the air conditioning pack exit. Ultrafine particles (UFP) were found to be a sensitive marker for engine oil contamination with measurements at all three locations showing similar, highly elevated UFP concentrations with a mean diameter near 40nm and smaller when the sample stream was cooled to near room temperature. In situ measurements showed that UFPs are generated by condensation and high UFP concentrations were not detected in uncooled bleed air. Oil contamination VOC levels were very low upstream of the ozone/VOC converter at bleed air temperatures up to 220˚C and increased at bleed temperatures of around 315˚C; however, oil contamination VOC levels remained at sub-ppmv levels. Fine particle concentrations also increased with oil contamination at lower bleed air temperatures, but not with temperatures around 315 ˚C. Secondary contaminants including pentanoic acid, heptanoic acid, acetic acid, formaldehyde, and acetaldehyde formed in the ozone/VOC converter as the oil aerosol oxidized. Consideration must be given to contaminant deposition within the bleed air system and sample lines as this deposition may lead to delayed responses and contaminant release during temperature transients. Of the sensor technologies assessed, spectrometers provided the best opportunity to detect and identify contaminants. Carbon monoxide (CO) measurements confirmed that CO is not generated in sufficient quantities to be of value as a marker for engine oil or hydraulic fluid contamination of bleed air. CO may be useful as a marker for ingestion of engine exhaust in some cases. However, carbon dioxide (CO2) is a much better marker for engine exhaust ingestion.  

## Table of Contents  

A. [General Information](#a-general-information)  
B. [Sharing/Access & Policies Information](#b-sharingaccess-and-policies-information)  
C. [Data and Related Files Overview](#c-data-and-related-files-overview)  
D. [Methodological Information](#d-methodological-information)  
E. [Update Log](#e-update-log)  

**Title of Dataset:**  Aircraft Air Quality and Bleed Air Contamination Detection [supporting datasets]  

**Description of the Dataset:** The purpose of this project was to provide a data driven process to identify sensor technologies with the potential for detecting and identifying low levels of contaminants that may occasionally be present in aircraft engine bleed air supplies. Bleed air from a ground-based aircraft propulsion engine and an auxiliary power unit (APU) were used to supply air through an ozone/volatile organic compound (VOC) converter to the environmental control system on a Boeing 747, while injecting controlled amounts of fluid contaminants (i.e., aircraft engine oil, hydraulic fluid, and deicing fluid). Measurements of contaminants were performed at the ozone/VOC converter inlet and exit, and at the air conditioning pack exit. Ultrafine particles (UFP) were found to be a sensitive marker for engine oil contamination with measurements at all three locations showing similar, highly elevated UFP concentrations with a mean diameter near 40nm and smaller when the sample stream was cooled to near room temperature. In situ measurements showed that UFPs are generated by condensation and high UFP concentrations were not detected in uncooled bleed air. Oil contamination VOC levels were very low upstream of the ozone/VOC converter at bleed air temperatures up to 220˚C and increased at bleed temperatures of around 315˚C; however, oil contamination VOC levels remained at sub-ppmv levels. Fine particle concentrations also increased with oil contamination at lower bleed air temperatures, but not with temperatures around 315 ˚C. Secondary contaminants including pentanoic acid, heptanoic acid, acetic acid, formaldehyde, and acetaldehyde formed in the ozone/VOC converter as the oil aerosol oxidized. Consideration must be given to contaminant deposition within the bleed air system and sample lines as this deposition may lead to delayed responses and contaminant release during temperature transients. Of the sensor technologies assessed, spectrometers provided the best opportunity to detect and identify contaminants. Carbon monoxide (CO) measurements confirmed that CO is not generated in sufficient quantities to be of value as a marker for engine oil or hydraulic fluid contamination of bleed air. CO may be useful as a marker for ingestion of engine exhaust in some cases. However, carbon dioxide (CO2) is a much better marker for engine exhaust ingestion.  

**Dataset Archive Link:** <https://doi.org/10.21949/1524480>  

**Authorship Information:**  

>  *Author Contact Information*  
>  Name: Byron Jones ([https://orcid.org/0000-0002-9791-9448](`https://orcid.org/0000-0002-9791-9448`))    
>  Institution: Kansas State University [(ROR ID: https://ror.org/05p1j8758)](https://ror.org/05p1j8758)  
>  Address: 110 Anderson Hall, 919 Mid-Campus Drive North, Manhattan, KS 66506-0110   
>  Email: [jones@k-state.edu](mailto:jones@k-state.edu)  

>  *Data Distributor Contact Information*  
>  Name: National Transportation Library Data Services Team  
>  Institution: National Transportation Library [(ROR ID: https://ror.org/00snbrd52)](https://ror.org/00snbrd52)  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Email: [NTLDataCurator@dot.gov](NTLDataCurator@dot.gov)  

>  *Organizational Contact Information*  
>  Name: Stadtmueller, Traci     
>  Institution: Federal Aviation Administration [(ROR ID: https://ror.org/05q0y0j38)](https://ror.org/05q0y0j38)  
>  Address: William J. Hughes Technical Center, Atlantic City International Airport, NJ 08405  
>  Email: [traci.stadtmueller@faa.gov](mailto:traci.stadtmueller@faa.gov)  


**Geographic location of data collection:** United States [(GeoNames URI: http://sws.geonames.org/6252001/)](http://sws.geonames.org/6252001/)   

**Information about funding sources that supported the collection of the data:** This project was funded through the US Department of Transportation's Federal Aviation Administration through the William J. Hughes Technical Center. The contract number is: 693KA9-20-P-00033.  

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  Jones, Byron W. *"Aircraft Air Quality and Bleed Air Contamination Detection [supporting datasets]"* (2022), Federal Aviation Administration, William J. Hughes Technical Center <https://doi.org/10.21949/1524480>  

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof.  The usage of the data in this dataset requires attribution not only to the authors and the federal government, but the express attribution to the laboratories that provided the reports. When reusing and citing this research, ensure attribution to all parties is included. This item is made available under the terms of the Creative Commons Attribution 4.0 International (CC BY 4.0) license <https://creativecommons.org/licenses/by/4.0/>.

**Was data derived from another source?:** Partially, most is original data. Read more about the dataset in [Section C. Data and Related Files Overview](#c-data-and-related-files-overview)     

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's [Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1](https://doi.org/10.21949/1520559) and [Guidelines suggested by the DOT Public Access website](https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  
The dataset for the report [Aircraft Air Quality and Bleed Air Contamination Detection](https://doi.org/10.21949/1524479) contains many files. The complete file list can be found below.

**Original File List for the 87301_DATASET.zip**  
1. 2020-11-12 APS.xlsx  
2. 2020-11-13 APS.xlsx  
3. 2020-11-12-13 Log.xlsx  
4. 2020-11-12 SMPS.xlsx  
5. 2020-11-13 SMPS.xlsx  
6. 2021-07-16 APS bleed.xlsx  
7. 2021-08-02 APS bleed.xlsx  
8. 2021-08-02 APS outside.xlsx  
9. 2021-08-03 APS bleed.xlsx  
10. 2021-08-03 APS outside.xlsx  
11. 2021-08-04 APS bleed.xlsx  
12. 2021-08-04 APS outside.xlsx  
13. 2021-07-16 CO2.xlsx  
14. 2021-08-02 CO2.xlsx  
15. 2021-08-03 CO2.xlsx  
16. 2021-08-04 CO2.xlsx  
17. 2021-07-16 log.xlsx  
18. 2021-08-02-04 Log.xlsx  
19. 2021-08-04 Piera bleed.xlsx  
20. 2021-08-04 Pierra outside.xlsx  
21. 2021-07-16 SD.xlsx  
22. 2021-08-02 SD.xlsx  
23. 2021-08-03  SD.xlsx  
24. 2021-08-04 SD.xlsx  
25. 2021-07-16 SMPS.xlsx  
26. 2021-08-02 SMPS.xlsx  
27. 2021-08-03 SMPS.xlsx  
28. 2021-08-04 SMPS.xlsx  
29. 2021-07-16 Temp.xlsx  
30. 2021-08-02 TEMP.xlsx  
31. 2021-08-03 TEMP.xlsx  
32. 2021-08-04 TEMP.xlsx  
33. 2021-06-24 APS bleed.xlsx  
34. 2021-06-24 outside.xlsx  
35. 2021-06-25 APS bleed.xlsx  
36. 2021-06-25 APS outside.xlsx
37. 2021-06-24 CO2.xlsx  
38. 2021-06-25 CO2.xlsm  
39. 2021-06-21-25 Log.xlsx  
40. 2021-06-24 Log.xlsx  
41. 2021-06-25 Log.xlsx  
42. 2021-06-24 Piera bleed.csv  
43. 2021-06-24 Piera outside.csv  
44. 2021-06-25 Piera bleed.csv  
45. 2021-06-25 Piera outsdie.csv  
46. 2021-06-24 SD.xlsx  
47. 2021-06-25 SD.xlsx  
48. 2021-03-24 SMPS.xlsx  
49. 2021-03-25 SMPS.xlsx  
50. 2021-06-24 TEMP.xlsx  
51. 2021-06-25 TEMP.xlsx  
52. 2021-03-26 APS.xlsx  
53. 2021-03-26 Log.xlsx  
54. 2021-03-26 SMPS.xlsx  
55. 2021-04-12 APS.xlsx  
56. 2021-04-15 APS.xlsx  
56. 2021-04-16 APS.xlsx  
58. 2021-04-28 APS.xlsx  
59. 2021-05-12 APS.xlsx  
60. 2021-04-12 Log.xlsx  
61. 2021-04-15 Log.xlsx  
62. 2021-04-16 Log.xlsx  
63. 2021-04-28 Log.xlsx  
64. 2021-05-12 Log.xlsx  
65. 2021-04-12 SMPS.xlsx  
66. 2021-04-15 SMPS.xlsx  
67. 2021-04-16 SMPS.xlsx  
68. 2021-04-28 SMPS.xlsx  
69. 2021-05-12 SMPS.xlsx  
70. 2021-06-22 APS bleed.xlsx  
71. 2021-06-22 APS outside.xlsx  
72. 2021-06-23 APS bleed.xlsx  
73. 2021-06-23 APS outside.xlsx  
74. 2021-06-22 CO2.xlsx  
75. 2021-06-23 CO2.xlsx  
76. 2021-06-21 Log.xlsx  
77. 2021-06-21-25 Log.xlsx  
78. 2021-06-22 Log.xlsx   
79. 2021-06-22 Piera bleed.csv  
80. 2021-06-22 Piera outsdie.csv  
81. 2021-06-23 Piera bleed.csv  
82. 2021-06-23 Piera outside.csv  
83. 2021-06-22 SD.xlsx  
84. 2021-06-23 SD.xlsm  
85. 2021-06-22 SMPS.xlsx  
86. 2021-06-23 SMPS.xlsx  
87. 2021-03-23 APS.xlsx  
88. 2021-03-24 APS.xlsx  
89. 2021-03-25 APS.xlsx  
90. 2021-03-26 APS.xlsx  
91. 2021-03-23 Log.xlsx  
92. 2021-03-24 Log.xlsx  
93. 2021-03-25 Log.xlsx  
94. 2021-03-23 SMPS.xlsx  
95. 2021-03-24 SMPS.xlsx  
96. 2021-03-25 SMPS.xlsx  
97. TSI QTRAC-XP Merged Data March.xlsx  
98. 2020-07-24a SMPS.xlsx
99. 2020-07-24c SMPS.xlsx
100. 2020-08-06a SMPS.xlsx  
101. 2020-08-07a SMPS.xlsx
102. 2020-08-13a SMPS.xlsx  
103. 2020-08-14a SMPS.xlsx  
104. 2020-08-31a SMPS.xlsx  
105. 2020-09-18a SMPS.xlsx  

**Additional Preservation Files Created for 87301_DATASET.zip**  
1. README.md: This is the main documentation file for the project in markdown format.  
2. README.pdf: This is the main documentation file for the project in PDF format.  
3. 87301.json: This is the DCAT-US JSON metadata file for the dataset.  


## D. Methodological Information   

**Description of methods used for collection/generation of data:** For the full methodology of each lab report, consult the full publication [https://doi.org/10.21949/1524479](https://doi.org/10.21949/1524479)  

**Instrument or software-specific information needed to interpret the data:** The data and graphs for this dataset package are saved in each Microsoft XLSX file. To access Microsoft Excel files without Microsoft Excel, use Google Sheets or Apache OpenOffice. To view the JSON and Markdown files, use any text viewer, such as Notepad++.   

## E. Update Log  

This README.md file was originally created on 2025-03-04by Peyton Tvrdy ([0000-0002-9720-4725](https://orcid.org/0000-0002-9720-4725)), Data Management and Data Curation Fellow, National Transportation Library <peyton.tvrdy.ctr@dot.gov>  
 
2025-03-04: Original file created  
