﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using iTextSharp.text;
using iTextSharp.text.pdf;
using iTextSharp.text.html.simpleparser;
using System.Text;

    public partial class _Default : System.Web.UI.Page
    {
        protected void Page_Init()
        {



        }
        protected void Page_Load(object sender, EventArgs e)
        {

        }
        protected void Wizard1_FinishButtonClick(object sender, WizardNavigationEventArgs e)
        {
            var document = new Document(PageSize.A4, 50, 50, 25, 25);
            var output = new MemoryStream();
            var writer = PdfWriter.GetInstance(document, output);
            
            var message = HTMLWorker.ParseToList(new StringReader(getResultsString()), null);
            document.Open();
            foreach (var htmlelement in message)
                document.Add(htmlelement as IElement);
            document.Close();

            Response.ContentType = "application/pdf";
            Response.AddHeader("Content-Disposition", string.Format("attachment;filename={0}.pdf", getFileName()));
            Response.BinaryWrite(output.ToArray());

        }
        protected void CheckBox1_CheckedChanged(object sender, EventArgs e)
        {

        }
        protected void Button1_Click(object sender, EventArgs e)
        {

        }
        /*Set Goal Label on each of the goal page
         * stepindex is step in the wizard (0 based index so 2 will be safe travel)
         * */
        protected void setGoalNumberLabel(int stepindex, int goalcount)
        {
            switch (stepindex)
            {

                case 2:
                    stGoal.Text = goalcount.ToString();
                    break;
                case 3:
                    htGoal.Text = goalcount.ToString();
                    break;
                case 4:
                    rtGoal.Text = goalcount.ToString();
                    break;
                case 5:
                    orGoal.Text = goalcount.ToString();
                    break;
                case 6:
                    otGoal.Text = goalcount.ToString();
                    break;
                default:
                    break;
            }


        }
        /*store the values of Safe Travel page checkboxes into the hidden labels and updates the values in the sidebar
         * The parameter passed to it, is the indication of whether this is a second goal or first goal and used to store
         * the values appropriately.
         * This function gets called from the Next Button event.
         * These values will be used in the last step where the application goes through all the MOE and Goal choices
         */
        protected void storeSTMOEValues(int moeno)
        {
            if (moeno == 1)
            {
                hiddenGoal1MOE1Peak.Value = STMOE1A.Checked == true ? "Number of Crashes in the Peak Period" : "";
                hiddenGoal1MOE1All.Value = STMOE1B.Checked == true ? "Number of Crashes All Day" : "";
                hiddenGoal1MOE2Peak.Value = STMOE2A.Checked == true ? "Incident Clearance Time in the Peak Period" : "";
                hiddenGoal1MOE2All.Value = STMOE2B.Checked == true ? "Incident Clearance Time All Day" : "";
                hiddenGoal1MOE1PeakVal.Value = STMOE1A.Checked == true ? STMOE1AText.Text : "";
                hiddenGoal1MOE1AllVal.Value = STMOE1B.Checked == true ? STMOE1BText.Text : "";
                hiddenGoal1MOE2PeakVal.Value = STMOE2A.Checked == true ? STMOE2AText.Text : "";
                hiddenGoal1MOE2AllVal.Value = STMOE2B.Checked == true ? STMOE2BText.Text : "";
                updateStatusBarMOEValues(1);
            }
            if (moeno == 2)
            {
                hiddenGoal2MOE1Peak.Value = STMOE1A.Checked == true ? "Number of Crashes in the Peak Period" : "";
                hiddenGoal2MOE1All.Value = STMOE1B.Checked == true ? "Number of Crashes All Day" : "";
                hiddenGoal2MOE2Peak.Value = STMOE2A.Checked == true ? "Incident Clearance Time in the Peak Period" : "";
                hiddenGoal2MOE2All.Value = STMOE2B.Checked == true ? "Incident Clearance Time All Day" : "";
                hiddenGoal2MOE1PeakVal.Value = STMOE1A.Checked == true ? STMOE1AText.Text : "";
                hiddenGoal2MOE1AllVal.Value = STMOE1B.Checked == true ? STMOE1BText.Text : "";
                hiddenGoal2MOE2PeakVal.Value = STMOE2A.Checked == true ? STMOE2AText.Text : "";
                hiddenGoal2MOE2AllVal.Value = STMOE2B.Checked == true ? STMOE2BText.Text : "";
                updateStatusBarMOEValues(2);
                
            }

        }
        /*Similar to storeSTMOEValues function*/
        protected void storeHTMOEValues(int moeno)
        {
            if (moeno == 1)
            {
                hiddenGoal1MOE1Peak.Value = HTMOE1A.Checked == true ? "Average Speed in the Peak Period" : "";
                hiddenGoal1MOE1All.Value = HTMOE1B.Checked == true ? "Average Speed All Day" : "";
                hiddenGoal1MOE2Peak.Value = HTMOE2A.Checked == true ? "LOS in the Peak Period" : "";
                hiddenGoal1MOE2All.Value = HTMOE2B.Checked == true ? "LOS All Day" : "";
                hiddenGoal1MOE1PeakVal.Value = HTMOE1A.Checked == true ? HTMOE1AText.Text : "";
                hiddenGoal1MOE1AllVal.Value = HTMOE1B.Checked == true ? HTMOE1BText.Text : "";
                hiddenGoal1MOE2PeakVal.Value = HTMOE2A.Checked == true ? HTMOE2AText.Text : "";
                hiddenGoal1MOE2AllVal.Value = HTMOE2B.Checked == true ? HTMOE2BText.Text : "";
                updateStatusBarMOEValues(1);
            }
            if (moeno == 2)
            {
                hiddenGoal2MOE1Peak.Value = HTMOE1A.Checked == true ? "Average Speed in the Peak Period" : "";
                hiddenGoal2MOE1All.Value = HTMOE1B.Checked == true ? "Average Speed All Day" : "";
                hiddenGoal2MOE2Peak.Value = HTMOE2A.Checked == true ? "LOS in the Peak Period" : "";
                hiddenGoal2MOE2All.Value = HTMOE2B.Checked == true ? "LOS All Day" : "";
                hiddenGoal2MOE1PeakVal.Value = HTMOE1A.Checked == true ? HTMOE1AText.Text : "";
                hiddenGoal2MOE1AllVal.Value = HTMOE1B.Checked == true ? HTMOE1BText.Text : "";
                hiddenGoal2MOE2PeakVal.Value = HTMOE2A.Checked == true ? HTMOE2AText.Text : "";
                hiddenGoal2MOE2AllVal.Value = HTMOE2B.Checked == true ? HTMOE2BText.Text : "";
                updateStatusBarMOEValues(2);
            }

        }
        /*Similar to storeSTMOEValues function*/
        protected void storeRTMOEValues(int moeno)
        {
            if (moeno == 1)
            {
                hiddenGoal1MOE1Peak.Value = RTMOE1A.Checked == true ? "95th Percentile Travel Times in the Peak Period" : "";
                hiddenGoal1MOE1All.Value = RTMOE1B.Checked == true ? "95th Percentile Travel Times All Day" : "";
                hiddenGoal1MOE2Peak.Value = RTMOE2A.Checked == true ? "Buffer Index in the Peak Period" : "";
                hiddenGoal1MOE2All.Value = RTMOE2B.Checked == true ? "Buffer Index All Day" : "";
                hiddenGoal1MOE1PeakVal.Value = RTMOE1A.Checked == true ? RTMOE1AText.Text : "";
                hiddenGoal1MOE1AllVal.Value = RTMOE1B.Checked == true ? RTMOE1BText.Text : "";
                hiddenGoal1MOE2PeakVal.Value = RTMOE2A.Checked == true ? RTMOE2AText.Text : "";
                hiddenGoal1MOE2AllVal.Value = RTMOE2B.Checked == true ? RTMOE2BText.Text : "";
                updateStatusBarMOEValues(1);
            }
            if (moeno == 2)
            {
                hiddenGoal2MOE1Peak.Value = RTMOE1A.Checked == true ? "95th Percentile Travel Times in the Peak Period" : "";
                hiddenGoal2MOE1All.Value = RTMOE1B.Checked == true ? "95th Percentile Travel Times All Day" : "";
                hiddenGoal2MOE2Peak.Value = RTMOE2A.Checked == true ? "Buffer Index in the Peak Period" : "";
                hiddenGoal2MOE2All.Value = RTMOE2B.Checked == true ? "Buffer Index All Day" : "";
                hiddenGoal2MOE1PeakVal.Value = RTMOE1A.Checked == true ? RTMOE1AText.Text : "";
                hiddenGoal2MOE1AllVal.Value = RTMOE1B.Checked == true ? RTMOE1BText.Text : "";
                hiddenGoal2MOE2PeakVal.Value = RTMOE2A.Checked == true ? RTMOE2AText.Text : "";
                hiddenGoal2MOE2AllVal.Value = RTMOE2B.Checked == true ? RTMOE2BText.Text : "";
                updateStatusBarMOEValues(2);
            }

        }
        /*Similar to storeSTMOEValues function*/
        protected void storeORMOEValues(int moeno)
        {
            if (moeno == 1)
            {
                hiddenGoal1MOE1Peak.Value = ORMOE1A.Checked == true ? "Revenue in the Peak Period" : "";
                hiddenGoal1MOE1All.Value = ORMOE1B.Checked == true ? "Revenue All Day" : "";
                hiddenGoal1MOE2Peak.Value = ORMOE2A.Checked == true ? "Violation Rate in the Peak Period" : "";
                hiddenGoal1MOE2All.Value = ORMOE2B.Checked == true ? "Violation Rate All Day" : "";
                hiddenGoal1MOE1PeakVal.Value = ORMOE1A.Checked == true ? ORMOE1AText.Text : "";
                hiddenGoal1MOE1AllVal.Value = ORMOE1B.Checked == true ? ORMOE1BText.Text : "";
                hiddenGoal1MOE2PeakVal.Value = ORMOE2A.Checked == true ? ORMOE2AText.Text : "";
                hiddenGoal1MOE2AllVal.Value = ORMOE2B.Checked == true ? ORMOE2BText.Text : "";
                updateStatusBarMOEValues(1);
            }
            if (moeno == 2)
            {
                hiddenGoal2MOE1Peak.Value = ORMOE1A.Checked == true ? "Revenue in the Peak Period" : "";
                hiddenGoal2MOE1All.Value = ORMOE1B.Checked == true ? "Revenue All Day" : "";
                hiddenGoal2MOE2Peak.Value = ORMOE2A.Checked == true ? "Violation Rate in the Peak Period" : "";
                hiddenGoal2MOE2All.Value = ORMOE2B.Checked == true ? "Violation Rate All Day" : "";
                hiddenGoal2MOE1PeakVal.Value = ORMOE1A.Checked == true ? ORMOE1AText.Text : "";
                hiddenGoal2MOE1AllVal.Value = ORMOE1B.Checked == true ? ORMOE1BText.Text : "";
                hiddenGoal2MOE2PeakVal.Value = ORMOE2A.Checked == true ? ORMOE2AText.Text : "";
                hiddenGoal2MOE2AllVal.Value = ORMOE2B.Checked == true ? ORMOE2BText.Text : "";
                updateStatusBarMOEValues(2);
            }

        }
        /*Similar to storeSTMOEValues function*/
        protected void storeOTMOEValues(int moeno)
        {
            if (moeno == 1)
            {
                hiddenGoal1MOE1Peak.Value = OTMOE1A.Checked == true ? "Person Throughput per Hour in the Peak Period" : "";
                hiddenGoal1MOE1All.Value = OTMOE1B.Checked == true ? "Person Throughput per Hour All Day" : "";
                hiddenGoal1MOE2Peak.Value = OTMOE2A.Checked == true ? "Persons in HOVs+Buses per Hour in the Peak Period" : "";
                hiddenGoal1MOE2All.Value = OTMOE2B.Checked == true ? "Persons in HOVs+Buses per Hour All Day" : "";
                hiddenGoal1MOE1PeakVal.Value = OTMOE1A.Checked == true ? OTMOE1AText.Text : "";
                hiddenGoal1MOE1AllVal.Value = OTMOE1B.Checked == true ? OTMOE1BText.Text : "";
                hiddenGoal1MOE2PeakVal.Value = OTMOE2A.Checked == true ? OTMOE2AText.Text : "";
                hiddenGoal1MOE2AllVal.Value = OTMOE2B.Checked == true ? OTMOE2BText.Text : "";
                updateStatusBarMOEValues(1);
            }
            if (moeno == 2)
            {
                hiddenGoal2MOE1Peak.Value = OTMOE1A.Checked == true ? "Person Throughput per Hour in the Peak Period" : "";
                hiddenGoal2MOE1All.Value = OTMOE1B.Checked == true ? "Person Throughput per Hour All Day" : "";
                hiddenGoal2MOE2Peak.Value = OTMOE2A.Checked == true ? "Persons in HOVs+Buses per Hour in the Peak Period" : "";
                hiddenGoal2MOE2All.Value = OTMOE2B.Checked == true ? "Persons in HOVs+Buses per Hour All Day" : "";
                hiddenGoal2MOE1PeakVal.Value = OTMOE1A.Checked == true ? OTMOE1AText.Text : "";
                hiddenGoal2MOE1AllVal.Value = OTMOE1B.Checked == true ? OTMOE1BText.Text : "";
                hiddenGoal2MOE2PeakVal.Value = OTMOE2A.Checked == true ? OTMOE2AText.Text : "";
                hiddenGoal2MOE2AllVal.Value = OTMOE2B.Checked == true ? OTMOE2BText.Text : "";
                updateStatusBarMOEValues(2);
            }

        }
        /*This funciton updates the status in the Sidebar for the selected MOEs. This function is called from each of the goal page
         *functions defined above. It gets called from the "Next Button" event. 
         */
        protected void updateStatusBarMOEValues(int moeCount)
        {
            if (moeCount == 1)
            {
                goal1MOE1Peak.Text = hiddenGoal1MOE1Peak.Value;
                goal1MOE1All.Text = hiddenGoal1MOE1All.Value;
                goal1MOE2Peak.Text = hiddenGoal1MOE2Peak.Value;
                goal1MOE2All.Text = hiddenGoal1MOE2All.Value;
            }
            if (moeCount == 2)
            {
                goal2MOE1Peak.Text = hiddenGoal2MOE1Peak.Value;
                goal2MOE1All.Text = hiddenGoal2MOE1All.Value;
                goal2MOE2Peak.Text = hiddenGoal2MOE2Peak.Value;
                goal2MOE2All.Text = hiddenGoal2MOE2All.Value;
            }

        }
        protected void storeMOEValues(int currentstep, int moenumber)
        {
            switch (currentstep)
            {
                case 2:
                    storeSTMOEValues(moenumber);
                    break;
                case 3:
                    storeHTMOEValues(moenumber);
                    break;
                case 4:
                    storeRTMOEValues(moenumber);
                    break;
                case 5:
                    storeORMOEValues(moenumber);
                    break;
                case 6:
                    storeOTMOEValues(moenumber);
                    break;
            }
        }
        /*The next button click event is triggered when next button on any screen is clicked. Which is whey you have to use the activestepindex
         * of the wizard to figure out where on the wizard page are you. The activestepindex is changed after this code is processed so you can use
         * this to move wizard to another page. 
         */
        protected void Wizard1_NextButtonClick(object sender, WizardNavigationEventArgs e)
        {
            /*Checks to see if the next button clicked is from any of the goals page
             *hiddenGoal1 & hiddenGoal2 stores the activestepindex of the selected goal on second screen
             *If the current step of the wizard matches the stepindex stored in the hiddenGoal1 that means this is the
             *first goal selected in the second screen.
             *It calls the storeMOEValues function with two parameters, first is the active step index and second the goal number (first or second)
             */

            
            if (Wizard1.ActiveStepIndex >= 2 && Wizard1.ActiveStepIndex <= 6)
            {

                int goal1StepIndex = int.Parse(hiddenGoal1.Value);
                int goal2StepIndex = int.Parse(hiddenGoal2.Value);

                if (Wizard1.ActiveStepIndex == goal1StepIndex)
                {
                    storeMOEValues(goal1StepIndex, 1);
                }
                else if (Wizard1.ActiveStepIndex == goal2StepIndex)
                {
                    storeMOEValues(goal2StepIndex, 2);
                }

            }

            /*This gets called when the wizard is on second screen to the last goal screen,
             * uses goalcount value to determine the next steps.
             */
            if (Wizard1.ActiveStepIndex >= 1 && Wizard1.ActiveStepIndex <= 6)
            {
                int tempGoalCount = int.Parse(hiddenGoalCount.Value);
                int tempGoalStep1 = int.Parse(hiddenGoal1.Value);
                int tempGoalStep2 = int.Parse(hiddenGoal2.Value);
                if (tempGoalCount == 1)
                {
                    if (Wizard1.ActiveStepIndex == tempGoalStep1)
                    {
                        Wizard1.ActiveStepIndex = 7;
                    }
                    else
                    {

                        Wizard1.ActiveStepIndex = tempGoalStep1;
                        setGoalNumberLabel(tempGoalStep1, 1);
                    }
                }
                else
                {
                    if (Wizard1.ActiveStepIndex == tempGoalStep1)
                    {
                        Wizard1.ActiveStepIndex = tempGoalStep2;
                        setGoalNumberLabel(tempGoalStep2, 2);
                    }
                    else if (Wizard1.ActiveStepIndex == 1)
                    {
                        Wizard1.ActiveStepIndex = tempGoalStep1;
                        setGoalNumberLabel(tempGoalStep1, 1);

                    }
                    else if (Wizard1.ActiveStepIndex == tempGoalStep2)
                    {
                        Wizard1.ActiveStepIndex = 7;


                    }

                }
            }
            /*Gets called when user clicks next button on the rank user groups page*/
            else if (Wizard1.ActiveStep.ID == "rankGroupsStep")
            {
                if (Page.IsValid) {
                    List<string>[] free = new List<string>[2];
                    List<string>[] toll = new List<string>[2];
                    List<string>[] na = new List<string>[2];
                    //making a list of priorities to be removed 
                    List<string> remove = new List<string>{ "-1", "0" };
                    /*The removeMultiplePrioritiesFromList function removes the priorities from a two-dimensional List<string>
                     * array and returns the two dimensional LIst<string> array. We are calling it on the returnGroupResults 
                     * function because we only care about the groups where user has specified a rank(priority). The "-1" value
                     * is where user did not indicate any rank and "0" means that veh group is permanently not allowed on 
                     * the facility.
                     */
                    free = removeMultiplePrioritiesFromList(returnFreeGroupResults(),remove);
                    toll = removeMultiplePrioritiesFromList(returnTolledGroupResults(),remove);
                    na = removeMultiplePrioritiesFromList(returnNotAllowedGroupResults(),remove);

                    //store the user submitted ranks to keep track of the original entries
                    origFreeID.Value = String.Join(",", free[0]);
                    origFreeRank.Value = String.Join(",", free[1]);
                    origTollID.Value = String.Join(",", toll[0]);
                    origTollRank.Value = String.Join(",", toll[1]);
                    origNAID.Value = String.Join(",", na[0]);
                    origNARank.Value = String.Join(",", na[1]);

                    /*make a copy of the original veh group submission, the code will from now on work from this copy
                     * and the original entries will only be used in the result output to compare what the flowchart
                     * steps did to the original list */
                    newFreeID.Value = origFreeID.Value;
                    newFreeRank.Value = origFreeRank.Value;
                    newTollID.Value = origTollID.Value;
                    newTollRank.Value = origTollRank.Value;
                    newNAID.Value = origNAID.Value;
                    newNARank.Value = origNARank.Value;
           
                      
                    
                
                }
            }
            else if (Wizard1.ActiveStepIndex >= Wizard1.WizardSteps.IndexOf(flowStep1) && Wizard1.ActiveStepIndex <= Wizard1.WizardSteps.IndexOf(flowStep8))
            {
                if (Wizard1.ActiveStep.ID == "flowStep1")
                {
                    System.Diagnostics.Debug.WriteLine("Original Value for FlowStep1 is "+flowStep1Groups.Value);
                    resetFlowStepGroups("flowStep1");
                    flowStep2Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    flowStep1Values.Value = getFlowStepInput("flowStep1");
                    flowStep1Fixes.Value = findSelectedFix("flowStep1");
                }
                if (Wizard1.ActiveStep.ID == "flowStep2")
                {
                    System.Diagnostics.Debug.WriteLine("Original Value for FlowStep2 is " + flowStep2Groups.Value);
                    resetFlowStepGroups("flowStep2");
                    flowStep3Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    flowStep2Values.Value = getFlowStepInput("flowStep2");
                    flowStep2Fixes.Value = findSelectedFix("flowStep2");

                }
                if (Wizard1.ActiveStep.ID == "flowStep3")
                {
                    System.Diagnostics.Debug.WriteLine("Original Value for FlowStep3 is " + flowStep3Groups.Value);
                    resetFlowStepGroups("flowStep3");
                    flowStep4Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    flowStep3Values.Value = getFlowStepInput("flowStep3");
                    flowStep3Fixes.Value = findSelectedFix("flowStep3");
                }
                if (Wizard1.ActiveStep.ID == "flowStep4")
                {
                    System.Diagnostics.Debug.WriteLine("Original Value for FlowStep4 is " + flowStep4Groups.Value);
                    resetFlowStepGroups("flowStep4");
                    flowStep5Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    flowStep4Values.Value = getFlowStepInput("flowStep4");
                    flowStep4Fixes.Value = findSelectedFix("flowStep4");
                }
                if (Wizard1.ActiveStep.ID == "flowStep5")
                {
                    System.Diagnostics.Debug.WriteLine("Original Value for FlowStep5 is " + flowStep5Groups.Value);
                    resetFlowStepGroups("flowStep5");
                    flowStep6Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    flowStep5Values.Value = getFlowStepInput("flowStep5");
                    flowStep5Fixes.Value = findSelectedFix("flowStep5");
                }
                if (Wizard1.ActiveStep.ID == "flowStep6")
                {
                    System.Diagnostics.Debug.WriteLine("Original Value for FlowStep6 is " + flowStep6Groups.Value);
                    resetFlowStepGroups("flowStep6");
                    flowStep7Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    flowStep6Values.Value = getFlowStepInput("flowStep6");
                    flowStep6Fixes.Value = findSelectedFix("flowStep6");
                }
                if (Wizard1.ActiveStep.ID == "flowStep7")
                {
                    System.Diagnostics.Debug.WriteLine("Original Value for FlowStep7 is " + flowStep7Groups.Value);
                    resetFlowStepGroups("flowStep7");
                    flowStep8Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    flowStep7Values.Value = getFlowStepInput("flowStep7");
                    flowStep7Fixes.Value = findSelectedFix("flowStep7");
                }
                if (Wizard1.ActiveStep.ID == "flowStep8")
                {
                    System.Diagnostics.Debug.WriteLine("Original Value for FlowStep8 is " + flowStep8Groups.Value);
                    flowStep8Values.Value = getFlowStepInput("flowStep8");
                    flowStep8Fixes.Value = findSelectedFix("flowStep8");
                }
                storeFlowStepValues();

            }

            //When the next button on the operational fixes page is clicked
            else if (Wizard1.ActiveStep.ID == "opFixesStep")
            {
                
                //System.Diagnostics.Debug.WriteLine("I clicked the next button on fixes");
                opFix1.Value = opfixpricing.Checked == true ? "Pricing" : "";
                opFix2.Value = opfixusergroups.Checked == true ? "Allowed User Groups" : "";
                opFix3.Value = opfixenforcement.Checked == true ? "Increase Enforcement" : "";
                opFix4.Value = opfixshoulderhours.Checked == true ? "Activate Shoulder Hours" : "";
                opFix5.Value = opfixincidentremove.Checked == true ? "Rapid Incident Removal Program" : "";
                opFix6.Value = opfixtrafficman.Checked == true ? "Active Traffic Management" : "";
                opFix7.Value = opfixrampmetering.Checked == true ? "Ramp Metering" : "";
                opFix8.Value = opfiximprovedesign.Checked == true ? "Improve design to increase speeds or reduce crash rates" : "";
                opFix9.Value = opfixpublicity.Checked == true ? "Publicity about conditions or toll rates" : "";
                opFix10.Value = opfixothers1.Text != "" ? opfixothers1.Text : "";
                opFix11.Value = opfixothers2.Text != "" ? opfixothers2.Text : "";

                //Previous step from the flow steps so restore the new values to orig
                newFreeID.Value = origFreeID.Value;
                newFreeRank.Value = origFreeRank.Value;
                newTollID.Value = origTollID.Value;
                newTollRank.Value = origTollRank.Value;
                newNAID.Value = origNAID.Value;
                newNARank.Value = origNARank.Value;
                /* stores values of checked op fixes in order in the hiddenfield opfixesinorder
                 * This will start with UGroups first since we will process it first
                 * The hiddenfield opfixesinorder will be used in the flow step processings
                 */
                storeValuesInOrderOpFixes();
                flowStep1Groups.Value = getStringFromHiddenFieldVehGroups("new");
                //clear all label controls and enable them for all flow steps
                clearAllStepControls();
                enableAllStepControls();
                resetHFFlowStepValues();
                resetHFFlowStepFixes();
                
            }



        }
        protected void Wizard1_PreviousButtonClick1(object sender, WizardNavigationEventArgs e)
        {

        }
        protected void facility_SelectedIndexChanged(object sender, EventArgs e)
        {
            updateFacilityLabel();
        }
        /* Code break up so that when you read the input file you can directly call this function
         * to update the sidebar .. this way you don't have to rely on only the selectedindexchanged
         * event
         */
        protected void updateFacilityLabel() {
            if (facility.SelectedIndex == 0)
            {
                facilityLabel.Visible = true;
                selectedfacility.Text = "HOV";
            }
            if (facility.SelectedIndex == 1)
            {
                facilityLabel.Visible = true;
                selectedfacility.Text = "HOT";
            }
            if (facility.SelectedIndex == 2)
            {
                facilityLabel.Visible = true;
                selectedfacility.Text = "Toll";
            }
        
        }
        protected void postgoalstatus(string s1, int x)
        {
            int tempGoalCount = int.Parse(hiddenGoalCount.Value);
            int tempGoalStep1 = int.Parse(hiddenGoal1.Value);
            int tempGoalStep2 = int.Parse(hiddenGoal2.Value);

            if (tempGoalCount == 1)
            {
                Goal1Label.Visible = true;
                goalName1.Text = s1;
                hiddenGoal1.Value = x.ToString();
                Goal2Label.Visible = false;
                goalName2.Text = "";
                hiddenGoal2.Value = "-1";
            }
            else if (tempGoalCount == 2)
            {
                Goal2Label.Visible = true;
                goalName2.Text = s1;
                hiddenGoal2.Value = x.ToString();

            }
        }
        protected void removegoalstatus(string s2, int x)
        {

            if (goalName1.Text == s2)
            {
                if (goalName2.Text != "")
                {
                    Goal1Label.Visible = true;
                    goalName1.Text = goalName2.Text;
                    goalName2.Text = "";
                    Goal2Label.Visible = false;
                    //Global.GoalArray[0] = Global.GoalArray[1];
                    hiddenGoal1.Value = hiddenGoal2.Value;
                    hiddenGoal2.Value = "-1";
                }
                else
                {
                    Goal1Label.Visible = false;
                    goalName1.Text = "";
                    //Global.GoalArray[0] = 0;
                    hiddenGoal1.Value = "-1";
                }
            }
            else if (goalName2.Text == s2)
            {
                Goal2Label.Visible = false;
                goalName2.Text = "";
                //Global.GoalArray[1] = 0;
                hiddenGoal2.Value = "-1";
            }
        }
        protected void st_CheckedChanged(object sender, EventArgs e)
        {

            STCheckedUpdate();
        }
        /* Separate out the code which runs when Safe Travel checkbox is checked.. when the input file is
         * read you can't simulate a click event easily instead you can just call this function
         */
        protected void STCheckedUpdate() {
            if (st.Checked == true)
            {
                updategoalvar();
                //checklabel.Text = Global.GoalVar.ToString();
                //checklabel.Text = Global.GoalVar.ToString();
                postgoalstatus("Safe Travel", 2);

            }
            if (st.Checked == false)
            {
                updategoalvar();
                removegoalstatus("Safe Travel", 2);
            }
                
        }
        protected void ht_CheckedChanged(object sender, EventArgs e)
        {
            HTCheckedUpdate();
            
        }
        /* Separate out the code which runs when High-speed Travel checkbox is checked.. when the input file is
         * read you can't simulate a click event easily instead you can just call this function
         */
        protected void HTCheckedUpdate()
        {
            if (ht.Checked == true)
            {
                updategoalvar();
                postgoalstatus("High-speed Travel", 3);

            }
            if (ht.Checked == false)
            {
                updategoalvar();
                removegoalstatus("High-speed Travel", 3);
            }
        }
        protected void rt_CheckedChanged(object sender, EventArgs e)
        {
            RTCheckedUpdate();
            
        }
        /* Separate out the code which runs when Reliable Travel checkbox is checked.. when the input file is
         * read you can't simulate a click event easily instead you can just call this function
         */
        protected void RTCheckedUpdate()
        {
            if (rt.Checked == true)
            {
                updategoalvar();
                postgoalstatus("Reliable Travel", 4);
            }
            if (rt.Checked == false)
            {
                updategoalvar();
                removegoalstatus("Reliable Travel", 4);
            }
        }
        protected int countCheckedBoxes()
        {
            int count = 0;
            if (st.Checked == true)
            {
                count++;
            }
            if (ht.Checked == true)
            {
                count++;
            }
            if (rt.Checked == true)
            {
                count++;
            }
            if (or.Checked == true)
            {
                count++;

            }
            if (ot.Checked == true)
            {
                count++;
            }
            return count;

        }
        protected void or_CheckedChanged(object sender, EventArgs e)
        {
            ORCheckedUpdate();
            
        }
        /* Separate out the code which runs when Optimize Revenue checkbox is checked.. when the input file is
         * read you can't simulate a click event easily instead you can just call this function
         */
        protected void ORCheckedUpdate()
        {
            if (or.Checked == true)
            {
                updategoalvar();

                postgoalstatus("Optimize Revenue", 5);

            }
            if (or.Checked == false)
            {
                updategoalvar();
                removegoalstatus("Optimize Revenue", 5);
            }
        }
        protected void ot_CheckedChanged(object sender, EventArgs e)
        {
            OTCheckedUpdate();
           
        }
        /* Separate out the code which runs when Optimize Throughput checkbox is checked.. when the input file is
         * read you can't simulate a click event easily instead you can just call this function
         */
        protected void OTCheckedUpdate()
        {
            if (ot.Checked == true)
            {
                updategoalvar();
                postgoalstatus("Optimize Throughput", 6);

            }
            if (ot.Checked == false)
            {
                updategoalvar();
                removegoalstatus("Optimize Throughput", 6);
            }
            
        }
        /*this function gets called anytime the activestepindex of the wizard is changed 
         * so whenever the wizard moves from one step to another. This gets called before the page is
         * rendered.
        */
        protected void Wizard1_ActiveStepChanged(object sender, EventArgs e)
        {
            //hideAndClearLabelControl(Wizard1.ActiveStep.ID, "name");
            //checklabel.Text = Wizard1.ActiveStepIndex.ToString();
            if (Wizard1.ActiveStep.ID == "chooseGoalsStep")
            {
                goal1MOE1Peak.Text = "";
                goal1MOE1All.Text = "";
                goal1MOE2Peak.Text = "";
                goal1MOE2All.Text = "";
                goal2MOE1Peak.Text = "";
                goal2MOE1All.Text = "";
                goal2MOE2Peak.Text = "";
                goal2MOE2All.Text = "";
                int check = countCheckedBoxes();
                if (check > 0)
                {
                    //Global.GoalVar = check;
                    hiddenGoalCount.Value = check.ToString();
                }
                else
                {
                    //Global.GoalArray[0] = 0;
                    //Global.GoalArray[1] = 0;
                    //Global.GoalVar = 0;
                    hiddenGoal1.Value = "-1";
                    hiddenGoal2.Value = "-1";
                    hiddenGoalCount.Value = "0";
                }
                //Global.GoalVar = 0;
                goalLabel.Visible = true;
            }


            if (Wizard1.ActiveStep.ID == "results")
            {
                /*Label1.Text = flowStep1Hidden.Value;
                Label2.Text = flowStep2Hidden.Value;
                Label3.Text = flowStep3Hidden.Value;
                Label4.Text = flowStep4Hidden.Value;
                Label5.Text = flowStep5Hidden.Value;
                Label6.Text = flowStep6Hidden.Value;
                Label7.Text = flowStep7Hidden.Value;
                Label8.Text = flowStep8Hidden.Value;
                Label9.Text = hiddenGoal2MOE2All.Value;*/
                Label10.Text = "";
                Label10.Text = getResultsString();
            }
            if (Wizard1.ActiveStep.ID == "flowStep1")
            {
                
                resetAllTempGroupHiddenFields();
                //vehGroupsProcessed.Value = "";
                facilityType.Value = getSelectedFacility();
                newfacilityType.Value = getSelectedFacility();
                //hideOpFixQuestions();
                //flowStep1BeginRadio.ClearSelection();
                if (hiddenGoal1MOE1Peak.Value == "")
                {
                    //Wizard1.ActiveStep.ID = "flowStep2";
                    Wizard1.MoveTo(flowStep2);
                }
                else
                {
                    clearCurrentStepControls(Wizard1.ActiveStep.ID);
                    enableCurrentStepControls(Wizard1.ActiveStep.ID);
                    //restore from the orig list of vehicles for this step
                    if (flowStep1Groups.Value != "")
                        restoreFromHiddenFieldGroups("new", flowStep1Groups.Value);
                    else
                        flowStep1Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    System.Diagnostics.Debug.WriteLine("Value of flowStep1Groups is " + flowStep1Groups.Value);
                    flowStep1GoalName.Text = "Goal : " + returnGoalNames(int.Parse(hiddenGoal1.Value));
                    flowStep1MOE.Text = "MOE : " + hiddenGoal1MOE1Peak.Value;
                    flowStep1Begin.Text = "Is the " + hiddenGoal1MOE1Peak.Value + " (MOE VALUE : " + hiddenGoal1MOE1PeakVal.Value + ")" + " satisfactory ? ";
                }

            }
            else if (Wizard1.ActiveStep.ID == "flowStep2")
            {
                
                resetAllTempGroupHiddenFields();
                //vehGroupsProcessed.Value = "";
                if (hiddenGoal1MOE2Peak.Value == "")
                {
                    Wizard1.MoveTo(flowStep3);
                }
                else
                {
                    clearCurrentStepControls(Wizard1.ActiveStep.ID);
                    enableCurrentStepControls(Wizard1.ActiveStep.ID);
                    //restore from the orig list of vehicles for this step
                    if (flowStep2Groups.Value != "")
                        restoreFromHiddenFieldGroups("new", flowStep2Groups.Value);
                    else
                        flowStep2Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    System.Diagnostics.Debug.WriteLine("Value of flowStep2Groups is " + flowStep2Groups.Value);
                    flowStep2GoalName.Text = "Goal : " + returnGoalNames(int.Parse(hiddenGoal1.Value));
                    flowStep2MOE.Text = "MOE : " + hiddenGoal1MOE2Peak.Value;
                    flowStep2Begin.Text = "Is the " + hiddenGoal1MOE2Peak.Value + " (MOE VALUE : " + hiddenGoal1MOE2PeakVal.Value + ")" + " satisfactory ?";
                }

            }
            else if (Wizard1.ActiveStep.ID == "flowStep3")
            {
                
                resetAllTempGroupHiddenFields();
                //vehGroupsProcessed.Value = "";
                if (hiddenGoal1MOE1All.Value == "")
                {

                    Wizard1.MoveTo(flowStep4);
                }
                else
                {
                    clearCurrentStepControls(Wizard1.ActiveStep.ID);
                    enableCurrentStepControls(Wizard1.ActiveStep.ID);
                    //restore from the orig list of vehicles for this step
                    if (flowStep3Groups.Value != "")
                        restoreFromHiddenFieldGroups("new", flowStep3Groups.Value);
                    else
                        flowStep3Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    System.Diagnostics.Debug.WriteLine("Value of flowStep3Groups is " + flowStep3Groups.Value);
                    flowStep3GoalName.Text = "Goal : " + returnGoalNames(int.Parse(hiddenGoal1.Value));
                    flowStep3MOE.Text = "MOE : " + hiddenGoal1MOE1All.Value;
                    flowStep3Begin.Text = "Is the " + hiddenGoal1MOE1All.Value + " (MOE VALUE : " + hiddenGoal1MOE1AllVal.Value + ")" + " satisfactory ?";
                }
            }
            else if (Wizard1.ActiveStep.ID == "flowStep4")
            {
                
                resetAllTempGroupHiddenFields();
                //vehGroupsProcessed.Value = "";
                if (hiddenGoal1MOE2All.Value == "")
                {
                    Wizard1.MoveTo(flowStep5);
                }
                else
                {
                    clearCurrentStepControls(Wizard1.ActiveStep.ID);
                    enableCurrentStepControls(Wizard1.ActiveStep.ID);
                    //restore from the orig list of vehicles for this step
                    if (flowStep4Groups.Value != "")
                        restoreFromHiddenFieldGroups("new", flowStep4Groups.Value);
                    else
                        flowStep4Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    System.Diagnostics.Debug.WriteLine("Value of flowStep4Groups is " + flowStep4Groups.Value);
                    flowStep4GoalName.Text = "Goal : " + returnGoalNames(int.Parse(hiddenGoal1.Value));
                    flowStep4MOE.Text = "MOE : " + hiddenGoal1MOE2All.Value;
                    flowStep4Begin.Text = "Is the " + hiddenGoal1MOE2All.Value + " (MOE VALUE : " + hiddenGoal1MOE2AllVal.Value + ")" + " satisfactory ?";
                }
            }
            else if (Wizard1.ActiveStep.ID == "flowStep5")
            {
                
                resetAllTempGroupHiddenFields();
                //vehGroupsProcessed.Value = "";
                if (hiddenGoal2MOE1Peak.Value == "")
                {
                    Wizard1.MoveTo(flowStep6);
                }
                else
                {
                    clearCurrentStepControls(Wizard1.ActiveStep.ID);
                    enableCurrentStepControls(Wizard1.ActiveStep.ID);
                    //restore from the orig list of vehicles for this step
                    if (flowStep5Groups.Value != "")
                        restoreFromHiddenFieldGroups("new", flowStep5Groups.Value);
                    else
                        flowStep5Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    System.Diagnostics.Debug.WriteLine("Value of flowStep5Groups is " + flowStep5Groups.Value);
                    flowStep5GoalName.Text = "Goal : " + returnGoalNames(int.Parse(hiddenGoal2.Value));
                    flowStep5MOE.Text = "MOE : " + hiddenGoal2MOE1Peak.Value;
                    flowStep5Begin.Text = "Is the " + hiddenGoal2MOE1Peak.Value + " (MOE VALUE : " + hiddenGoal2MOE1PeakVal.Value + ")" + " satisfactory ?";
                }
            }
            else if (Wizard1.ActiveStep.ID == "flowStep6")
            {
                
                resetAllTempGroupHiddenFields();
                //vehGroupsProcessed.Value = "";
                if (hiddenGoal2MOE2Peak.Value == "")
                {
                    Wizard1.MoveTo(flowStep7);
                }
                else
                {
                    clearCurrentStepControls(Wizard1.ActiveStep.ID);
                    enableCurrentStepControls(Wizard1.ActiveStep.ID);
                    //restore from the orig list of vehicles for this step
                    if (flowStep6Groups.Value != "")
                        restoreFromHiddenFieldGroups("new", flowStep6Groups.Value);
                    else
                        flowStep6Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    System.Diagnostics.Debug.WriteLine("Value of flowStep6Groups is " + flowStep6Groups.Value);
                    flowStep6GoalName.Text = "Goal : " + returnGoalNames(int.Parse(hiddenGoal2.Value));
                    flowStep6MOE.Text = "MOE : " + hiddenGoal2MOE2Peak.Value;
                    flowStep6Begin.Text = "Is the " + hiddenGoal2MOE2Peak.Value + " (MOE VALUE : " + hiddenGoal2MOE2PeakVal.Value + ")" + " satisfactory ?";
                }
            }
            else if (Wizard1.ActiveStep.ID == "flowStep7")
            {
                
                resetAllTempGroupHiddenFields();
                //vehGroupsProcessed.Value = "";
                if (hiddenGoal2MOE1All.Value == "")
                {
                    Wizard1.MoveTo(flowStep8);
                }
                else
                {
                    clearCurrentStepControls(Wizard1.ActiveStep.ID);
                    enableCurrentStepControls(Wizard1.ActiveStep.ID);
                    //restore from the orig list of vehicles for this step
                    if (flowStep7Groups.Value != "")
                        restoreFromHiddenFieldGroups("new", flowStep7Groups.Value);
                    else
                        flowStep7Groups.Value = getStringFromHiddenFieldVehGroups("new");
                    System.Diagnostics.Debug.WriteLine("Value of flowStep7Groups is " + flowStep7Groups.Value);
                    flowStep7GoalName.Text = "Goal : " + returnGoalNames(int.Parse(hiddenGoal2.Value));
                    flowStep7MOE.Text = "MOE : " + hiddenGoal2MOE1All.Value;
                    flowStep7Begin.Text = "Is the " + hiddenGoal2MOE1All.Value + " (MOE VALUE : " + hiddenGoal2MOE1AllVal.Value + ")" + " satisfactory ?";
                }
            }
            else if (Wizard1.ActiveStep.ID == "flowStep8")
            {
                
                resetAllTempGroupHiddenFields();
                //vehGroupsProcessed.Value = "";
                if (hiddenGoal2MOE2All.Value == "")
                {
                    Wizard1.MoveTo(results);
                }
                else
                {
                    clearCurrentStepControls(Wizard1.ActiveStep.ID);
                    enableCurrentStepControls(Wizard1.ActiveStep.ID);
                    //restore from the orig list of vehicles for this step
                    if (flowStep8Groups.Value != "")
                        restoreFromHiddenFieldGroups("new", flowStep8Groups.Value);
                    else
                        flowStep8Groups.Value = getStringFromHiddenFieldVehGroups("new");
                        
                    System.Diagnostics.Debug.WriteLine("Value of flowStep8Groups is " + flowStep8Groups.Value);
                    flowStep8GoalName.Text = "Goal : " + returnGoalNames(int.Parse(hiddenGoal2.Value));
                    flowStep8MOE.Text = "MOE : " + hiddenGoal2MOE2All.Value;
                    flowStep8Begin.Text = "Is the " + hiddenGoal2MOE2All.Value + " (MOE VALUE : " + hiddenGoal2MOE2AllVal.Value + ")" + " satisfactory ?";
                }
            }
        }
        protected void Wizard1_Load(object sender, EventArgs e)
        {

        }
        /*Updates the total number of goals checked. Gets called each time the checkbox is checked or unchecked
         * and keeps the goal count updated.
         */
        protected void updategoalvar()
        {
            int update = countCheckedBoxes();
            //Global.GoalVar = update;
            hiddenGoalCount.Value = update.ToString();
        }
        /*Custom validate function to check if at least one goal is checked*/
        protected void mingoalscount_ServerValidate(object source, ServerValidateEventArgs args)
        {
            /*if (Global.GoalVar == 0) {
                args.IsValid = false;
            }*/

            if (hiddenGoalCount.Value == "0")
            {
                args.IsValid = false;
            }
        }
        /*custom validate function to check the maximum number of goals checked. The jquery code does not allow
         * selection of more than two goals but this will provide the server side validation in case the scripts are 
         * disabled
         * 
         */
        protected void maxgoalscount_ServerValidate(object source, ServerValidateEventArgs args)
        {
            /*if (Global.GoalVar > 2) {
                args.IsValid = false;
            }*/
            if (int.Parse(hiddenGoalCount.Value) > 2)
            {
                args.IsValid = false;
            }
        }
        protected void STMOE1A_CheckedChanged(object sender, EventArgs e)
        {

        }
        /* Toggles visibility of the textbox next to MOE for each goals page
         * Uses the sender argument to get id of the checked checkbox and a "Text" string is appended
         * to it to find a related checkbox on that page and toggle the visibility
        */
        protected void moeCheckbox_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox check = (CheckBox)sender;

            if (check.Checked == true)
            {
                TextBox text = (TextBox)check.Parent.FindControl(check.ID + "Text");
                text.Visible = true;
                //System.Diagnostics.Debug.WriteLine(Wizard1.ActiveStepIndex);

            }
            if (check.Checked == false)
            {
                TextBox text = (TextBox)check.Parent.FindControl(check.ID + "Text");
                text.Visible = false;
            }

        }
        /*Custom validator for all goals page. 
         * The first control it encounters is the customvalidator tag which will give a unique id for each of the goals page
         * which is stored in the temp variable. If the control type is a checkbox then test it if it is checked and increase
         * the count and check if the checkbox next to it is not empty. The textboxes are named in a way where if you append "Text" to 
         * the checkbox ID it will give you the ID of the textbox. This is what I used to find a checkbox on the page.
         */
        protected void goalsPageValidator_ServerValidate(object source, ServerValidateEventArgs args)
        {
            CustomValidator temp = null; ;
            int count = 0;
            foreach (Control c in Wizard1.ActiveStep.Controls)
            {

                if (c.GetType() == typeof(CustomValidator))
                {
                    temp = (CustomValidator)c;
                }
                if (c.GetType() == typeof(CheckBox))
                {

                    //System.Diagnostics.Debug.WriteLine("checkbox" + c.ID);
                    CheckBox test = (CheckBox)c;
                    if (test.Checked == true)
                    {
                        count++;
                        TextBox hello = (TextBox)test.Parent.FindControl(test.ID + "Text");
                        if (hello.Text == "")
                        {
                            temp.ErrorMessage = "Please enter the value for each selected MOE";
                            args.IsValid = false;
                        }
                    }
                }


            }
            if (count == 0)
            {
                temp.ErrorMessage = "Please select at least one MOE for each goal";
                args.IsValid = false;
            }

        }
        /*Count the number of rank dropdownlist values which are empty. This will be used to check if at least
         * one box has the priority entered.
         */
        protected int countpriorityboxes()
        {
            int count = 0;
            foreach (Control c in Wizard1.ActiveStep.Controls)
            {
                if (c.GetType() == typeof(DropDownList))
                {

                    string test = c.ID.ToString();
                    if (test.EndsWith("priority"))
                    {
                        DropDownList tempddlist = (DropDownList)c;
                        if (tempddlist.SelectedValue == "") { count++; }
                    }
                }

            }
            return count;
        }
        /*The HOV facility shouldn't have any vehicles currently tolled and at least one group which is travelling free
         * The HOT facility should have at least one tolled group and one free group
         * The TOLL facility shouldn't have any free groups.
         */
        protected int checkGroupStatusforFacility()
        {
            int countFreeGroups = 0;
            int countTollGroups = 0;
            foreach (Control c in Wizard1.ActiveStep.Controls)
            {
                if (c.GetType() == typeof(DropDownList))
                {
                    string test = c.ID.ToString();
                    if (test.EndsWith("Status"))
                    {
                        DropDownList tempddlist = (DropDownList)c;
                        if (tempddlist.SelectedValue == "1")
                        {
                            countFreeGroups++;

                        }
                        else if (tempddlist.SelectedValue == "0")
                        {
                            countTollGroups++;
                        }
                    }
                }

            }
            if (facility.SelectedValue == "0")
            {
                if (countTollGroups > 0)
                {
                    return -1;
                }
                else if (countFreeGroups == 0)
                {
                    return -2;
                }
                else { return 10; }

            }
            else if (facility.SelectedValue == "1")
            {
                if (countFreeGroups == 0)
                {
                    return -3;
                }
                else if (countTollGroups == 0)
                {
                    return -4;
                }
                else
                {
                    return 10;
                }
            }
            else if (facility.SelectedValue == "2")
            {
                if (countFreeGroups > 0)
                {
                    return -5;
                }
                else if (countTollGroups == 0)
                {
                    return -6;
                }
                else
                {
                    return 10;
                }
            }
            else
            {

                return 0;
            }

        }
        /*Second function for custom validator on usergroups page. This one checks if at least one user group which is either
         * tolled or free has a rank value.     
         */
        protected int checkforRelatedRank()
        {
            int count = 0;
            foreach (Control c in Wizard1.ActiveStep.Controls)
            {
                if (c.GetType() == typeof(DropDownList))
                {
                    string test = c.ID.ToString();
                    if (test.EndsWith("Status"))
                    {
                        int testLength = test.Trim().Length - 6;
                        string rankddlString = test.Substring(0, testLength) + "priority";

                        DropDownList tempddlist = (DropDownList)c;
                        DropDownList rankddl = (DropDownList)Wizard1.ActiveStep.FindControl(rankddlString);
                        if (tempddlist.SelectedValue == "1" || tempddlist.SelectedValue == "0")
                        {
                            if (rankddl.SelectedValue != "-1")
                            {
                                count++;
                            }


                        }

                    }
                }

            }
            if (count > 0)
            {
                return 0;
            }
            else
            {
                return -1;
            }

        }
        /* custom validator for usergroups page.
         */
        protected void usergroupsValidator_ServerValidate(object source, ServerValidateEventArgs args)
        {
            int temp = countpriorityboxes();
            int tempRank = checkforRelatedRank();
            int countGroupValidation = checkGroupStatusforFacility();
            CustomValidator tempCV = (CustomValidator)Wizard1.ActiveStep.FindControl("usergroupsValidator");

            if (countGroupValidation == -1)
            {
                tempCV.ErrorMessage = "You indicate at least one tolled user group. Is this facility a HOT?";
                args.IsValid = false;
            }
            else if (countGroupValidation == 0 && facility.SelectedValue == "0")
            {
                tempCV.ErrorMessage = "You need to select at least one currently free user group.";
                args.IsValid = false;
            }
            else if (countGroupValidation == -2 || countGroupValidation == -1 || countGroupValidation == -3)
            {
                tempCV.ErrorMessage = "You don't indicate any toll-free user groups. Is this facility a toll lane?";
                args.IsValid = false;
            }
            else if (countGroupValidation == -4)
            {
                tempCV.ErrorMessage = "You don't indicate any tolled user groups. Is this facility a HOV?";
                args.IsValid = false;
            }
            else if (countGroupValidation == 0 && facility.SelectedValue == "1")
            {
                tempCV.ErrorMessage = "You need to select at least one currently tolled user group++.";
                args.IsValid = false;
            }
            else if (countGroupValidation == -5)
            {
                tempCV.ErrorMessage = "You indicate at least one toll-free user group. Is this facility a HOT?";
                args.IsValid = false;
            }
            else if (countGroupValidation == -6)
            {
                tempCV.ErrorMessage = "You need to select at least one currently tolled user group.";
                args.IsValid = false;
            }
            else if (countGroupValidation == 0 && facility.SelectedValue == "2")
            {
                tempCV.ErrorMessage = "You need to select at least one currently tolled user group.";
                args.IsValid = false;
            }
            else if (tempRank == -1)
            {
                tempCV.ErrorMessage = "You need to rank at least one of the allowed toll or free user groups.";
                args.IsValid = false;
            }
            else if (temp == 14)
            {
                tempCV.ErrorMessage = "Please rank and indicate tolled or free status for at least one user group.";
                args.IsValid = false;
            }
            else if (countGroupValidation == 0)
            {
                tempCV.ErrorMessage = "Please correct the error";
                args.IsValid = false;
            }
        }
        protected void opfixesValidator_ServerValidate(object source, ServerValidateEventArgs args)
        {
            int countCheckedBoxes = 0;
            int countTextBoxes = 0;
            foreach (Control c in Wizard1.ActiveStep.Controls)
            {
                if (c.GetType() == typeof(CheckBox))
                {
                    CheckBox temp = (CheckBox)c;
                    if (temp.Checked == true)
                    {
                        countCheckedBoxes++;
                    }
                }
                else if (c.GetType() == typeof(TextBox))
                {
                    TextBox tempText = (TextBox)c;
                    if (tempText.Text != "")
                    {
                        countTextBoxes++;
                    }
                }
            }
            if (countCheckedBoxes == 0 && countTextBoxes == 0)
            {
                opfixesValidator.ErrorMessage = "Please choose at least one operational fix.";
                args.IsValid = false;
            }
        }
        /*Returns the name of the vehicle from the index. Called from the next button click event
         * from the Rank User group page.      
         */
        protected string returnVehGroupName(int index)
        {
            string answer = "";
            switch (index)
            {
                case 0:
                    answer = "Transit";
                    break;
                case 1:
                    answer = "Vanpools";
                    break;
                case 2:
                    answer = "Other buses";
                    break;
                case 3:
                    answer = "HOV3+";
                    break;
                case 4:
                    answer = "HOV2";
                    break;
                case 5:
                    answer = "SOVs";
                    break;
                case 6:
                    answer = "Low Emissions/ \"green\" vehicles";
                    break;
                case 7:
                    answer = "Fuel efficient vehicles";
                    break;
                case 8:
                    answer = "Motorcycles";
                    break;
                case 9:
                    answer = "On duty law enforcement/ambulance/fire vehicles";
                    break;
                case 10:
                    answer = "Off duty law enforcement/ambulance/fire vehicles";
                    break;
                case 11:
                    answer = "Transportation Agency Vehicles";
                    break;
                case 12:
                    answer = "Low income travelers";
                    break;
                case 13:
                    answer = "Trucks";
                    break;

            }
            return answer;

        }
        /*Returns the name of the vehicle from the index. Called from the next button click event
         * from the Rank User group page.      
         */
        protected string returnVehGroupNameForFixes(int index,string casecode)
        {
            string answer = "";
            string[] casesToLook = {"012","112","212"};
            switch (index)
            {
                case 0:
                    answer = "Transit";
                    break;
                case 1:
                    answer = "Vanpools";
                    break;
                case 2:
                    answer = "Other buses";
                    break;
                case 3:
                    answer = "HOV3+";
                    break;
                case 4:
                    answer = "HOV2";
                    break;
                case 5:
                    answer = "SOVs";
                    break;
                case 6:
                    if(casesToLook.Contains(casecode))
                        answer = "Low Emissions/ \"green\" vehicles (SOV)";
                    else
                        answer = "Low Emissions/ \"green\" vehicles";
                    break;
                case 7:
                    if (casesToLook.Contains(casecode))
                        answer = "Fuel efficient vehicles (SOV)";
                    else
                        answer = "Fuel efficient vehicles";
                    break;
                case 8:
                    answer = "Motorcycles";
                    break;
                case 9:
                    if (casesToLook.Contains(casecode))
                        answer = "On duty law enforcement/ambulance/fire vehicles (SOV)";
                    else
                        answer = "On duty law enforcement/ambulance/fire vehicles";
                    break;
                case 10:
                    if (casesToLook.Contains(casecode))
                        answer = "Off duty law enforcement/ambulance/fire vehicles (SOV)";
                    else
                        answer = "Off duty law enforcement/ambulance/fire vehicles";
                    break;
                case 11:
                    if (casesToLook.Contains(casecode))
                        answer = "Transportation Agency Vehicles (SOV)";
                    else
                        answer = "Transportation Agency Vehicles";
                    break;
                case 12:
                    if (casesToLook.Contains(casecode))
                        answer = "Low income travelers (SOV)";
                    else
                        answer = "Low income travelers";
                    break;
                case 13:
                    answer = "Trucks";
                    break;

            }
            return answer;

        }
        /*Return the name of the goal. The parameter values passed to this function is the activestepindex which is
         * 2= Safe Travel, 3 = High speed travel etc.
         */
        protected string returnGoalNames(int goalindex)
        {
            string answer = "";
            switch (goalindex)
            {
                case 2:
                    answer = "Safe Travel";
                    break;
                case 3:
                    answer = "High-speed Travel";
                    break;
                case 4:
                    answer = "Reliable Travel";
                    break;
                case 5:
                    answer = "Optimize Revenue";
                    break;
                case 6:
                    answer = "Optimize Throughput";
                    break;

            }
            return answer;

        }
        protected void flowChartFirstRadio_SelectedIndexChanged(object sender, EventArgs e)
        {
            string stepidString = Wizard1.ActiveStep.ID.ToString();
            RadioButtonList tempRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(stepidString + "BeginRadio");
            tempRadio.Enabled = false;
            if (tempRadio.SelectedValue == "Yes")
            {
                clearCurrentStepUGroupsControls(Wizard1.ActiveStep.ID);
                clearCurrentStepPricingControls(Wizard1.ActiveStep.ID);
                clearCurrentStepOtherFixesControls(Wizard1.ActiveStep.ID);
                HiddenField hfield = (HiddenField)Page.FindControl(Wizard1.ActiveStep.ID + "Groups");
                restoreFromHiddenFieldGroups("new",hfield.Value);
                
                //Wizard1.ActiveStepIndex = Wizard1.ActiveStepIndex+1;

            }

            else
            {
                //display the very first question about applying op fix
                displayOpFixQuestionsStart();
            }

        }
        /*This function will display the very first question related to op fix...
         * starts from UGroups and end at the last op fix..
         * this function will only be called once per flow step
         */
        protected void displayOpFixQuestionsStart()
        {
            string idstring = Wizard1.ActiveStep.ID.ToString();
            List<string> OpLabelStrings = new List<string>();
            List<string> OpRadioStrings = new List<string>();
            List<string> OpMessageStrings = new List<string>();
            

            // We are starting with UGroups op fix which is why opfix2 goes first
            if (opFix2.Value != "")
            {
                startUGroupsQuestions();
            }
            else if (opFix1.Value != "")
            {
                startPricingQuestions();
            }
            else if(opFix3.Value != "")
            {
                makeOpFixLabelVisible("Enforcement");
            }
            else if (opFix4.Value != "")
            {
                makeOpFixLabelVisible("SHours");
            }
            else if (opFix5.Value != "")
            {
                makeOpFixLabelVisible("IRemoval");
            }
            else if (opFix6.Value != "")
            {
                makeOpFixLabelVisible("Traffic");
            }
            else if (opFix7.Value != "")
            {
                makeOpFixLabelVisible("Ramp");
            }
            else if (opFix8.Value != "")
            {
                makeOpFixLabelVisible("Design");
            }
            else if (opFix9.Value != "")
            {
                makeOpFixLabelVisible("Publicity");
            }
            else if (opFix10.Value != "")
            {
                makeOpFixLabelVisible("Others1");
            }
            else if (opFix11.Value != "")
            {
                makeOpFixLabelVisible("Others2");
            }

                        

        }
        /* Display the first UGroups Fix question.. this will display the first question if there are any veh groups 
         * to process.. if the list is empty, it will activate the hiddenlabel with message "No vehicle groups available
         * to apply this fix"
         */
        protected void startUGroupsQuestions() {
            vehGroupsProcessed.Value = "";
            
            string code = returnFinalCodeForFlowStepUGroups();
            List<string>[] list = new List<string>[2];
            list=getListToProcess(code,"new");
            vehGroupsList.Value = String.Join(",",list[1]);
            numberofitems.Value = list[1].Count().ToString();
            System.Diagnostics.Debug.WriteLine("Number of Items in the List = "+numberofitems.Value);
            string listofVehs = "";
            string flowStepId = Wizard1.ActiveStep.ID.ToString();
            if (vehGroupsList.Value != "")
            {
                Label ulabel = (Label)Wizard1.ActiveStep.FindControl(flowStepId + "UGroups0");
                ulabel.Text = getCompletedString(getQuestionString(code, getVehGroupCode(returnElementFromVehGroupsList(0))), returnStrForVehGroupsList(returnElementFromVehGroupsList(0),code));
                RadioButtonList ulabelRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(ulabel.ID + "Radio");
                ulabel.Visible = true;
                ulabelRadio.Visible = true;
            }
            else {
                Label ulabel = (Label)Wizard1.ActiveStep.FindControl(flowStepId + "UGroupsSummary");
                ulabel.Text = "No vehicle groups available to apply this fix";
                ulabel.Visible = true;
                string nextopfix = returnNextFromOpFixInOrder("UGroups");
                if (nextopfix != "-1")
                {
                    if (nextopfix == "Pricing")
                    {
                        startPricingQuestions();
                    }
                    else
                    {
                        makeOpFixLabelVisible(nextopfix);
                    }
                }
            }
            System.Diagnostics.Debug.WriteLine(listofVehs);
            //first step is to determine case
            // calculate list to process
            //if the list is not empty, time to display UGroups0 question
            // if empty, display that no vehicle groups available to apply this fix
                
        }
        protected void flowStepUGroupsRadio__SelectedIndexChanged(object sender, EventArgs e) {
            int wizStepIDLen = Wizard1.ActiveStep.ID.Length;
            int objectIDLen = ((RadioButtonList)sender).ID.Length;
            int ugroupIDLen = objectIDLen - wizStepIDLen-5;
            string ugroupID = ((RadioButtonList)sender).ID.Substring(wizStepIDLen, ugroupIDLen);
            //System.Diagnostics.Debug.WriteLine("Object ID is " + ((RadioButtonList)sender).ID.Substring(wizStepIDLen,ugroupIDLen));
            flowStepUGroupsCommonRadio(sender, e, ugroupID);
        }
        protected void flowStepUGroupsFixRadio_SelectedIndexChanged(object sender, EventArgs e) {
            int wizStepIDLen = Wizard1.ActiveStep.ID.Length;
            int objectIDLen = ((RadioButtonList)sender).ID.Length;
            int ugroupIDLen = objectIDLen - wizStepIDLen - 8;
            string ugroupID = ((RadioButtonList)sender).ID.Substring(wizStepIDLen, ugroupIDLen);
            flowStepUGroupsFixCommonRadio(sender, e, ugroupID);
        }
        /* Common function to process all the UGroups Radio buttons
         *
         */
        protected void flowStepUGroupsCommonRadio(object sender, EventArgs e, string currGroup) {
            RadioButtonList temp = (RadioButtonList)sender;
            WizardStep currStep = (WizardStep)Wizard1.ActiveStep;
            if (temp.SelectedValue == "Yes")
            {
                temp.Enabled = false;
                /*clearCurrentStepUGroupQs(currGroup);
                clearCurrentStepPricingQs("");
                clearAllUGroupsQuestions(Wizard1.ActiveStep.ID);
                clearAllPricingQuestions(Wizard1.ActiveStep.ID);
                clearAllOpFixQuestions(currStep);*/

                string code = returnFinalCodeForFlowStepUGroups();
                int index = int.Parse(currGroup.Substring(7, currGroup.Length - 7));
                List<string> elements = returnElementFromVehGroupsList(index);
                string origvehgroup = getVehGroupCode(elements);
                string newvehgroup = getNewVehGroupCode(code, origvehgroup);
                
                HiddenField hfield = (HiddenField)Page.FindControl("tempGroup" + index);
                foreach (string s in elements) {
                    string s1 = s + "-" + newvehgroup;
                    hfield.Value=addStrToHiddenField(s1, hfield.Value);
                }
                System.Diagnostics.Debug.WriteLine("Value of " + hfield.ID + " is " + hfield.Value);
                Label tempLabel = (Label)Wizard1.ActiveStep.FindControl(temp.ID.Replace("Radio", "") + "Fix");
                tempLabel.Text = "Did it fix the problem ?";
                RadioButtonList tempRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(tempLabel.ID + "Radio");
                tempRadio.ClearSelection();
                tempLabel.Visible = true;
                tempRadio.Visible = true;
            }
            else
            {
                temp.Enabled = false;
                int index = int.Parse(currGroup.Substring(7, currGroup.Length - 7));
                HiddenField hfield = (HiddenField)Page.FindControl("tempGroup" + index);
                hfield.Value = "";
                resetTempGroupHiddenFields("tempGroup" + index);
                
                storeAllTempGroupinVehGroupsProcessed();
                //calling process veh groups
                processVehGroups();
                copyTempHFToNewHF();
                clearCurrentStepUGroupQs(currGroup);
                string nextopfix = returnNextFromOpFixInOrder("UGroups");
                if (nextopfix != "-1")
                {
                    if (nextopfix == "Pricing")
                    {
                        startPricingQuestions();
                    }
                    else
                    {
                        makeOpFixLabelVisible(nextopfix);
                    }
                }

            }
        }
        /* Common function to process all the ugroups fix questions 
         */
        protected void flowStepUGroupsFixCommonRadio(object sender, EventArgs e, string currGroup)
        {
            RadioButtonList temp = (RadioButtonList)sender;
            WizardStep currStep = (WizardStep)Wizard1.ActiveStep;
            if (temp.SelectedValue == "Yes")
            {
                temp.Enabled = false;
                storeAllTempGroupinVehGroupsProcessed();
                processVehGroups();
                copyTempHFToNewHF();

                int index = int.Parse(currGroup.Substring(7, currGroup.Length - 7));
                resetTempGroupHiddenFields("tempGroup" + index);
                System.Diagnostics.Debug.WriteLine("Processed veh groups" + vehGroupsProcessed.Value);
            }
            else {
                temp.Enabled = false;
                string code = returnFinalCodeForFlowStepUGroups();
                int index = int.Parse(currGroup.Substring(7, currGroup.Length - 7));
                resetTempGroupHiddenFields("tempGroup" + index);
                // check if there are any more veh groups left to use the Ugroups op fix
                if (index+1 < int.Parse(numberofitems.Value))
                {
                    Label ulabel = (Label)Wizard1.ActiveStep.FindControl(Wizard1.ActiveStep.ID+"UGroups"+(index+1));
                    ulabel.Text = getCompletedString(getQuestionString(code, getVehGroupCode(returnElementFromVehGroupsList(index+1))), returnStrForVehGroupsList(returnElementFromVehGroupsList(index+1),code));
                    RadioButtonList ulabelRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(ulabel.ID + "Radio");
                    ulabel.Visible = true;
                    ulabelRadio.Visible = true;
                }
                else {
                    Label uLabel = (Label)Wizard1.ActiveStep.FindControl(Wizard1.ActiveStep.ID + "UGroupsSummary");
                    uLabel.Text = "No more vehicle groups available to apply this fix, moving on to next available fix";
                    uLabel.Visible = true;
                    storeAllTempGroupinVehGroupsProcessed();
                    processVehGroups();
                    copyTempHFToNewHF();
                    string nextopfix = returnNextFromOpFixInOrder("UGroups");
                    if (nextopfix != "-1")
                    {
                        if (nextopfix == "Pricing")
                        {
                            startPricingQuestions();
                        }
                        else
                        {
                            makeOpFixLabelVisible(nextopfix);
                        }
                    }
                }
                
            }
        }
        /* Display the first Pricing Fix question... this will check the veh group to process list and if the list
         * is empty it will display the message that no veh group available to apply to this fix
         */
        protected void startPricingQuestions() {
            vehGroupsProcessed.Value = "";
            resetAllTempGroupHiddenFields();
            string code = returnFinalCodeForFlowStepPricing();
            List<string>[] list = new List<string>[2];
            list = getListToProcess(code,"new");
            vehGroupsList.Value = String.Join(",", list[1]);
            numberofitems.Value = list[1].Count().ToString();
            System.Diagnostics.Debug.WriteLine("Number of Items in the List = " + numberofitems.Value);
            string listofVehs = "";
            string flowStepId = Wizard1.ActiveStep.ID.ToString();
            if (vehGroupsList.Value != "")
            {
                Label ulabel = (Label)Wizard1.ActiveStep.FindControl(flowStepId + "Pricing0");
                ulabel.Text = getCompletedString(getQuestionString(code, getVehGroupCode(returnElementFromVehGroupsList(0))), returnStrForVehGroupsList(returnElementFromVehGroupsList(0),code));
                RadioButtonList ulabelRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(ulabel.ID + "Radio");
                ulabel.Visible = true;
                ulabelRadio.Visible = true;
            }
            else
            {
                Label ulabel = (Label)Wizard1.ActiveStep.FindControl(flowStepId + "PricingSummary");
                ulabel.Text = "No vehicle groups available to apply this fix";
                ulabel.Visible = true;
                string nextopfix = returnNextFromOpFixInOrder("Pricing");
                if (nextopfix != "-1")
                {
                    makeOpFixLabelVisible(nextopfix);
                }
            }
            System.Diagnostics.Debug.WriteLine(listofVehs);
        
        }
        protected void flowStepPricingRadio__SelectedIndexChanged(object sender, EventArgs e)
        {
            int wizStepIDLen = Wizard1.ActiveStep.ID.Length;
            int objectIDLen = ((RadioButtonList)sender).ID.Length;
            int ugroupIDLen = objectIDLen - wizStepIDLen - 5;
            string ugroupID = ((RadioButtonList)sender).ID.Substring(wizStepIDLen, ugroupIDLen);
            //System.Diagnostics.Debug.WriteLine("Object ID is " + ((RadioButtonList)sender).ID.Substring(wizStepIDLen,ugroupIDLen));
            flowStepPricingCommonRadio(sender, e, ugroupID);
        }
        protected void flowStepPricingFixRadio__SelectedIndexChanged(object sender, EventArgs e)
        {
            int wizStepIDLen = Wizard1.ActiveStep.ID.Length;
            int objectIDLen = ((RadioButtonList)sender).ID.Length;
            int ugroupIDLen = objectIDLen - wizStepIDLen - 8;
            string ugroupID = ((RadioButtonList)sender).ID.Substring(wizStepIDLen, ugroupIDLen);
            flowStepPricingFixCommonRadio(sender, e, ugroupID);
        }
        /* Common function to process all the Pricing Radio buttons
         *
         */
        protected void flowStepPricingCommonRadio(object sender, EventArgs e, string currGroup)
        {
            RadioButtonList temp = (RadioButtonList)sender;
            WizardStep currStep = (WizardStep)Wizard1.ActiveStep;
            if (temp.SelectedValue == "Yes")
            {
                temp.Enabled = false;
                string code = returnFinalCodeForFlowStepPricing();
                int index = int.Parse(currGroup.Substring(7, currGroup.Length - 7));
                List<string> elements = returnElementFromVehGroupsList(index);
                string origvehgroup = getVehGroupCode(elements);
                string newvehgroup = getNewVehGroupCode(code, origvehgroup);

                HiddenField hfield = (HiddenField)Page.FindControl("tempGroup" + index);
                foreach (string s in elements)
                {
                    string s1 = s + "-" + newvehgroup;
                    hfield.Value = addStrToHiddenField(s1, hfield.Value);
                }
                Label tempLabel = (Label)Wizard1.ActiveStep.FindControl(temp.ID.Replace("Radio", "") + "Fix");
                tempLabel.Text = "Did it fix the problem ?";
                RadioButtonList tempRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(tempLabel.ID + "Radio");
                tempRadio.ClearSelection();
                tempLabel.Visible = true;
                tempRadio.Visible = true;
            }
            else
            {
                temp.Enabled = false;
                int index = int.Parse(currGroup.Substring(7, currGroup.Length - 7));
                HiddenField hfield = (HiddenField)Page.FindControl("tempGroup" + index);
                hfield.Value = "";
                resetTempGroupHiddenFields("tempGroup" + index);
                                              
                storeAllTempGroupinVehGroupsProcessed();
                //calling process veh groups
                processVehGroups();
                copyTempHFToNewHF();
                string nextopfix = returnNextFromOpFixInOrder("Pricing");
                if (nextopfix != "-1")
                {
                    makeOpFixLabelVisible(nextopfix);                    
                }

            }
        }
        /* Common function to process all the Pricing fix questions 
         */
        protected void flowStepPricingFixCommonRadio(object sender, EventArgs e, string currGroup)
        {
            RadioButtonList temp = (RadioButtonList)sender;
            WizardStep currStep = (WizardStep)Wizard1.ActiveStep;
            if (temp.SelectedValue == "Yes")
            {
                temp.Enabled = false;
                storeAllTempGroupinVehGroupsProcessed();
                processVehGroups();
                copyTempHFToNewHF();

                int index = int.Parse(currGroup.Substring(7, currGroup.Length - 7));
                resetTempGroupHiddenFields("tempGroup" + index);
                System.Diagnostics.Debug.WriteLine("Processed veh groups" + vehGroupsProcessed.Value);
            }
            else
            {
                temp.Enabled = false;
                string code = returnFinalCodeForFlowStepPricing();
                int index = int.Parse(currGroup.Substring(7, currGroup.Length - 7));
                resetTempGroupHiddenFields("tempGroup" + index);
                // check if there are any more veh groups left to use the Ugroups op fix
                if (index + 1 < int.Parse(numberofitems.Value))
                {
                    Label ulabel = (Label)Wizard1.ActiveStep.FindControl(Wizard1.ActiveStep.ID + "Pricing"+(index+1));
                    ulabel.Text = getCompletedString(getQuestionString(code, getVehGroupCode(returnElementFromVehGroupsList(index+1))), returnStrForVehGroupsList(returnElementFromVehGroupsList(index+1),code));
                    RadioButtonList ulabelRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(ulabel.ID + "Radio");
                    ulabel.Visible = true;
                    ulabelRadio.Visible = true;
                }
                else
                {
                    Label uLabel = (Label)Wizard1.ActiveStep.FindControl(Wizard1.ActiveStep.ID + "PricingSummary");
                    uLabel.Text = "No more vehicle groups available to apply this fix, moving on to next available fix";
                    uLabel.Visible = true;
                    System.Diagnostics.Debug.WriteLine("****** START OF ERROR *********");
                    storeAllTempGroupinVehGroupsProcessed();
                    processVehGroups();
                    copyTempHFToNewHF();
                    string nextopfix = returnNextFromOpFixInOrder("Pricing");
                    if (nextopfix != "-1")
                    {
                        
                            makeOpFixLabelVisible(nextopfix);
                        
                    }
                }

            }
        }
        protected string getTimeString(string timeStr)
        {
            string answer = "";
            if (timeStr == "flowStep1" || timeStr == "flowStep2" || timeStr == "flowStep5" || timeStr == "flowStep6")
            {
                answer = " during the peak period ?";
            }
            else if (timeStr == "flowStep3" || timeStr == "flowStep4" || timeStr == "flowStep7" || timeStr == "flowStep8")
            {
                answer = " during the peak period and all day ?";
            }
            return answer;

        }
        protected void hideOpFixQuestions(string opfixstr)
        {
            string idstring = Wizard1.ActiveStep.ID.ToString();
            string[] OpLabelStrings = { "Enforcement", "SHours", "IRemoval", "Traffic", "Ramp", "Design", "Publicity", "Others1", "Others2" };
            string[] OpRadioStrings = { "EnforcementRadio", "SHoursRadio", "IRemovalRadio", "TrafficRadio", "RampRadio", "DesignRadio", "PublicityRadio", "Others1Radio", "Others2Radio" };
            
            Label tempLabel1,tempLabel2;
            RadioButtonList tempRadioList1,tempRadioList2;
            if (opfixstr == "")
            {
                for (int i = 0; i < OpLabelStrings.Length; i++)
                {
                    tempLabel1 = (Label)Wizard1.ActiveStep.FindControl(idstring + OpLabelStrings[i]);
                    tempLabel2 = (Label)Wizard1.ActiveStep.FindControl(tempLabel1.ID + "Fix");
                    tempRadioList1 = (RadioButtonList)Wizard1.ActiveStep.FindControl(tempLabel1.ID + "Radio");
                    tempRadioList2 = (RadioButtonList)Wizard1.ActiveStep.FindControl(tempLabel2.ID + "Radio");
                    tempLabel1.Text = "";
                    tempLabel2.Text = "";
                    tempRadioList1.ClearSelection();
                    tempRadioList2.ClearSelection();
                    tempLabel1.Visible = false;
                    tempLabel2.Visible = false;
                    tempRadioList1.Visible = false;
                    tempRadioList2.Visible = false;

                }

            }
            else {
                int index = Array.FindIndex(OpLabelStrings, s => s == opfixstr);
                for (int i = index; i < OpLabelStrings.Length; i++)
                {
                    tempLabel1 = (Label)Wizard1.ActiveStep.FindControl(idstring + OpLabelStrings[i]);
                    tempLabel2 = (Label)Wizard1.ActiveStep.FindControl(tempLabel1.ID + "Fix");
                    tempRadioList1 = (RadioButtonList)Wizard1.ActiveStep.FindControl(tempLabel1.ID + "Radio");
                    tempRadioList2 = (RadioButtonList)Wizard1.ActiveStep.FindControl(tempLabel2.ID + "Radio");
                    tempLabel1.Text = "";
                    tempLabel2.Text = "";
                    tempRadioList1.ClearSelection();
                    tempRadioList2.ClearSelection();
                    tempLabel1.Visible = false;
                    tempLabel2.Visible = false;
                    tempRadioList1.Visible = false;
                    tempRadioList2.Visible = false;

                }
            
            }
        }
        /* Clears all op fix questions from all the wizardsteps .... This function can be used to clear rest of the 
         * flowstep op fix questions by supplying the argument of the current wizardstep you are on you if you are on
         * flowstep1 that means you can't really be sure of what your veh groups will be especially if you are dealing with
         * pricing and ugroups op fix so better to clear out all the op fix questions ...
         * if you supply null as parameter it clears out all the op fix questions...
         * This function will deal with UGroups and Pricing Op fix questions differently... needs to code it
         * 
         * 
         * IMPORTANT ... The wizardsteps array should include all the steps.. for debug I have only enabled the
         * first wizardstep
         * 
         * 
         */
        protected void clearAllOpFixQuestions(WizardStep wizstep)
        {
            
            //string idstring = Wizard1.ActiveStep.ID.ToString();
            //WizardStep[] wizardsteps = { flowStep1 };
            string[] wizStrs = { "flowStep1", "flowStep2", "flowStep3", "flowStep3", "flowStep4", "flowStep5", "flowStep6", "flowStep7", "flowStep8" };
            WizardStep[] wizardsteps = { flowStep1, flowStep2, flowStep3, flowStep3, flowStep4, flowStep5, flowStep6, flowStep7, flowStep8 };
            string[] OpLabelStrings = { "Enforcement", "SHours", "IRemoval", "Traffic", "Ramp", "Design", "Publicity", "Others1", "Others2" };
            //string[] OpRadioStrings = { "EnforcementRadio", "SHoursRadio", "IRemovalRadio", "TrafficRadio", "RampRadio", "DesignRadio", "PublicityRadio", "Others1Radio", "Others2Radio" };
            Control tempControl;
            Label tempLabel1,tempLabel2;
            RadioButtonList tempRadioList1,tempRadioList2;
            int index=0;
            if (wizstep != null)
            {
                index = Array.FindIndex(wizStrs, s => s == wizstep.ID);
            }

            for(int loop=index;loop<wizardsteps.Count();loop++)
            {

                for (int i = 0; i < OpLabelStrings.Length; i++)
                {
                    tempLabel1 = (Label)wizardsteps[loop].FindControl(wizardsteps[loop].ID + OpLabelStrings[i]);
                    
                    tempLabel2 = (Label)wizardsteps[loop].FindControl(tempLabel1.ID + "Fix");
                    
                    tempRadioList1 = (RadioButtonList)wizardsteps[loop].FindControl(tempLabel1.ID + "Radio");
                    
                    tempRadioList2 = (RadioButtonList)wizardsteps[loop].FindControl(tempLabel2.ID + "Radio");
                    
                    tempLabel1.Text = "";
                    tempLabel2.Text = "";
                    tempRadioList1.ClearSelection();
                    tempRadioList2.ClearSelection();
                    tempLabel1.Visible = false;
                    tempLabel2.Visible = false;
                    tempRadioList1.Visible = false;
                    tempRadioList2.Visible = false;

                    
                }
                if (wizardsteps[loop].ID != Wizard1.ActiveStep.ID)
                {
                    tempControl = wizardsteps[loop].FindControl(wizardsteps[loop].ID.ToString() + "BeginRadio");
                    if (tempControl != null)
                    {
                        tempRadioList1 = (RadioButtonList)tempControl;
                        tempRadioList1.ClearSelection();
                    }
                }
            }
        }
        /* This function is used to clear all the UGroups op fix related questions from the wizard steps.
         * if the wizardstep argument is supplied, it starts from the next step or else it starts from flowStep1
         * and go through all the flow steps. This is important because the UGroups and Pricing fixes changes the
         * vehicle list depending upon the answers.
         * 
         * The UGroups fix related questions for the current step are handled in the different function to preserve
         * previous answers.
         * 
         */
        protected void clearAllUGroupsQuestions(string wizstepID) {
            string[] ugroups = { "UGroups0", "UGroups1", "UGroups2", "UGroups3", "UGroups4", "UGroups5", "UGroups6", "UGroups7", "UGroups8", "UGroups9", "UGroups10", "UGroups11", "UGroups12", "UGroups13" };
            string[] wizStrs = { "flowStep1", "flowStep2", "flowStep3", "flowStep3", "flowStep4", "flowStep5", "flowStep6", "flowStep7", "flowStep8" };
            WizardStep[] wizardsteps = { flowStep1, flowStep2, flowStep3, flowStep3, flowStep4, flowStep5, flowStep6, flowStep7, flowStep8 };
            
            int index=-1;
            if (wizstepID != "")
            {
                index = Array.FindIndex(wizStrs, s => s == wizstepID);
            }

            for (int loop = index+1; loop < wizardsteps.Count(); loop++) {
                foreach (string s in ugroups) {
                    Label ugroup = (Label)wizardsteps[loop].FindControl(wizardsteps[loop].ID + s);
                    RadioButtonList ugroupRadio = (RadioButtonList)wizardsteps[loop].FindControl(ugroup.ID + "Radio");
                    Label ugroupfix = (Label)wizardsteps[loop].FindControl(ugroup.ID + "Fix");
                    RadioButtonList ugroupfixRadio = (RadioButtonList)wizardsteps[loop].FindControl(ugroupfix.ID + "Radio");
                    ugroup.Text = "";
                    ugroupfix.Text = "";
                    ugroupRadio.ClearSelection();
                    ugroupfixRadio.ClearSelection();
                    ugroup.Visible = false;
                    ugroupfix.Visible = false;
                    ugroupRadio.Visible = false;
                    ugroupfixRadio.Visible = false;
                
                }
                Label summarylabel = (Label)wizardsteps[loop].FindControl(wizardsteps[loop].ID + "UGroupsSummary");
                summarylabel.Text = "";
                summarylabel.Visible = false;
            
            }
        
        }
        /* This function clears the values from the current step related to UGroups op fix ... This will only clear the
         * values from the current step ... if you want to clear the values from all the other steps too use clear allugroupsresults
         * function
         */
        protected void clearCurrentStepUGroupQs(string input) {
            string[] ugroups = { "UGroups0", "UGroups1", "UGroups2", "UGroups3", "UGroups4", "UGroups5", "UGroups6", "UGroups7", "UGroups8", "UGroups9", "UGroups10", "UGroups11", "UGroups12", "UGroups13" };
            int index = 0;
            if (input != "")
            {
                index = Array.FindIndex(ugroups, s => s == input)+1;
            }
            for (int i = index; i < ugroups.Count(); i++) {
                Label temp = (Label)Wizard1.ActiveStep.FindControl(Wizard1.ActiveStep.ID + ugroups[i]);
                RadioButtonList tempRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(temp.ID + "Radio");
                Label tempFix = (Label)Wizard1.ActiveStep.FindControl(Wizard1.ActiveStep.ID + ugroups[i] + "Fix");
                RadioButtonList tempFixRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(tempFix.ID + "Radio");
                temp.Text = "";
                tempFix.Text = "";
                tempRadio.ClearSelection();
                tempFixRadio.ClearSelection();
                temp.Visible = false;
                tempFix.Visible = false;
                tempRadio.Visible = false;
                tempFixRadio.Visible = false;
            
            }
            Label tempSummary = (Label)Wizard1.ActiveStep.FindControl(Wizard1.ActiveStep.ID + "UGroupsSummary");
            tempSummary.Text = "";
            tempSummary.Visible = false;
        }
        /* Similar to clearCurrentStepUGroupQs function 
         */
        protected void clearCurrentStepPricingQs(string input)
        {
            string[] ugroups = { "Pricing0", "Pricing1", "Pricing2", "Pricing3", "Pricing4", "Pricing5", "Pricing6", "Pricing7", "Pricing8", "Pricing9", "Pricing10", "Pricing11", "Pricing12", "Pricing13" };
            int index = 0;
            if (input != "")
            {
                index = Array.FindIndex(ugroups, s => s == input)+1;
            }
            for (int i = index; i < ugroups.Count(); i++)
            {
                hideAndClearLabelControl(Wizard1.ActiveStep.ID, ugroups[i]);
                hideAndClearRadioControl(Wizard1.ActiveStep.ID, ugroups[i] + "Radio");
                hideAndClearLabelControl(Wizard1.ActiveStep.ID, ugroups[i]+"Fix");
                hideAndClearRadioControl(Wizard1.ActiveStep.ID, ugroups[i] + "FixRadio");
                /*Label temp = (Label)Wizard1.ActiveStep.FindControl(Wizard1.ActiveStep.ID + ugroups[i]);
                RadioButtonList tempRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(temp.ID + "Radio");
                Label tempFix = (Label)Wizard1.ActiveStep.FindControl(Wizard1.ActiveStep.ID + ugroups[i] + "Fix");
                RadioButtonList tempFixRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(tempFix.ID + "Radio");
                temp.Text = "";
                tempFix.Text = "";
                tempRadio.ClearSelection();
                tempFixRadio.ClearSelection();
                temp.Visible = false;
                tempFix.Visible = false;
                tempRadio.Visible = false;
                tempFixRadio.Visible = false;*/

            }
            hideAndClearLabelControl(Wizard1.ActiveStep.ID, "PricingSummary");
            /*Label tempSummary = (Label)Wizard1.ActiveStep.FindControl(Wizard1.ActiveStep.ID + "PricingSummary");
            tempSummary.Text = "";
            tempSummary.Visible = false;*/
        }

        /* This function is similar to clearAllUGroupsQuestions function but for the Pricing op fix.
         * 
         */
        protected void clearAllPricingQuestions(string wizstepID)
        {
            string[] ugroups = { "Pricing0", "Pricing1", "Pricing2", "Pricing3", "Pricing4", "Pricing5", "Pricing6", "Pricing7", "Pricing8", "Pricing9", "Pricing10", "Pricing11", "Pricing12", "Pricing13" };
            string[] wizStrs = { "flowStep1", "flowStep2", "flowStep3", "flowStep3", "flowStep4", "flowStep5", "flowStep6", "flowStep7", "flowStep8" };
            WizardStep[] wizardsteps = { flowStep1, flowStep2, flowStep3, flowStep3, flowStep4, flowStep5, flowStep6, flowStep7, flowStep8 };

            int index = -1;
            if (wizstepID != "")
            {
                index = Array.FindIndex(wizStrs, s => s == wizstepID);
            }

            for (int loop = index + 1; loop < wizardsteps.Count(); loop++)
            {
                foreach (string s in ugroups)
                {
                    hideAndClearLabelControl(wizardsteps[loop].ID, s);
                    hideAndClearLabelControl(wizardsteps[loop].ID, s+"Fix");
                    hideAndClearRadioControl(wizardsteps[loop].ID, s + "Radio");
                    hideAndClearRadioControl(wizardsteps[loop].ID, s + "FixRadio");
                    /*Label ugroup = (Label)wizardsteps[loop].FindControl(wizardsteps[loop].ID + s);
                    RadioButtonList ugroupRadio = (RadioButtonList)wizardsteps[loop].FindControl(ugroup.ID + "Radio");
                    Label ugroupfix = (Label)wizardsteps[loop].FindControl(ugroup.ID + "Fix");
                    RadioButtonList ugroupfixRadio = (RadioButtonList)wizardsteps[loop].FindControl(ugroupfix.ID + "Radio");
                    ugroup.Text = "";
                    ugroupfix.Text = "";
                    ugroupRadio.ClearSelection();
                    ugroupfixRadio.ClearSelection();
                    ugroup.Visible = false;
                    ugroupfix.Visible = false;
                    ugroupRadio.Visible = false;
                    ugroupfixRadio.Visible = false;*/

                }
                hideAndClearLabelControl(wizardsteps[loop].ID, "PricingSummary");
                /*Label summarylabel = (Label)wizardsteps[loop].FindControl(wizardsteps[loop].ID + "PricingSummary");
                summarylabel.Text = "";
                summarylabel.Visible = false;*/

            }
        
        
        
        }
        protected void displayOpFixQuestions(Control ctrl)
        {
            string ctrlString = ctrl.ID.ToString();
            if (ctrlString.EndsWith("Pricing")) { }

        }
        protected void storeFlowStepValues()
        {
            List<string> flowstepsList = returnFlowStepsArray();
            List<string> opfixList = returnOpFixStrings();
            string idstring = Wizard1.ActiveStep.ID.ToString();
            if (flowstepsList.Contains(idstring))
            {
                int tempIndex = flowstepsList.IndexOf(idstring);
                RadioButtonList tempRadioList = (RadioButtonList)Wizard1.ActiveStep.FindControl(idstring + "BeginRadio");
                //System.Diagnostics.Debug.WriteLine(tempRadioList.SelectedValue);
                if (tempRadioList.SelectedValue == "No")
                {
                    HiddenField temp = (HiddenField)Wizard1.ActiveStep.FindControl(idstring + "Hidden");
                    temp.Value = "";
                    for (int i = 0; i < opfixList.Count(); i++)
                    {
                        RadioButtonList tempRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(idstring + opfixList[i] + "Radio");
                        if(tempRadio != null)
                        if (tempRadio.SelectedValue == "Yes")
                        {
                            temp.Value = temp.Value + opfixList[i] + ",";
                        }
                    }
                    //temp.Value = temp.Value + "1";

                }
                else
                {
                    HiddenField temp = (HiddenField)Wizard1.ActiveStep.FindControl(idstring + "Hidden");
                    temp.Value = "0";
                }

            }
            else
            {
                HiddenField temp = (HiddenField)Wizard1.ActiveStep.FindControl(idstring + "Hidden");
                temp.Value = "";
            }

        }
        protected List<string> returnOpFixStrings()
        {
            List<string> answer = new List<string>();

            if (opFix1.Value != "")
                answer.Add("Pricing");
            if (opFix2.Value != "")
                answer.Add("UGroups");
            if (opFix3.Value != "")
                answer.Add("Enforcement");
            if (opFix4.Value != "")
                answer.Add("SHours");
            if (opFix5.Value != "")
                answer.Add("IRemoval");
            if (opFix6.Value != "")
                answer.Add("Traffic");
            if (opFix7.Value != "")
                answer.Add("Ramp");
            if (opFix8.Value != "")
                answer.Add("Design");
            if (opFix9.Value != "")
                answer.Add("Publicity");
            if (opFix10.Value != "")
                answer.Add("Others1");
            if (opFix11.Value != "")
                answer.Add("Others2");
            return answer;
        }
        /*The steps for the flow charts (flowStep1,flowStep2...etc) are coded in a way where each step
         *addresses one MOE. There can only be a max of 8 moes because only a max of 2 goals can be selected
         *and four moe per goal. This function returns the flowchart step IDs.*/
        protected List<string> returnFlowStepsArray()
        {
            List<string> tempList = new List<string>();
            string temp = "";
            temp = hiddenGoal1MOE1Peak.Value != "" ? "flowStep1" : "";
            tempList.Add(temp);
            temp = hiddenGoal1MOE2Peak.Value != "" ? "flowStep2" : "";
            tempList.Add(temp);
            temp = hiddenGoal1MOE1All.Value != "" ? "flowStep3" : "";
            tempList.Add(temp);
            temp = hiddenGoal1MOE2All.Value != "" ? "flowStep4" : "";
            tempList.Add(temp);
            temp = hiddenGoal2MOE1Peak.Value != "" ? "flowStep5" : "";
            tempList.Add(temp);
            temp = hiddenGoal2MOE2Peak.Value != "" ? "flowStep6" : "";
            tempList.Add(temp);
            temp = hiddenGoal2MOE1All.Value != "" ? "flowStep7" : "";
            tempList.Add(temp);
            temp = hiddenGoal2MOE2All.Value != "" ? "flowStep8" : "";
            tempList.Add(temp);

            return tempList;
        }
        protected string returnErrorStringforFlowSteps()
        {
            List<string> flowstepsList = returnFlowStepsArray();
            List<string> opfixList = returnOpFixStrings();
            string idstring = Wizard1.ActiveStep.ID.ToString();
            string errorString1 = "";
            List<string> errorString2 = new List<string>();
            String listToString = "";
            RadioButtonList tempRadio;
            List<string> firstList = getListOfUGroupsRadio();
            List<string> secondList = getListOfUGroupsFixRadio();
            List<string> thirdList = getListOfPricingRadio();
            List<string> fourthList = getListOfPricingFixRadio();
            List<string> fifthList = getListOfOtherOpsRadio();
            List<string> sixthList = getListOfOtherOpsFixRadio();

            firstList.AddRange(secondList);
            firstList.AddRange(thirdList);
            firstList.AddRange(fourthList);
            firstList.AddRange(fifthList);
            firstList.AddRange(sixthList);
            if (flowstepsList.Contains(idstring))
            {
                tempRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(Wizard1.ActiveStep.ID + "BeginRadio");
                if (tempRadio.SelectedValue == "")
                {
                    errorString1 = "Please choose 'Yes' or 'No' to indicate whether you are satisfied with this MOE.";
                }
                else if (tempRadio.SelectedValue == "No")
                {
                    foreach (String s in firstList)
                    {
                        
                        tempRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(Wizard1.ActiveStep.ID+s);
                        if(tempRadio != null)
                        if (tempRadio.Visible==true && tempRadio.SelectedValue == "")
                        {
                            errorString2.Add("Please answer all the questions.");
                        }
                    }
                }


            }
            if (errorString2.Count() > 0)
            {

                if (errorString2.Count() > 1)
                {
                    listToString = String.Join("$", errorString2);

                }
                else
                {
                    listToString = String.Join(",", errorString2);
                }
            }
            if (errorString1 != "")
            {
                return errorString1;
            }
            else
            {
                //System.Diagnostics.Debug.Write(listToString);
                return listToString;
            }

        }
        protected string returnActualOpFixNames(string s)
        {
            string returnString = "";
            switch (s)
            {
                case "Pricing":
                    returnString = "pricing";
                    break;
                case "UGroups":
                    returnString = "allowed user groups";
                    break;
                case "Enforcement":
                    returnString = "increase enforcement";
                    break;
                case "SHours":
                    returnString = "activate shoulder hours";
                    break;
                case "IRemoval":
                    returnString = "rapid incident removal program";
                    break;
                case "Traffic":
                    returnString = "active traffic management";
                    break;
                case "Ramp":
                    returnString = "ramp Metering";
                    break;
                case "Design":
                    returnString = "improve design to increase speeds or reduce crash rates";
                    break;
                case "Publicity":
                    returnString = "publicity about conditions or toll rates";
                    break;
                case "Others1":
                    returnString = opFix10.Value;
                    break;
                case "Others2":
                    returnString = opFix11.Value;
                    break;

            }
            return returnString;

        }
        protected void flowStepValidator_ServerValidate(object source, ServerValidateEventArgs args)
        {
            string error = returnErrorStringforFlowSteps();
            CustomValidator temp = (CustomValidator)source;
            if (error != "")
            {
                if (error.Contains("$"))
                {
                    error = error.Replace("$", "<br>");
                }
                temp.ErrorMessage = error;
                args.IsValid = false;

            }
        }
        /*Returns selected facility type by checking which checkbox is checked and returns empty string if not checked*/
        protected string getSelectedFacility()
        {
            string facilitytype = "";
            if (facility.SelectedIndex == 0) { facilitytype = "HOV"; }
            else if (facility.SelectedIndex == 1) { facilitytype = "HOT"; }
            else if (facility.SelectedIndex == 2) { facilitytype = "TOLL"; }
            return facilitytype;
        }
        /*Returns a List<string> array with 0 element stores the priority values, and 1 element stores the 
         * status values. Since the List is also a 0-based storage, no need to store the vehicle groups name.
         * This array stores all the values that has been entered on the ranGroupsStep. 
         * priority values can be from -1 to 14 with "0" means that group is permanently not allowed. Don't know the use
         * of it at this point. Status values 0 = currently tolled, 1 = currently free and 2= currently not allowed.
         * If you use this function to order priorities, you need to know the corresponding vehicle groups to for that use 
         * function returnVehGroupName(int index) which returns vehicle group names based on 0 index.
         */
        protected List<string>[] returnGroupsStepResults()
        {
            List<string>[] listArray = new List<string>[2];
            listArray[0] = new List<string>();
            listArray[1] = new List<string>();
            List<string> answerList = new List<string>();
            foreach (DropDownList c in rankGroupsStep.Controls.OfType<DropDownList>())
            {
                if (c.ID.EndsWith("priority"))
                    listArray[0].Add(c.SelectedValue);
                else if (c.ID.EndsWith("Status"))
                    listArray[1].Add(c.SelectedValue);

            }
            return listArray;

        }
        /*returns the priority values and index as a two-dimensional array of List<string>
         * Calls the returnGroupResults with corresponding 
         */
        protected List<string>[] returnTolledGroupResults()
        {

            List<string>[] returnResults = new List<string>[2];
            returnResults = returnGroupResults("0");
            return returnResults;
        }
        /*Similar to returnTolledGroupResults function but this one returns the values for the free vehicle groups*/
        protected List<string>[] returnFreeGroupResults()
        {

            List<string>[] returnResults = new List<string>[2];
            returnResults = returnGroupResults("1");
            return returnResults;
        }
        /*Similar to returnTolledGroupResults function but this one returns the values for the not allowed vehicle groups*/
        protected List<string>[] returnNotAllowedGroupResults()
        {

            List<string>[] returnResults = new List<string>[2];
            returnResults = returnGroupResults("2");
            return returnResults;
        }
        /*Accepts one parameter which is a string where "0" = currently tolled, "1" = currently free , "2" = currently not allowed
         * Return just the selected vehicle group results in a two-dimensional List<string> array
         * with 0 index stores the veh group index and 1 index stores the corresponding priority values
         * No need to store the status values since this function is only for the selected group vehicles.
         * This function uses the returnGroupsStepResults function which stores the values for all vehicle groups
         * The returnGroupsStepResults returns a two-dimensional List<string>array with 0 index stores priority values and
         * 1 index stores status values. 
         */
        protected List<string>[] returnGroupResults(string s)
        {
            List<string>[] listAllResults = new List<string>[2];
            listAllResults = returnGroupsStepResults();
            List<string>[] returnResults = new List<string>[2];
            returnResults[0] = new List<string>(); // store veh group index
            returnResults[1] = new List<string>(); //store priority value
            switch (s)
            {
                case "0":
                    for (int i = 0; i < listAllResults[1].Count(); i++)
                    {
                        if (listAllResults[1][i] == "0")
                        {
                            returnResults[0].Add(i.ToString());
                            returnResults[1].Add(listAllResults[0][i]);
                        }
                    }
                    break;
                case "1":
                    for (int i = 0; i < listAllResults[1].Count(); i++)
                    {
                        if (listAllResults[1][i] == "1")
                        {
                            returnResults[0].Add(i.ToString());
                            returnResults[1].Add(listAllResults[0][i]);
                        }
                    }
                    break;
                case "2":
                    for (int i = 0; i < listAllResults[1].Count(); i++)
                    {
                        if (listAllResults[1][i] == "2")
                        {
                            returnResults[0].Add(i.ToString());
                            returnResults[1].Add(listAllResults[0][i]);
                        }
                    }
                    break;
            }
            return returnResults;
        }
        /*This function returns the Group results sorted in a two-dimensional list format.
         * The input to this is a two-dimensional list fortmat to with 0 index list contains the veh group index
         * and 1 index list contains the priority... the status is not required since this has to be done per group basis
         */
        protected List<string>[] returnSortedGroupResults(List<string>[] inputList)
        {
            List<string>[] originalList = inputList;
            List<string>[] finalList = new List<string>[2];
            List<string> sortedUniqueList = returnUniqueValuesList(originalList[1]);
            List<string> groupIndexList = new List<string>();
            List<string> priorityList = new List<string>();
            foreach (String s in sortedUniqueList)
            {

                for (int i = 0; i < originalList[1].Count(); i++)
                {
                    if (originalList[1][i] == s)
                    {
                        groupIndexList.Add(originalList[0][i]);
                        priorityList.Add(s);
                    }
                }


            }
            finalList[0] = groupIndexList;
            finalList[1] = priorityList;
            System.Diagnostics.Debug.WriteLine(String.Join(",", groupIndexList));
            System.Diagnostics.Debug.WriteLine(String.Join(",", priorityList));
            //System.Diagnostics.Debug.WriteLine(uniqueSortedList.ConvertAll<string>(x=>x.ToString()));
            return finalList;

        }
        /*This function returns the unique values in a list sorted in ascending order*/
        protected List<string> returnUniqueValuesList(List<string> inputList)
        {
            List<string> originalList = inputList;
            List<string> finalList = new List<string>();
            List<int> storeSortedList = new List<int>();
            foreach (String s in originalList)
            {
                
                if(s != "")
                storeSortedList.Add(int.Parse(s));
            }
            storeSortedList.Sort();
            List<int> uniqueSortedList = storeSortedList.Distinct().ToList();
            finalList = uniqueSortedList.ConvertAll<string>(x => x.ToString());
            return finalList;
        }
        /*Removes values with supplied priority from the list.First Input is a two-dimensional list with 0 index 
         * veh group index and 1 index is the priorities. Second Input is the priority that you want removed
         */
        protected List<string>[] removePriorityFromList(List<string>[] inputList, String s1)
        {
            List<string>[] originalList = inputList;
            List<string>[] finalList = new List<string>[2];
            List<string> vehGroupList = new List<string>();
            List<string> priorityList = new List<string>();

            for (int i = 0; i < originalList[0].Count(); i++)
            {

                if (originalList[1][i] != s1)
                {
                    vehGroupList.Add(originalList[0][i]);
                    priorityList.Add(originalList[1][i]);
                }
            }

            finalList[0] = vehGroupList;
            finalList[1] = priorityList;
            //System.Diagnostics.Debug.WriteLine(String.Join(",", finalList[0]));
            //System.Diagnostics.Debug.WriteLine(String.Join(",", finalList[1]));
            return finalList;
        }
        /*Uses removePriorityFromList to remove multiple priorities from the list at the same time*/
        protected List<string>[] removeMultiplePrioritiesFromList(List<string>[] inputList, List<string> s1)
        {
            List<string>[] finalAnswer = new List<string>[2];
            List<string>[] beginList = inputList;
            foreach (String s in s1)
            {
                beginList = removePriorityFromList(beginList, s);
            }
            //System.Diagnostics.Debug.WriteLine(String.Join(",", beginList[0]));
            //System.Diagnostics.Debug.WriteLine(String.Join(",", beginList[1]));
            return beginList;
        }
        protected List<string>[] getListWithAPriority(List<string>[] inputList, String s1)
        {
            List<string> tempVehIndex = new List<string>();
            List<string> temppriority = new List<string>();
            List<string>[] finalList = new List<string>[2];
            for (int i = 0; i < inputList[0].Count(); i++)
            {
                if (inputList[1][i] == s1)
                {
                    tempVehIndex.Add(inputList[0][i]);
                    temppriority.Add(inputList[1][i]);
                }
            }
            finalList[0] = tempVehIndex;
            finalList[1] = temppriority;
            return finalList;
        }
        protected string getGoalsStringForResults()
        {
            string answer = "";
            if (hiddenGoal2.Value == "-1")
            {
                answer = "<h4>GOAL : " + returnGoalNames(int.Parse(hiddenGoal1.Value)) + "</h4><br />";
                string temp = getGoal1StringForResults();
                answer = answer + temp;
            }
            else
            {
                answer = "<h4>GOAL : " + returnGoalNames(int.Parse(hiddenGoal1.Value)) + "</h4><br />";
                string temp = getGoal1StringForResults();
                answer = answer + temp + "<br /><br />";
                answer = answer + "<h4>GOAL : " + returnGoalNames(int.Parse(hiddenGoal2.Value)) + "</h4><br />";
                string temp1 = getGoal2StringForResults();
                answer = answer + temp1 + "<br />";

            }
            return answer;
        }
        protected string getFormattedOpFixStringForResults(string s1)
        {
            string begin = s1.Substring(0, s1.Length - 1);
            List<string> final = new List<string>();
            string[] splitStrings;
            splitStrings = begin.Split(new Char[] { ',' });
            for (int i = 0; i < splitStrings.Length; i++)
            {
                string temp = returnActualOpFixNames(splitStrings[i]);
                final.Add(temp);
            }
            return String.Join("<br />", final);
        }
        protected string getGoal1StringForResults()
        {
            string temp = "";
            string temp2 = "";
            if (hiddenGoal1MOE1Peak.Value != "")
            {
                temp = "Chosen MOE : " + hiddenGoal1MOE1Peak.Value + "<br />";
                temp = flowStep1Hidden.Value != "0" ? temp + "Currently : Failing" + "<br />" : temp + "Currently : OK" + "<br />";
                temp = temp + "Value assigned to this MOE : " + hiddenGoal1MOE1PeakVal.Value + "<br />";
                temp = temp + "Selected operational fixes for this MOE : " + "<br />";
                //temp2 = flowStep1Hidden.Value != "" ? getFormattedOpFixStringForResults(flowStep1Hidden.Value) : "None";
                temp2 = flowStep1Fixes.Value;
                //temp = temp + temp2 +"<br />"+((flowStep1Values.Value.Replace("$$$","<br />")).Replace("BEGINDIVlineBox","<div class=\"lineBox\">")).Replace("ENDDIV","</div>")+ "<br /><br />";
                temp = temp + temp2 + "<br />" + stringReplacer(flowStep1Values.Value) + "<br /><br />";
            }
            if (hiddenGoal1MOE2Peak.Value != "")
            {
                temp = temp + "Chosen MOE : " + hiddenGoal1MOE2Peak.Value + "<br />";
                temp = flowStep2Hidden.Value != "0" ? temp + "Currently : Failing" + "<br />" : temp + "Currently : OK" + "<br />";
                temp = temp + "Value assigned to this MOE : " + hiddenGoal1MOE2PeakVal.Value + "<br />";
                temp = temp + "Selected operational fixes for this MOE : " + "<br />";
                //temp2 = flowStep2Hidden.Value != "" ? getFormattedOpFixStringForResults(flowStep2Hidden.Value) : "None";
                temp2 = flowStep2Fixes.Value;
                //temp = temp + temp2 + "<br />" + ((flowStep2Values.Value.Replace("$$$", "<br />")).Replace("BEGINDIVlineBox", "<div class=\"lineBox\">")).Replace("ENDDIV", "</div>") + "<br /><br />";
                temp = temp + temp2 + "<br />" + stringReplacer(flowStep2Values.Value) + "<br /><br />";
            }
            if (hiddenGoal1MOE1All.Value != "")
            {
                temp = temp + "Chosen MOE : " + hiddenGoal1MOE1All.Value + "<br />";
                temp = flowStep3Hidden.Value != "0" ? temp + "Currently : Failing" + "<br />" : temp + "Currently : OK" + "<br />";
                temp = temp + "Value assigned to this MOE : " + hiddenGoal1MOE1AllVal.Value + "<br />";
                temp = temp + "Selected operational fixes for this MOE : " + "<br />";
                //temp2 = flowStep3Hidden.Value != "" ? getFormattedOpFixStringForResults(flowStep3Hidden.Value) : "None";
                temp2 = flowStep3Fixes.Value;
                //temp = temp + temp2 + "<br />" + ((flowStep3Values.Value.Replace("$$$", "<br />")).Replace("BEGINDIVlineBox", "<div class=\"lineBox\">")).Replace("ENDDIV", "</div>") + "<br /><br />";
                temp = temp + temp2 + "<br />" + stringReplacer(flowStep3Values.Value)+ "<br /><br />";
            }
            if (hiddenGoal1MOE2All.Value != "")
            {
                temp = temp + "Chosen MOE : " + hiddenGoal1MOE2All.Value + "<br />";
                temp = flowStep4Hidden.Value != "0" ? temp + "Currently : Failing" + "<br />" : temp + "Currently : OK" + "<br />";
                temp = temp + "Value assigned to this MOE : " + hiddenGoal1MOE2AllVal.Value + "<br />";
                temp = temp + "Selected operational fixes for this MOE : " + "<br />";
                //temp2 = flowStep4Hidden.Value != "" ? getFormattedOpFixStringForResults(flowStep4Hidden.Value) : "None";
                temp2 = flowStep4Fixes.Value;
                //temp = temp + temp2 + "<br />" + ((flowStep4Values.Value.Replace("$$$", "<br />")).Replace("BEGINDIVlineBox", "<div class=\"lineBox\">")).Replace("ENDDIV", "</div>");
                temp = temp + temp2 + "<br />" + stringReplacer(flowStep4Values.Value);
            }
            return temp;
        }
        protected string stringReplacer(string input) {
            
            StringBuilder sb = new StringBuilder(input);
            sb.Replace("$$$", "<br />");
            sb.Replace("BEGINDIVfix", "<div class=\"lineBox\">");
            sb.Replace("BEGINDIVdollar", "<div class=\"highlightChange\">");
            sb.Replace("BEGINDIVvalue", "<div class=\"lineBox1\">");
            sb.Replace("BEGINDIVline1", "<div class=\"line1\">");
            sb.Replace("BEGINDIVline2", "<div class=\"line2\">");
            sb.Replace("ENDDIV", "</div>");
            return sb.ToString();
        }
        protected string getGoal2StringForResults()
        {
            string temp = "";
            string temp2 = "";
            if (hiddenGoal2MOE1Peak.Value != "")
            {
                temp = "Chosen MOE : " + hiddenGoal2MOE1Peak.Value + "<br />";
                temp = flowStep5Hidden.Value != "0" ? temp + "Currently : Failing" + "<br />" : temp + "Currently : OK" + "<br />";
                temp = temp + "Value assigned to this MOE : " + hiddenGoal2MOE1PeakVal.Value + "<br />";
                temp = temp + "Selected operational fixes for this MOE : " + "<br />";
                //temp2 = flowStep5Hidden.Value != "" ? getFormattedOpFixStringForResults(flowStep5Hidden.Value) : "None";
                temp2 = flowStep5Fixes.Value;
                //temp = temp + temp2 + "<br />" + ((flowStep5Values.Value.Replace("$$$", "<br />")).Replace("BEGINDIVlineBox", "<div class=\"lineBox\">")).Replace("ENDDIV", "</div>") + "<br /><br />";
                temp = temp + temp2 + "<br />" + stringReplacer(flowStep5Values.Value) + "<br /><br />";
            }
            if (hiddenGoal2MOE2Peak.Value != "")
            {
                temp = temp + "Chosen MOE : " + hiddenGoal2MOE2Peak.Value + "<br />";
                temp = flowStep6Hidden.Value != "0" ? temp + "Currently : Failing" + "<br />" : temp + "Currently : OK" + "<br />";
                temp = temp + "Value assigned to this MOE : " + hiddenGoal2MOE2PeakVal.Value + "<br />";
                temp = temp + "Selected operational fixes for this MOE : " + "<br />";
                //temp2 = flowStep6Hidden.Value != "" ? getFormattedOpFixStringForResults(flowStep6Hidden.Value) : "None";
                temp2 = flowStep6Fixes.Value;
                //temp = temp + temp2 + "<br />" + ((flowStep6Values.Value.Replace("$$$", "<br />")).Replace("BEGINDIVlineBox", "<div class=\"lineBox\">")).Replace("ENDDIV", "</div>") + "<br /><br />";
                temp = temp + temp2 + "<br />" + stringReplacer(flowStep6Values.Value) + "<br /><br />";
            }
            if (hiddenGoal2MOE1All.Value != "")
            {
                temp = temp + "Chosen MOE : " + hiddenGoal2MOE1All.Value + "<br />";
                temp = flowStep7Hidden.Value != "0" ? temp + "Currently : Failing" + "<br />" : temp + "Currently : OK" + "<br />";
                temp = temp + "Value assigned to this MOE : " + hiddenGoal2MOE1AllVal.Value + "<br />";
                temp = temp + "Selected operational fixes for this MOE : " + "<br />";
                //temp2 = flowStep7Hidden.Value != "" ? getFormattedOpFixStringForResults(flowStep7Hidden.Value) : "None";
                temp2 = flowStep7Fixes.Value;
                //temp = temp + temp2 + "<br />" + ((flowStep7Values.Value.Replace("$$$", "<br />")).Replace("BEGINDIVlineBox", "<div class=\"lineBox\">")).Replace("ENDDIV", "</div>") + "<br /><br />";
                temp = temp + temp2 + "<br />" + stringReplacer(flowStep7Values.Value) + "<br /><br />";
            }
            if (hiddenGoal2MOE2All.Value != "")
            {
                temp = temp + "Chosen MOE : " + hiddenGoal2MOE2All.Value + "<br />";
                temp = flowStep8Hidden.Value != "0" ? temp + "Currently : Failing" + "<br />" : temp + "Currently : OK" + "<br />";
                temp = temp + "Value assigned to this MOE : " + hiddenGoal2MOE2AllVal.Value + "<br />";
                temp = temp + "Selected operational fixes for this MOE : " + "<br />";
                //temp2 = flowStep8Hidden.Value != "" ? getFormattedOpFixStringForResults(flowStep8Hidden.Value) : "None";
                temp2 = flowStep8Fixes.Value;
                //temp = temp + temp2 + "<br />" + ((flowStep8Values.Value.Replace("$$$", "<br />")).Replace("BEGINDIVlineBox", "<div class=\"lineBox\">")).Replace("ENDDIV", "</div>");
                temp = temp + temp2 + "<br />" + stringReplacer(flowStep8Values.Value);
            }
            return temp;
        }
        private string getResultsString()
        {
            string resultsString = "";
            string facilitytype = getSelectedFacility();
            string newfacilityType = checkFacilityType(newFreeID, newTollID, newNAID);
            List<string> opfixcode = returnOpFixStrings();
            List<string> opfixNames = new List<string>();
            List<string>[] temppriorityList = new List<string>[2];
            List<string> removePriority = new List<string> { "0", "-1" };
            string stringtobuild = "";
            //System.Diagnostics.Debug.WriteLine(String.Join(",", removePriority));
            if (facilitytype == "HOV")
            {
                temppriorityList = removePriorityFromList(returnSortedGroupResults(returnFreeGroupResults()), "0");
                for (int i = 0; i < temppriorityList[0].Count(); i++)
                {
                    string vehgroup = returnVehGroupName(int.Parse(temppriorityList[0][i]));
                    stringtobuild = stringtobuild + vehgroup + "<br />";
                    string ranking = temppriorityList[1][i] != "-1" ? "RANKING : " + temppriorityList[1][i] : "RANKING : ";
                    stringtobuild = stringtobuild + ranking + "<br />" + "CURRENTLY FREE : Yes" + "<br /><br />";

                }
                temppriorityList = removeMultiplePrioritiesFromList(returnSortedGroupResults(returnNotAllowedGroupResults()), removePriority);
                if (temppriorityList.Count() > 0)
                {
                    for (int i = 0; i < temppriorityList[0].Count(); i++)
                    {
                        string vehgroup = returnVehGroupName(int.Parse(temppriorityList[0][i]));
                        stringtobuild = stringtobuild + vehgroup + "<br />";
                        string ranking = temppriorityList[1][i] != "-1" ? "RANKING : " + temppriorityList[1][i] : "RANKING : ";
                        stringtobuild = stringtobuild + ranking + "<br /><br />";
                    }
                }

            }
            else if (facilitytype == "HOT")
            {
                temppriorityList = removePriorityFromList(returnSortedGroupResults(returnTolledGroupResults()), "0");
                for (int i = 0; i < temppriorityList[0].Count(); i++)
                {
                    string vehgroup = returnVehGroupName(int.Parse(temppriorityList[0][i]));
                    stringtobuild = stringtobuild + vehgroup + "<br />";
                    string ranking = temppriorityList[1][i] != "-1" ? "RANKING : " + temppriorityList[1][i] : "RANKING : ";
                    stringtobuild = stringtobuild + ranking + "<br />" + "CURRENTLY TOLLED : Yes" + "<br /><br />";

                }
                temppriorityList = removePriorityFromList(returnSortedGroupResults(returnFreeGroupResults()), "0");
                for (int i = 0; i < temppriorityList[0].Count(); i++)
                {
                    string vehgroup = returnVehGroupName(int.Parse(temppriorityList[0][i]));
                    stringtobuild = stringtobuild + vehgroup + "<br />";
                    string ranking = temppriorityList[1][i] != "-1" ? "RANKING : " + temppriorityList[1][i] : "RANKING : ";
                    stringtobuild = stringtobuild + ranking + "<br />" + "CURRENTLY FREE : Yes" + "<br /><br />";

                }
                temppriorityList = removeMultiplePrioritiesFromList(returnSortedGroupResults(returnNotAllowedGroupResults()), removePriority);
                if (temppriorityList.Count() > 0)
                {
                    for (int i = 0; i < temppriorityList[0].Count(); i++)
                    {
                        string vehgroup = returnVehGroupName(int.Parse(temppriorityList[0][i]));
                        stringtobuild = stringtobuild + vehgroup + "<br />";
                        string ranking = temppriorityList[1][i] != "-1" ? "RANKING : " + temppriorityList[1][i] : "RANKING : ";
                        stringtobuild = stringtobuild + ranking + "<br /><br />";
                    }
                }

            }
            else if (facilitytype == "TOLL")
            {
                temppriorityList = removePriorityFromList(returnSortedGroupResults(returnTolledGroupResults()), "0");
                for (int i = 0; i < temppriorityList[0].Count(); i++)
                {
                    string vehgroup = returnVehGroupName(int.Parse(temppriorityList[0][i]));
                    stringtobuild = stringtobuild + vehgroup + "<br />";
                    string ranking = temppriorityList[1][i] != "-1" ? "RANKING : " + temppriorityList[1][i] : "RANKING : ";
                    stringtobuild = stringtobuild + ranking + "<br />" + "CURRENTLY TOLLED : Yes" + "<br /><br />";

                }

                temppriorityList = removeMultiplePrioritiesFromList(returnSortedGroupResults(returnNotAllowedGroupResults()), removePriority);
                if (temppriorityList.Count() > 0)
                {
                    for (int i = 0; i < temppriorityList[0].Count(); i++)
                    {
                        string vehgroup = returnVehGroupName(int.Parse(temppriorityList[0][i]));
                        stringtobuild = stringtobuild + vehgroup + "<br />";
                        string ranking = temppriorityList[1][i] != "-1" ? "RANKING : " + temppriorityList[1][i] : "RANKING : ";
                        stringtobuild = stringtobuild + ranking + "<br /><br />";
                    }
                }
            }
            //System.Diagnostics.Debug.WriteLine(String.Join(",", temppriorityList[0]));
            foreach (String s in opfixcode)
            {
                opfixNames.Add(returnActualOpFixNames(s));
            }
            string summary = "No change in facility type";
            if (facilitytype == newfacilityType)
            {
                summary = "No change in facility type";
            }
            else {
                if(newfacilityType != "No")
                summary = "Change facility type from " + facilitytype + " to " + newfacilityType;
            }
            resultsString = "Current Facility Type : " + getSelectedFacility() + "<br /><br />" +
                            "Summary : " +summary+ "<br /><br />" +
                            getGoalsStringForResults() + "<br /><br />" +
                            "Operational fixes selected for this framework : " + "<br /><br />" +
                            String.Join("<br />", opfixNames) + "<br /><br />" + "User group designations for this framework : <br /><br /><h4>Original Input</h4><br />" + buildTableForVehGroups("orig")+"<br /><h4>Processed List</h4><br />"+buildTableForVehGroups("new");

            return resultsString;

        }
        protected string getFileName()
        {
            string answer = "";
            answer = getSelectedFacility() + "_" + DateTime.Now.ToString();
            return answer;
        }
        //Returns goal number 1 or 2 based on current step index of the flowstep
        protected int returnGoalNoForFlowStep() {
            string step = Wizard1.ActiveStep.ID;
            int temp = 0;
            if (step == "flowStep1" || step == "flowStep2" || step == "flowStep3" || step == "flowStep4") {
                temp = 1;
            }
            else if (step == "flowStep5" || step == "flowStep6" || step == "flowStep7" || step == "flowStep8") {
                temp = 2;
            }
            return temp;
        }
        /*Returns a code for a particular goal, this will be used to determine the list of vehicle groups question to ask for
         *that OP fix. The reason three of the cases have the same return values is that in ST,HT & RT we would process the same
         *list of vehicles and no variation between these three.
         */
        protected string returnCodeForGoal(string input) {
            string result = "";
            switch(input){
                case "Safe Travel":
                    result = "1";
                    break;
                case "High-speed Travel":
                    result = "1";
                    break;
                case "Reliable Travel":
                    result = "1";
                    break;
                case "Optimize Revenue":
                    result = "2";
                    break;
                case "Optimize Throughput":
                    result = "3";
                    break;
            }
            return result;
        }
        /*
         *Returns a combined code for the goal and facility type which will be used to form the vehicle priority for questions
         *on flowstep groups. We used facilityType hiddenfield to get the facility type since the type of facility can change
         *from flow step to flow step depending upon the selections in the previous step. E.g. if a pricing fix is selected, you may 
         *start charging vehicles which will make an HOV facility an HOT and that will change the veh groups calculated.
         */
        protected string returnCodeForFlowStep(string input) {
            string result = "";
            switch (facilityType.Value.ToString()) {
                case "HOV":
                    result = "0" + returnCodeForGoal(input);
                    break;
                case "HOT":
                    result = "1" + returnCodeForGoal(input);
                    break;
                case "TOLL":
                    result = "2" + returnCodeForGoal(input);
                    break;
            }
            return result;
        }
        /* uses the returnCodeForFlowStep function to generate final code if the op fix being processed is pricing .. so suppose
         * the facility type is HOV ... the goal is safe travel and the op fix is pricing , this function is supposed to return 
         * '011' .
         */
        protected string returnFinalCodeForFlowStepPricing() {
            string temp = returnCodeForFlowStep(returnInputString());
            temp = temp + "1";
            return temp;
        }
        /* similar to returnFinalCodeForFlowStepPricing() but this generates the code if the op fix being processing is user groups
         */
        protected string returnFinalCodeForFlowStepUGroups()
        {
            string temp = returnCodeForFlowStep(returnInputString());
            temp = temp + "2";
            return temp;
        }
        /*returns the name of the goal based on values stored in the hiddenfields hiddenGoal1 and hiddenGoal2
         * the value stored are 1 to 5 where 1 is "Safe Travel" etc. returnGoalNoForFlowStep() returns a 1 or a 2 based
         * on the current flow step the user is on 
         */
        protected string returnInputString() {
            int temp = returnGoalNoForFlowStep();
            string result = "";
            switch(temp){
                case 1:
                    result = returnGoalNames(int.Parse(hiddenGoal1.Value));
                    break;
                case 2:
                    result = returnGoalNames(int.Parse(hiddenGoal2.Value));
                    break;
            }
            return result;    
        
        }
        /* Converts hiddenfield values as a List of strings 
         */
        protected List<string> convertHiddenfieldToList(HiddenField input) {
            List<string> result = new List<string>();
            result = input.Value.Split(',').ToList();
            return result;
        }
        /* returns the list of veh groups to process.. this will be used to display relevent questions related to 
         * pricing and ugroups op fixes. 
         */
        protected List<string>[] getListToProcess(string code,string hfieldtype) {
            HiddenField FreeRank = (HiddenField)Page.FindControl(hfieldtype + "FreeRank");
            HiddenField FreeID = (HiddenField)Page.FindControl(hfieldtype + "FreeID");
            HiddenField NARank = (HiddenField)Page.FindControl(hfieldtype + "NARank");
            HiddenField NAID = (HiddenField)Page.FindControl(hfieldtype + "NAID");
            HiddenField TollRank = (HiddenField)Page.FindControl(hfieldtype + "TollRank");
            HiddenField TollID = (HiddenField)Page.FindControl(hfieldtype + "TollID");
            List<string>[] ans = new List<string>[2];
            switch (code) {
                case "012":
                    ans = orderedByLowestRank(FreeRank,FreeID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "1");
                    break;
                case "011":
                    ans = orderedByLowestRank(FreeRank,FreeID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "1");
                    break;
                case "022":
                    ans = orderedByHighestRank(NARank,NAID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "2");
                    break;
                case "021":
                    ans = orderedByLowestRank(FreeRank,FreeID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "1");
                    break;
                case "032":
                    ans = orderedByHighestRank(NARank,NAID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "2");
                    break;
                case "031":
                    ans = orderedByLowestRank(FreeRank,FreeID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "1");
                    break;
                case "112":
                    List<string>[] ans1 = new List<string>[2];
                    List<string>[] ans2 = new List<string>[2];
                    ans1 = orderedByLowestRank(TollRank, TollID);
                    ans1[1] = addVehGroupCodetoListElement(ans1[1], "0");
                    ans2=orderedByLowestRank(FreeRank,FreeID);
                    ans2[1] = addVehGroupCodetoListElement(ans2[1], "1");
                    ans1[0].AddRange(ans2[0]);
                    ans1[1].AddRange(ans2[1]);
                    ans = ans1;
                    break;
                case "111":
                    List<string>[] ans3 = new List<string>[2];
                    List<string>[] ans4 = new List<string>[2];
                    ans3 = orderedByLowestRank(TollRank, TollID);
                    ans3[1] = addVehGroupCodetoListElement(ans3[1], "0");
                    ans4=orderedByLowestRank(FreeRank,FreeID);
                    ans4[1] = addVehGroupCodetoListElement(ans4[1], "1");
                    ans3[0].AddRange(ans4[0]);
                    ans3[1].AddRange(ans4[1]);
                    ans = ans3;
                    break;
                case "122":
                    ans = orderedByHighestRank(NARank,NAID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "2");
                    break;
                case "121":
                    ans = orderedByLowestRank(FreeRank,FreeID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "1");
                    break;
                case "132":
                    ans = orderedByHighestRank(NARank,NAID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "2");
                    break;
                case "131":
                    ans = orderedByHighestRank(TollRank,TollID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "0");
                    break;
                case "212":
                    ans = orderedByLowestRank(TollRank,TollID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "0");
                    break;
                case "211":
                    ans = orderedByLowestRank(TollRank,TollID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "0");
                    break;
                case "222":
                    ans = orderedByHighestRank(NARank,NAID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "2");
                    break;
                case "221":
                    ans = orderedByLowestRank(TollRank,TollID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "0");
                    break;
                case "232":
                    ans = orderedByHighestRank(NARank,NAID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "2");
                    break;
                case "231":
                    ans = orderedByHighestRank(TollRank,TollID);
                    ans[1] = addVehGroupCodetoListElement(ans[1], "0");
                    break;
            
            }
            return ans;
        }
        protected List<string> addVehGroupCodetoListElement(List<string> input, string vehGroupCode) {
            List<string> ans = new List<string>();
            foreach (string s in input) {
                if (s.Contains('$'))
                {
                    List<string> temp = new List<string>();
                    temp = s.Split('$').ToList();
                    List<string> newList = new List<string>();
                    foreach (string s1 in temp) {
                        newList.Add(s1 + "-" + vehGroupCode);
                    }
                    ans.Add(String.Join("$", newList));
                }
                else {
                    ans.Add(s + "-" + vehGroupCode);
                
                }
            }
            return ans;
        }
        
        /* return the list with lowest priority first .. the list is a two dimensional list with 
         * 0 index list stores priorities and 1 index list stores the actual veh groups
         */
        protected List<string>[] orderedByLowestRank(HiddenField priority, HiddenField veh) {
        List<string>[] temp = new List<string>[2];
        temp[0] = priority.Value.Split(',').ToList();
        temp[1] = veh.Value.Split(',').ToList();
        List<string> uniqueValues = returnUniqueValuesList(temp[0]);
        uniqueValues.Reverse();
        List<string>[] ans = new List<string>[2];
        ans[0] = new List<string>();
        ans[1] = new List<string>();
        foreach (string s in uniqueValues) {
            List<string> temp2 = new List<string>();
            for (int i = 0; i < temp[0].Count(); i++) {
                if (temp[0][i] == s) {
                    temp2.Add(temp[1][i]);
                }
            
            }
            ans[0].Add(s);
            ans[1].Add(String.Join("$", temp2));
        }
      
        return ans;
        }
        /* return the list with highest priority first .. the list is a two dimensional list with 
         * 0 index list stores priorities and 1 index list stores the actual veh groups
         */
        protected List<string>[] orderedByHighestRank(HiddenField priority, HiddenField veh)
        {
            List<string>[] temp = new List<string>[2];
            temp[0] = priority.Value.Split(',').ToList();
            temp[1] = veh.Value.Split(',').ToList();
            List<string> uniqueValues = returnUniqueValuesList(temp[0]);
            
            List<string>[] ans = new List<string>[2];
            ans[0] = new List<string>();
            ans[1] = new List<string>();
            foreach (string s in uniqueValues)
            {
                List<string> temp2 = new List<string>();
                for (int i = 0; i < temp[0].Count(); i++)
                {
                    if (temp[0][i] == s)
                    {
                        temp2.Add(temp[1][i]);
                    }

                }
                ans[0].Add(s);
                ans[1].Add(String.Join("$", temp2));
            }

            return ans;
        }
        /* Count number of items in a string with comma separated values ...
         */
        protected int getNumberOfItemsInList(string input) {
            List<string> ans = new List<string>();
            ans = input.Split(',').ToList();
            return ans.Count();
        }
        /* Returns the question string for different cases with _Blank_ placeholder which will
         * be replaced by the veh group string using a different function
         * The function has vehGroupCode as second argument which will decide what type of question will be returned
         * Most of the cases this doesn't matter but for case 111 and case 112
         */
        protected string getQuestionString(string casecode,string vehGroupCode) {
            string ans = "";
            switch (casecode) {
                case "012":
                    ans = "Exclude _Blank_ ?";
                    break;
                case "011":
                    ans = "Begin tolling _Blank_ ?";
                    break;
                case "022":
                    ans = "Allow _Blank_ for a toll ?";
                    break;
                case "021":
                    ans = "Start charging _Blank_ ?";
                    break;
                case "032":
                    ans = "Allow _Blank_ ?";
                    break;
                case "031":
                    ans = "Start charging _Blank_ ?";
                    break;
                case "112":
                    ans = "Exclude _Blank_ ?";
                    break;
                case "111":
                    if (vehGroupCode == "0")
                    {
                        ans = "Increase the toll for _Blank_ ?";
                        break;
                    }
                    else {
                        ans = "Start tolling _Blank_ ?";
                        break;
                    }
                case "122":
                    ans = "Allow _Blank_ for a toll ?";
                    break;
                case "121":
                    ans = "Start charging _Blank_ ?";
                    break;
                case "132":
                    ans = "Allow _Blank_ for a toll ?";
                    break;
                case "131":
                    ans = "Stop charging _Blank_ ?";
                    break;
                case "212":
                    ans = "Exclude _Blank_ ?";
                    break;
                case "211":
                    ans = "Increase the toll for _Blank_ ?";
                    break;
                case "222":
                    ans = "Allow _Blank_ for a toll ?";
                    break;
                case "221":
                    ans = "Raise toll for _Blank_ ?";
                    break;
                case "232":
                    ans = "Allow _Blank_ for a toll ?";
                    break;
                case "231":
                    ans = "Stop charging _Blank_ ?";
                    break;
                      
            }
            return ans;
        
        }
        /* This function returns the new veh group code based on the case code ...
         * this helps determine if the veh group is changed from free to toll or
         * from toll to free etc ...0 = tolled, 1= free, 2 = not allowed
         * so if we are excluding it will change there code to 2
         */
        protected string getNewVehGroupCode(string casecode, string vehGroupCode)
        {
            string ans = "";
            switch (casecode)
            {
                case "012":
                    ans = "2";
                    break;
                case "011":
                    ans = "0";
                    break;
                case "022":
                    ans = "0";
                    break;
                case "021":
                    ans = "0";
                    break;
                case "032":
                    ans = "1";
                    break;
                case "031":
                    ans = "0";
                    break;
                case "112":
                    ans = "2";
                    break;
                case "111":
                    if (vehGroupCode == "0")
                    {
                        ans = "0";
                        break;
                    }
                    else
                    {
                        ans = "0";
                        break;
                    }
                case "122":
                    ans = "0";
                    break;
                case "121":
                    ans = "0";
                    break;
                case "132":
                    ans = "0";
                    break;
                case "131":
                    ans = "1";
                    break;
                case "212":
                    ans = "2";
                    break;
                case "211":
                    ans = "0";
                    break;
                case "222":
                    ans = "0";
                    break;
                case "221":
                    ans = "0";
                    break;
                case "232":
                    ans = "0";
                    break;
                case "231":
                    ans = "1";
                    break;

            }
            return ans;

        }
        /*Substitute the _Blank_ placeholder with the supplied string
         */
        protected string getCompletedString(string input, string substitute) {
            string ans = "";
            ans = input.Replace("_Blank_", substitute);
            return ans;
        }
        /* Save the values submitted through the Operational fixes in a text file which can be loaded through
         * the first screen so that the user don't have to re-input all the values in future.
         */
        protected void writeProjectInputFile() {
            
            string temp = "";
            string temp1 = "";
            temp1 = name.Text != "" ? name.Text : "-1";
            temp = temp1+"\n";
            temp1 = road.Text != "" ? road.Text : "-1";
            temp = temp + temp1+"\n";
            temp = temp + facility.SelectedValue + "\n"; // mandatory field so no need to check if empty
            /* If Safe Travel goal is checked */
           
            temp1 = st.Checked == true? "ST" : "-1";
            temp = temp + temp1 + "\n";
            
            //If ST is not checked fill in the next four lines with just one dash (-)

            if (temp1 == "-1")
            {
                for (int index = 0; index < 4; index++)
                {
                    temp = temp + "-" + "\n";
                }
            }
            else {
                temp = temp + buildStringForMOEInput("ST", safeTravelStep);
            
            }

            /* If High-speed Travel goal is checked */

            temp1 = ht.Checked == true ? "HT" : "-1";
            temp = temp + temp1 + "\n";

            if (temp1 == "-1")
            {
                for (int index = 0; index < 4; index++)
                {
                    temp = temp + "-" + "\n";
                }
            }
            else
            {
                temp = temp + buildStringForMOEInput("HT", highspeedTravelStep);

            }
            /* If Reliablt Travel goal is checked */

            temp1 = rt.Checked == true ? "RT" : "-1";
            temp = temp + temp1 + "\n";

            if (temp1 == "-1")
            {
                for (int index = 0; index < 4; index++)
                {
                    temp = temp + "-" + "\n";
                }
            }
            else
            {
                temp = temp + buildStringForMOEInput("RT", reliableTravelStep);

            }
            /* If Optimize Revenue Travel goal is checked */

            temp1 = or.Checked == true ? "OR" : "-1";
            temp = temp + temp1 + "\n";

            if (temp1 == "-1")
            {
                for (int index = 0; index < 4; index++)
                {
                    temp = temp + "-" + "\n";
                }
            }
            else
            {
                temp = temp + buildStringForMOEInput("OR", optimizeRevenueStep);

            }
            /* If Optimize Throughput goal is checked */

            temp1 = ot.Checked == true ? "OT" : "-1";
            temp = temp + temp1 + "\n";

            if (temp1 == "-1")
            {
                for (int index = 0; index < 4; index++)
                {
                    temp = temp + "-" + "\n";
                }
            }
            else
            {
                temp = temp + buildStringForMOEInput("OT", optimizeThroughputStep);

            }
            
            /* Processing Input for the veh group ranking step */

            temp = temp + transitpriority.SelectedValue + "$" + transitStatus.SelectedValue + "\n";
            temp = temp + vanpoolspriority.SelectedValue + "$" + vanpoolsStatus.SelectedValue + "\n";
            temp = temp + otherbusespriority.SelectedValue + "$" + otherbusesStatus.SelectedValue + "\n";
            temp = temp + hov3priority.SelectedValue + "$" + hov3Status.SelectedValue + "\n";
            temp = temp + hov2priority.SelectedValue + "$" + hov2Status.SelectedValue + "\n";
            temp = temp + sovpriority.SelectedValue + "$" + sovStatus.SelectedValue + "\n";
            temp = temp + lowempriority.SelectedValue + "$" + lowemStatus.SelectedValue + "\n";
            temp = temp + fuelvehpriority.SelectedValue + "$" + fuelvehStatus.SelectedValue + "\n";
            temp = temp + motorcyclepriority.SelectedValue + "$" + motorcycleStatus.SelectedValue + "\n";
            temp = temp + ondutypriority.SelectedValue + "$" + ondutyStatus.SelectedValue + "\n";
            temp = temp + offdutypriority.SelectedValue + "$" + offdutyStatus.SelectedValue + "\n";
            temp = temp + agencyvehpriority.SelectedValue + "$" + agencyvehStatus.SelectedValue + "\n";
            temp = temp + lowincomepriority.SelectedValue + "$" + lowincomeStatus.SelectedValue + "\n";
            temp = temp + truckspriority.SelectedValue + "$" + trucksStatus.SelectedValue + "\n";

            //Processing input for the opfixes page 

            temp1 = opfixpricing.Checked == true ? "1" : "-1";
            temp = temp + temp1 + "\n";

            temp1 = opfixusergroups.Checked == true ? "1" : "-1";
            temp = temp + temp1 + "\n";

            temp1 = opfixenforcement.Checked == true ? "1" : "-1";
            temp = temp + temp1 + "\n";

            temp1 =  opfixshoulderhours.Checked == true ? "1" : "-1";
            temp = temp + temp1 + "\n";

            temp1 = opfixincidentremove.Checked == true ? "1" : "-1";
            temp = temp + temp1 + "\n";

            temp1 = opfixtrafficman.Checked == true ? "1" : "-1";
            temp = temp + temp1 + "\n";

            temp1 = opfixrampmetering.Checked == true ? "1" : "-1";
            temp = temp + temp1 + "\n";

            temp1 = opfiximprovedesign.Checked == true ? "1" : "-1";
            temp = temp + temp1 + "\n";

            temp1 = opfixpublicity.Checked == true ? "1" : "-1";
            temp = temp + temp1 + "\n";

            temp1 = opfixothers1.Text != "" ? opfixothers1.Text : "-1";
            temp = temp + temp1 + "\n";

            temp1 = opfixothers2.Text != "" ? opfixothers2.Text : "-1";
            temp = temp + temp1;


            StringWriter strWriter = new StringWriter();
            strWriter.Write(temp);
            Response.ContentType = "text/plain";
            Response.AddHeader("content-disposition", "attachment;filename=" + getFileNameForInput()+".txt");
            Response.Clear();
            Response.ClearContent();
            using (StreamWriter writer = new StreamWriter(Response.OutputStream))
            {
                writer.Write(strWriter.ToString());
                
            }
            Response.Flush();
            Response.Close();

            
        }
        protected string buildStringForMOEInput(string input,WizardStep step) {
            string ans = "",ans1="";
            CheckBox moe1A = (CheckBox)step.FindControl(input + "MOE1A");
            TextBox moe1AText = (TextBox)step.FindControl(moe1A.ID + "Text");
            CheckBox moe1B = (CheckBox)step.FindControl(input + "MOE1B");
            TextBox moe1BText = (TextBox)step.FindControl(moe1B.ID + "Text");
            CheckBox moe2A = (CheckBox)step.FindControl(input + "MOE2A");
            TextBox moe2AText = (TextBox)step.FindControl(moe2A.ID + "Text");
            CheckBox moe2B = (CheckBox)step.FindControl(input + "MOE2B");
            TextBox moe2BText = (TextBox)step.FindControl(moe2B.ID + "Text");
            ans1 = moe1A.Checked == true ? "1$" + moe1AText.Text : "-1";
            ans = ans1 + "\n";
            ans1 = moe1B.Checked == true ? "1$" + moe1BText.Text : "-1";
            ans = ans+ans1 + "\n";
            ans1 = moe2A.Checked == true ? "1$" + moe2AText.Text : "-1";
            ans = ans+ans1 + "\n";
            ans1 = moe2B.Checked == true ? "1$" + moe2BText.Text : "-1";
            ans = ans+ans1 + "\n";
            return ans;

        }
        protected string getFileNameForInput() {
            string ans="";
            if (road.Text != "")
                ans = road.Text + "_";
            ans = ans + getSelectedFacility() + "_";
            ans = ans + System.DateTime.Now.ToString("MMddyy_hhmmtt");
            
            return ans;
        }
        protected void SaveProject_Click(object sender, EventArgs e)
        {
            writeProjectInputFile();
        }
        /* This function stores the values of opfixes in the hiddefield opfixesinorder with the UGroups
         * op fix as first followed by pricing and then the rest of the fixes
         */
        protected void storeValuesInOrderOpFixes() {
            List<string> temp = new List<string>();
            if (opfixusergroups.Checked == true) {
                temp.Add("UGroups");
            }
            if (opfixpricing.Checked == true) {
                temp.Add("Pricing");
            }
            if (opfixenforcement.Checked == true) {
                temp.Add("Enforcement");
            }
            if (opfixshoulderhours.Checked == true) {
                temp.Add("SHours");
            }
            if (opfixincidentremove.Checked == true) {
                temp.Add("IRemoval");
            }
            if (opfixtrafficman.Checked == true) {
                temp.Add("Traffic");
            }
            if (opfixrampmetering.Checked == true) {
                temp.Add("Ramp");
            }
            if (opfiximprovedesign.Checked == true) {
                temp.Add("Design");
            }
            if (opfixpublicity.Checked == true) {
                temp.Add("Publicity");
            }
            if (opfixothers1.Text != "") {
                temp.Add("Others1");
            }
            if (opfixothers2.Text != "") {
                temp.Add("Others2");
            }
            opfixesinorder.Value = String.Join(",", temp);
            
        }
        /*This function returns the next opfix string to be processed... if there is no
         * next op fix, it returns the string "-1" ...This function processes the list of values
         * stored in the opfixesinorder hiddenfield
         */
        protected string returnNextFromOpFixInOrder(string input) {
            List<string> temp = opfixesinorder.Value.Split(',').ToList();
            if (temp.Exists(s => s == input))
            {
                int index = temp.FindIndex(s => s == input);
                if (temp.Count == index + 1)
                {
                    return "-1";
                }
                else
                {
                    return temp[index + 1];
                }

            }
            else {
                return "-1";
            }
        }
        /* This function returns the veh group code which is stored with veh group seperated by "-"
         * the vehGroupCode will be 0,1 or 2 with 0 - tolled, 1 - free and 2 - not allowed
         */
        protected string getVehGroupCode(List<string> element)
        {
            
            
            
            
            if (element.Count() != 0)
            {
                List<string> split = element[0].Split('-').ToList();
                return split[1];
            }
            else
            {
                return "-1";
            }

            /*List<string> tempList = vehGroupsList.Value.Split(',').ToList();
            int indexInt = int.Parse(index);

            string ans = "";
            if (indexInt < tempList.Count())
            {
                string inputStr = tempList[indexInt];
                if (inputStr.Contains('$'))
                {
                    List<string> temp = new List<string>();
                    temp = inputStr.Split('$').ToList();
                    List<string> temp1 = new List<string>();
                    temp1 = temp[0].Split('-').ToList();
                    ans = temp1[1];

                }
                else
                {
                    List<string> temp = new List<string>();
                    temp = inputStr.Split('-').ToList();
                    ans = temp[1];
                }
            }
            else
            {
                ans = "-1";
            }
            return ans;*/
        }
        /* This function returns the name of the veh groups based on the index stored in the 
         * vehgroupslist hiddenfield.. if there are multiple veh groups with the same priority
         * they are separted by "$" which is why this function checks if the string contains "$" and
         * breaks down if it does... the input to this function is a string 
         * The values for the vehicles also contains "-" which seperates vehicle codes and the type of
         * veh groups ... 0 currently tolled 1= currently free 2= currently not allowed
         * 
         */
        protected string returnStrForVehGroupsList(List<string> element,string casecode) {
            
            List<string> temp = new List<string>();
            
            
            if (element.Count != 0)
            {
                foreach (string s in element) {
                    List<string> split = s.Split('-').ToList();
                    //temp.Add(returnVehGroupName(int.Parse(split[0])));
                    temp.Add(returnVehGroupNameForFixes(int.Parse(split[0]),casecode));
                }
                return String.Join(",", temp);
            }
            else {
                return "-1";
            }
            /*List<string> temp = vehGroupsList.Value.Split(',').ToList();
            int index = int.Parse(input);
            if (index < temp.Count())
            {
                string tempStr = temp[index];
                if (tempStr.Contains('$'))
                {
                    List<string> temp2 = tempStr.Split('$').ToList();
                    List<string> ans = new List<string>();
                    foreach (string s in temp2) {
                        List<string> split = s.Split('-').ToList();
                        ans.Add(returnVehGroupName(int.Parse(split[0])));
                    }
                    return String.Join(",", ans);
                }
                else {
                    List<string> split = tempStr.Split('-').ToList();
                    return returnVehGroupName(int.Parse(split[0]));
                
                }

            }
            else {
                return "-1";
            }*/
        }
        /* This function returns the specified element from the vehGroupsList as a List of Strings ...
         * if the element at that position has a "$" in it it will return the list with two elements in it
         */
        protected List<string> returnElementFromVehGroupsList(int index) {
            List<string> temp = vehGroupsList.Value.Split(',').ToList();
            List<string> ans = new List<string>();
            if (index < temp.Count())
            {
                string tempStr = temp[index];
                if (tempStr.Contains('$'))
                {
                    List<string> temp2 = tempStr.Split('$').ToList();
                    foreach (string s in temp2)
                        ans.Add(s);
                }
                else {
                    ans.Add(tempStr);
                }
            }
            return ans;
        
        }
        /* This function is called from the start opfix questions function.. uses the opfix string as input such
         * as "Enforcement","SHours" etc except "UGroups" and "Pricing" which are complex fixes
         */
        protected void makeOpFixLabelVisible(string opfixstr) {
            String idstring = Wizard1.ActiveStep.ID.ToString();
            Label tempLabel;
            RadioButtonList tempRadio;
            tempLabel = (Label)Wizard1.ActiveStep.FindControl(idstring + opfixstr);
            tempLabel.Text = "Use " + returnActualOpFixNames(opfixstr) + " to address this MOE ?";
            tempRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(tempLabel.ID + "Radio");
            tempLabel.Visible = true;
            tempRadio.Visible = true;
        
        }
        /* This function makes the "Did it fix the problem " label and corresponding radio button visible
         * This can be called for any op fix and takes the op fix string such as "Enforcement" etc... for "UGroups"
         * and "Pricing" fixes you would have to input "UGroups0","UGroups1" etc strings
         */
        protected void makeDidItFixLabelVisible(string opfixstr) {
            String idstring = Wizard1.ActiveStep.ID.ToString();
            Label tempLabel;
            RadioButtonList tempRadio;
            tempLabel = (Label)Wizard1.ActiveStep.FindControl(idstring + opfixstr+"Fix");
            tempLabel.Text = "Did this fix the problem ?";
            tempRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(tempLabel.ID + "Radio");
            tempLabel.Visible = true;
            tempRadio.Visible = true;
        
        }
        /* This function is called when the apply enforcement for this MOE question is answered in either yes
         * or no...
         * If yes, it makes the did it fix the problem visible ... if no then it clears any question below the
         * enforcement question.. it also calls the nextopfix question..
         */
        protected void flowChartEnforcement_SelectedIndexChanged(object sender, EventArgs e) {
            flowChartOpFixesCommon(sender, e, "Enforcement");
            
        }
        /* This function deals with displaying the did it fix related to Enforcement question
         */
        protected void flowChartEnforcementFix_SelectedIndexChanged(object sender, EventArgs e) {
            flowChartDidItFixCommon(sender, e, "Enforcement");
        }
        /* Similar to flowChartEnforcement_SelectedIndexChanged 
         * but for Shoulder Hours Opfix .. the function below it deals with displaying
         * did it fix question related to shoulder hours
         */
        protected void flowChartSHours_SelectedIndexChanged(object sender, EventArgs e) {
            flowChartOpFixesCommon(sender, e, "SHours");
        }
        protected void flowChartSHoursFix_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartDidItFixCommon(sender, e, "SHours");
        }
        /* Similar to flowChartEnforcement_SelectedIndexChanged
         * and flowChartEnforcementFix_SelectedIndexChanged
         */
        protected void flowChartIRemoval_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartOpFixesCommon(sender, e, "IRemoval");
        }
        protected void flowChartIRemovalFix_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartDidItFixCommon(sender, e, "IRemoval");
        }
        /* Similar to flowChartEnforcement_SelectedIndexChanged 
         * and flowChartEnforcementFix_SelectedIndexChanged
         */
        protected void flowChartTraffic_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartOpFixesCommon(sender, e, "Traffic");
        }
        protected void flowChartTrafficFix_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartDidItFixCommon(sender, e, "Traffic");
        }
        /* Similar to flowChartEnforcement_SelectedIndexChanged 
         * and flowChartEnforcementFix_SelectedIndexChanged
         */
        protected void flowChartRamp_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartOpFixesCommon(sender, e, "Ramp");
        }
        protected void flowChartRampFix_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartDidItFixCommon(sender, e, "Ramp");
        }
        /* Similar to flowChartEnforcement_SelectedIndexChanged 
         * and flowChartEnforcementFix_SelectedIndexChanged
         */
        protected void flowChartDesign_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartOpFixesCommon(sender, e, "Design");
        }
        protected void flowChartDesignFix_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartDidItFixCommon(sender, e, "Design");
        }
        /* Similar to flowChartEnforcement_SelectedIndexChanged 
         * and flowChartEnforcementFix_SelectedIndexChanged
         */
        protected void flowChartPublicity_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartOpFixesCommon(sender, e, "Publicity");
        }
        protected void flowChartPublicityFix_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartDidItFixCommon(sender, e, "Publicity");
        }
        /* Similar to flowChartEnforcement_SelectedIndexChanged 
         * and flowChartEnforcementFix_SelectedIndexChanged
         */
        protected void flowChartOthers1_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartOpFixesCommon(sender, e, "Others1");
        }
        protected void flowChartOthers1Fix_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartDidItFixCommon(sender, e, "Others1");
        }
        /* Similar to flowChartEnforcement_SelectedIndexChanged 
         * and flowChartEnforcementFix_SelectedIndexChanged
         */
        protected void flowChartOthers2_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartOpFixesCommon(sender, e, "Others2");
        }
        protected void flowChartOthers2Fix_SelectedIndexChanged(object sender, EventArgs e)
        {
            flowChartDidItFixCommon(sender, e, "Others2");
        }
        /* This function displays the apply this op fix question... It will be called from functions like flowChartEnforcement_SelectedIndexChanged
         * where the object,EventArgs and string input parameter comes from... the object will contain the information about the yes and no button clicked
         * The string will be "Enforcement","SHours" etc... 
         * This function does not apply to the UGroups and Pricing Fixes
         */
        protected void flowChartOpFixesCommon(object sender, EventArgs e, string opfixstr) {
            RadioButtonList temp = (RadioButtonList)sender;
            temp.Enabled = false;

            if (temp.SelectedValue == "Yes")
            {
                makeDidItFixLabelVisible(opfixstr);
            }
            else
            {
                Label tempLabel;
                tempLabel = (Label)Wizard1.ActiveStep.FindControl(temp.ID.Replace("Radio", "") + "Fix");
                tempLabel.Visible = false;
                RadioButtonList tempRadio;
                tempRadio = (RadioButtonList)Wizard1.ActiveStep.FindControl(tempLabel.ID + "Radio");
                tempRadio.ClearSelection();
                tempRadio.Visible = false;
                string result = returnNextFromOpFixInOrder(opfixstr);
                if (result != "-1")
                {
                    hideOpFixQuestions(result);
                    makeOpFixLabelVisible(result);
                    System.Diagnostics.Debug.WriteLine(result);
                }

            }
        
        }
        /* This function displays the did it fix the problem question for all OP fixes except Pricing and UGroups
         * the returnNextFromOpFixInOrder returns -1 if there are not other op fixes available if not it
         * returns the string with next op fix name which will be used to hide the rest of the op fix questions
         */
        protected void flowChartDidItFixCommon(object sender, EventArgs e, string opfixstr)
        {
            RadioButtonList temp = (RadioButtonList)sender;
            temp.Enabled = false;
            if (temp.SelectedValue == "Yes")
            {
                string result = returnNextFromOpFixInOrder(opfixstr);
                if (result != "-1")
                {
                    hideOpFixQuestions(result);
                    
                }

            }
            else {
                string result = returnNextFromOpFixInOrder(opfixstr);
                if (result != "-1")
                {
                    makeOpFixLabelVisible(result);
                }
            
            }
        }
        /* This function is called when user clicks on openProject button which reads the selected file
         * from Browse button. This function checks if the user has selected the file or not. It also 
         * checks if the number of lines in file is 53. If more or less than 53 it doesn't do anything
         */
        protected void openProject_Click(object sender, EventArgs e){
            
            List<string> allLines = new List<string>();
            //System.Diagnostics.Debug.WriteLine("Entered");
            if (OpenFile.HasFile)
            {
                
                Stream fileStream = OpenFile.PostedFile.InputStream;
                
                using (StreamReader sr = new StreamReader(fileStream))
                {
                    
                    string line;
                    
                    while ((line = sr.ReadLine()) != null)
                    {
                            allLines.Add(line);

                    }
                    if (allLines.Count() == 53) {
                        readProjectInputFile(allLines);
                    
                    }
                }
            }
           
        }
        /* Read Project Input File and process all the input values... the parameter
         * passed to this function is a List<string> so it's easier to process... total 
         * number of lines has to be 53 which is checked before calling this function
         */
        protected void readProjectInputFile(List<string> inputList) {
            name.Text = inputList[0] != "-1" ? inputList[0] : "";
            road.Text = inputList[1] != "-1" ? inputList[1] : "";
            facility.SelectedValue = inputList[2];
            updateFacilityLabel();
            hiddenGoal1.Value = "-1";
            hiddenGoal2.Value = "-1";
            hiddenGoalCount.Value = "-1";
            st.Checked = inputList[3] == "ST" ? true : false;
            if (st.Checked)
            {
                STCheckedUpdate();
                processMOEFromInputFile(inputList, "ST", 3);
            }
            ht.Checked = inputList[8] == "HT" ? true : false;
            if (ht.Checked)
            {
                HTCheckedUpdate();
                processMOEFromInputFile(inputList, "HT", 8);
            }
            rt.Checked = inputList[13] == "RT" ? true : false;
            if (rt.Checked)
            {
                RTCheckedUpdate();
                processMOEFromInputFile(inputList, "RT", 13);
            }
            or.Checked = inputList[18] == "OR" ? true : false;
            if (or.Checked)
            {
                ORCheckedUpdate();
                processMOEFromInputFile(inputList, "OR", 18);
            }
            ot.Checked = inputList[23] == "OT" ? true : false;
            if (ot.Checked)
            {
                OTCheckedUpdate();
                processMOEFromInputFile(inputList, "OT", 23);
            }
            
            
            
            
            
            //Start processing vehicle group ranking

            string[] tempArray = inputList[28].Split('$');
            transitpriority.SelectedValue = tempArray[0];
            transitStatus.SelectedValue = tempArray[1];

            tempArray = inputList[29].Split('$');
            vanpoolspriority.SelectedValue = tempArray[0];
            vanpoolsStatus.SelectedValue = tempArray[1];

            tempArray = inputList[30].Split('$');
            otherbusespriority.SelectedValue = tempArray[0];
            otherbusesStatus.SelectedValue = tempArray[1];

            tempArray = inputList[31].Split('$');
            hov3priority.SelectedValue = tempArray[0];
            hov3Status.SelectedValue = tempArray[1];

            tempArray = inputList[32].Split('$');
            hov2priority.SelectedValue = tempArray[0];
            hov2Status.SelectedValue = tempArray[1];

            tempArray = inputList[33].Split('$');
            sovpriority.SelectedValue = tempArray[0];
            sovStatus.SelectedValue = tempArray[1];

            tempArray = inputList[34].Split('$');
            lowempriority.SelectedValue = tempArray[0];
            lowemStatus.SelectedValue = tempArray[1];

            tempArray = inputList[35].Split('$');
            fuelvehpriority.SelectedValue = tempArray[0];
            fuelvehStatus.SelectedValue = tempArray[1];

            tempArray = inputList[36].Split('$');
            motorcyclepriority.SelectedValue = tempArray[0];
            motorcycleStatus.SelectedValue = tempArray[1];

            tempArray = inputList[37].Split('$');
            ondutypriority.SelectedValue = tempArray[0];
            ondutyStatus.SelectedValue = tempArray[1];

            tempArray = inputList[38].Split('$');
            offdutypriority.SelectedValue = tempArray[0];
            offdutyStatus.SelectedValue = tempArray[1];

            tempArray = inputList[39].Split('$');
            agencyvehpriority.SelectedValue = tempArray[0];
            agencyvehStatus.SelectedValue = tempArray[1];

            tempArray = inputList[40].Split('$');
            lowincomepriority.SelectedValue = tempArray[0];
            lowincomeStatus.SelectedValue = tempArray[1];

            tempArray = inputList[41].Split('$');
            truckspriority.SelectedValue = tempArray[0];
            trucksStatus.SelectedValue = tempArray[1];

            //Op fixes processing from the input file

            if (inputList[42] != "-1")
                opfixpricing.Checked = true;
            else
                opfixpricing.Checked = false;
            if (inputList[43] != "-1")
                opfixusergroups.Checked = true;
            else
                opfixusergroups.Checked = false;
            if (inputList[44] != "-1")
                opfixenforcement.Checked = true;
            if (inputList[45] != "-1")
                opfixshoulderhours.Checked = true;
            if (inputList[46] != "-1")
                opfixincidentremove.Checked = true;
            if (inputList[47] != "-1")
                opfixtrafficman.Checked = true;
            if (inputList[48] != "-1")
                opfixrampmetering.Checked = true;
            if (inputList[49] != "-1")
                opfiximprovedesign.Checked = true;
            if (inputList[50] != "-1")
                opfixpublicity.Checked = true;
            if (inputList[51] != "-1")
                opfixothers1.Text = inputList[51];
            if (inputList[52] != "-1")
                opfixothers2.Text = inputList[52];
        }
        /* This function processes the MOE values from the input file which is being read. 
         * The file is read into a List<string> which is passed to this function.
         * The 4th line is the first goal (index 3 since the list is 0 based)... 
         * so index 3 is Safe Travel, index 8 is High-speed travel etc.
         * Between index 3 and 8 there are four slots which corresponds to STMOE1A,STMOE1B,STMOE2A, STMOE2B
         * This function is a generic one which processes such lines for all goals
         * The moe checked and the value are separated by "$". 
         */
        protected void processMOEFromInputFile(List<string> inList, string inStr, int index) {
            CheckBox moe1 = (CheckBox)Wizard1.FindControl(inStr + "MOE1A");
            TextBox moe1Text = (TextBox)Wizard1.FindControl(moe1.ID + "Text");
            CheckBox moe2 = (CheckBox)Wizard1.FindControl(inStr + "MOE1B");
            TextBox moe2Text = (TextBox)Wizard1.FindControl(moe2.ID + "Text");
            CheckBox moe3 = (CheckBox)Wizard1.FindControl(inStr + "MOE2A");
            TextBox moe3Text = (TextBox)Wizard1.FindControl(moe3.ID + "Text");
            CheckBox moe4 = (CheckBox)Wizard1.FindControl(inStr + "MOE2B");
            TextBox moe4Text = (TextBox)Wizard1.FindControl(moe4.ID + "Text");
            if (inList[index + 1] != "-1") {
                moe1.Checked = true;
                //System.Diagnostics.Debug.WriteLine(inList[index + 1]);
                string[] temp = inList[index + 1].Split('$');
                moe1Text.Visible = true;
                moe1Text.Text = temp[1];
            
            }
            if (inList[index + 2] != "-1")
            {
                moe2.Checked = true;
                string[] temp = inList[index + 2].Split('$');
                moe2Text.Visible = true;
                moe2Text.Text = temp[1];

            }
            if (inList[index + 3] != "-1")
            {
                moe3.Checked = true;
                string[] temp = inList[index + 3].Split('$');
                moe3Text.Visible = true;
                moe3Text.Text = temp[1];

            }
            if (inList[index + 4] != "-1")
            {
                moe4.Checked = true;
                string[] temp = inList[index + 4].Split('$');
                moe4Text.Visible = true;
                moe4Text.Text = temp[1];

            }
        
        }
        /* This function checks the facility type based on the three input hiddenfields 
         * e.g. If the free hiddenfield is empty and tolled and not allowed is not then the facility is a t
         * tolled one. This will be useful at the end to determine if the facility type changed from
         * the original input
         * 
         */
        protected string checkFacilityType(HiddenField free, HiddenField tolled, HiddenField notallowed) {
            string final = "";
            if (free.Value == "" && tolled.Value != "") {
                final = "TOLL";
            }
            else if (free.Value != "" && tolled.Value == "") {
                final = "HOV";
            }
            else if (free.Value != "" && tolled.Value != "")
            {
                final = "HOT";
            }
            else {
                final = "No";
            }
            return final;
        }
        /* Add string to the supplied hidden field
         */
        protected string addStrToHiddenField(string inputStr, string hidfieldvalue) {
            if (hidfieldvalue != "")
                hidfieldvalue=hidfieldvalue + "," + inputStr;
            else
                hidfieldvalue = inputStr;
            return hidfieldvalue;
        }
        protected void resetAllTempGroupHiddenFields() {
            resetTempGroupHiddenFields("");
        
        }
        protected void resetTempGroupHiddenFields(string currGroup) {
            string[] allGroups = { "tempGroup0", "tempGroup1", "tempGroup2", "tempGroup3", "tempGroup4", "tempGroup5", "tempGroup6", "tempGroup7", "tempGroup8", "tempGroup9", "tempGroup10", "tempGroup11", "tempGroup12", "tempGroup13" };
            int index = 0;
            if (currGroup != "")
                index = Array.FindIndex(allGroups, s => s == currGroup) + 1;
            for (int i = index; i < allGroups.Count(); i++) {
                HiddenField hfield = (HiddenField)Page.FindControl(allGroups[i]);
                hfield.Value = "";
            }
        }
        protected void storeAllTempGroupinVehGroupsProcessed()
        {
            vehGroupsProcessed.Value = "";
            List<string> vehList = new List<string>();
            if (tempGroup0.Value != "")
                vehList.Add(tempGroup0.Value);
            if (tempGroup1.Value != "")
                vehList.Add(tempGroup1.Value);
            if (tempGroup2.Value != "")
                vehList.Add(tempGroup2.Value);
            if (tempGroup3.Value != "")
                vehList.Add(tempGroup3.Value);
            if (tempGroup4.Value != "")
                vehList.Add(tempGroup4.Value);
            if (tempGroup5.Value != "")
                vehList.Add(tempGroup5.Value);
            if (tempGroup6.Value != "")
                vehList.Add(tempGroup6.Value);
            if (tempGroup7.Value != "")
                vehList.Add(tempGroup7.Value);
            if (tempGroup8.Value != "")
                vehList.Add(tempGroup8.Value);
            if (tempGroup9.Value != "")
                vehList.Add(tempGroup9.Value);
            if (tempGroup10.Value != "")
                vehList.Add(tempGroup10.Value);
            if (tempGroup11.Value != "")
                vehList.Add(tempGroup11.Value);
            if (tempGroup12.Value != "")
                vehList.Add(tempGroup12.Value);
            if (tempGroup13.Value != "")
                vehList.Add(tempGroup13.Value);
            vehGroupsProcessed.Value = String.Join(",", vehList);
        }
        protected void processVehGroups() {
            //the vehGroups list is to make processing easier, with 0 list = veh group name 1 list = orig group 2 = new and 3=priority
            // 4 = veh group index
            List<string>[] vehGroups = new List<string>[3];
            vehGroups[0] = new List<string>();
            vehGroups[1] = new List<string>();
            vehGroups[2] = new List<string>();

            List<string>[] temp = new List<string>[3];
            temp[0] = new List<string>();
            temp[1] = new List<string>();
            temp[2] = new List<string>();
            string initTollRank = newTollRank.Value;
            string initTollID = newTollID.Value;
            string initFreeRank = newFreeRank.Value;
            string initFreeID = newFreeID.Value;
            string initNARank = newNARank.Value;
            string initNAID = newNAID.Value;
           


            string TollRank = initTollRank;
            string TollID = initTollID;
            string FreeRank = initFreeRank;
            string FreeID = initFreeID;
            string NARank = initNARank;
            string NAID = initNAID;

            List<string>[] addToList = new List<string>[2];
            addToList[0] = new List<string>();
            addToList[1] = new List<string>();
            List<int> tollRemove = new List<int>();
            List<int> freeRemove = new List<int>();
            List<int> naRemove = new List<int>();
            List<int> tollAdd = new List<int>();
            List<int> freeAdd = new List<int>();
            List<int> naAdd = new List<int>();
            if (vehGroupsProcessed.Value != "")
            {
                temp = stringToList(vehGroupsProcessed.Value);
                vehGroups[0] = temp[0];//copy veh groups name
                vehGroups[1] = temp[1];//orig veh group type
                vehGroups[2] = temp[2];// new veh group type
            }
            System.Diagnostics.Debug.WriteLine("** VehGroups.Count value is **** " + vehGroups.Count());
            if (vehGroups.Count() > 0) {
                for (int i = 0; i < vehGroups[1].Count(); i++) {
                    if (vehGroups[1][i] == "0") {
                        int index = getIndexFromString(TollID, vehGroups[0][i]);
                        int index2 = getIndexFromString(initTollID, vehGroups[0][i]);
                        if (index2 > -1)
                        {
                            addToList[0].Add(getElementFromString(initTollID, index2));
                            addToList[1].Add(getElementFromString(initTollRank, index2));
                        }
                        if (index > -1)
                        {
                            TollRank = removeStrFromList(TollRank, index);
                            TollID = removeStrFromList(TollID, index);
                        }
                    }
                    else if (vehGroups[1][i] == "1")
                    {
                        int index = getIndexFromString(FreeID, vehGroups[0][i]);
                        int index2 = getIndexFromString(initFreeID, vehGroups[0][i]);
                        if (index2 > -1)
                        {
                            addToList[0].Add(getElementFromString(initFreeID, index2));
                            addToList[1].Add(getElementFromString(initFreeRank, index2));
                        }
                        if (index > -1)
                        {
                            FreeRank = removeStrFromList(FreeRank, index);
                            FreeID = removeStrFromList(FreeID, index);
                        }
                    }
                    else {
                        int index = getIndexFromString(NAID, vehGroups[0][i]);
                        int index2 = getIndexFromString(initNAID, vehGroups[0][i]);
                        if (index2 > -1)
                        {
                            addToList[0].Add(getElementFromString(initNAID, index2));
                            addToList[1].Add(getElementFromString(initNARank, index2));
                        }
                        if (index > -1)
                        {
                            NARank = removeStrFromList(NARank, index);
                            NAID = removeStrFromList(NAID, index);
                        }
                    }
                    System.Diagnostics.Debug.WriteLine("** Number of elements in addtolist[0] is ** " + addToList[0].Count());
                    
                }
                for (int i = 0; i < vehGroups[2].Count(); i++) {
                    if (vehGroups[2][i] == "0") {
                        if (TollID != "")
                            TollID = TollID + "," + addToList[0][i];
                        else
                            TollID = addToList[0][i];
                        if(TollRank != "")
                            TollRank = TollRank + "," + addToList[1][i];
                        else
                            TollRank = addToList[1][i];
                    }
                    else if (vehGroups[2][i] == "1") {
                        if(FreeID != "")
                            FreeID = FreeID + "," + addToList[0][i];
                        else
                            FreeID = addToList[0][i];
                        if(FreeRank != "")
                            FreeRank = FreeRank + "," + addToList[1][i];
                        else
                            FreeRank = addToList[1][i];
                    }
                    else {
                        if (NAID != "")
                            NAID = NAID + "," + addToList[0][i];
                        else
                            NAID = addToList[0][i];
                        if (NARank != "")
                            NARank = NARank + "," + addToList[1][i];
                        else
                            NARank = addToList[1][i];
                    }
                    
                }
                tempFreeID.Value = FreeID;
                tempFreeRank.Value = FreeRank;
                tempTollID.Value = TollID;
                tempTollRank.Value = TollRank;
                tempNAID.Value = NAID;
                tempNARank.Value = NARank;
            }
            else {
                tempFreeID.Value = "";
                tempFreeRank.Value = "";
                tempTollID.Value = "";
                tempTollRank.Value = "";
                tempNAID.Value = "";
                tempNARank.Value = "";
            }
        
        }
        /* Gets a string with values separated by "," and each value separated by a dash such as
         * x-x-x and returns it as a 3-dimensional list array with List[0] containing the veh group code
         * List[1] contains original type of veh group (free,toll or not allowed) List[2] contains the
         * new type of veh group
         */
        protected List<string>[] stringToList(string input) {
            List<string> inputList = new List<string>();
            List<string>[] ans = new List<string>[3];
            ans[0] = new List<string>();
            ans[1] = new List<string>();
            ans[2] = new List<string>();
            inputList = input.Split(',').ToList();
            foreach (string s in inputList) {
                System.Diagnostics.Debug.WriteLine("Value of string s is " + s);
                List<string> newList = new List<string>();
                newList = s.Split('-').ToList();
                foreach (string st in newList)
                    System.Diagnostics.Debug.WriteLine(st);
                ans[0].Add(newList[0]);
                ans[1].Add(newList[1]);
                ans[2].Add(newList[2]);
            }
            return ans;
        }
        protected int getIndexFromString(string inputlist, string keyStr) {
            List<string> listofStr = inputlist.Split(',').ToList();
            int index=0;
            if (listofStr.Count > 0)
            {
                index = listofStr.FindIndex(s => s == keyStr);
            }
            else {
                index = -1;
            }
            return index;
        }
        protected string removeStrFromList(string inputStr, int index) {
            List<string> listofStr = inputStr.Split(',').ToList();
            listofStr.RemoveAt(index);
            return String.Join(",", listofStr);
        }
        protected string getElementFromString(string inputStr, int index) {
            List<string> listofStr = inputStr.Split(',').ToList();
            string ans = listofStr.ElementAt(index);
            return ans;
        }
        protected void copyTempHFToNewHF() {
            newTollID.Value = tempTollID.Value;
            newTollRank.Value = tempTollRank.Value;
            newFreeID.Value = tempFreeID.Value;
            newFreeRank.Value = tempFreeRank.Value;
            newNAID.Value = tempNAID.Value;
            newNARank.Value = tempNARank.Value;
        }
        // Hide and clear a label control on the step specified
        protected void hideAndClearLabelControl(string wizardstepid, string controlid) {
            WizardStep step = (WizardStep)Wizard1.FindControl(wizardstepid);
            Label label = (Label)step.FindControl(wizardstepid+controlid);
            label.Text = "";
            label.Visible = false;
            
        }
        protected void clearLabelControl(string wizardstepid, string controlid) {
            WizardStep step = (WizardStep)Wizard1.FindControl(wizardstepid);
            Label label = (Label)step.FindControl(wizardstepid + controlid);
            label.Text = "";
        }
        protected void hideAndClearRadioControl(string wizardstepid, string controlid) {
            WizardStep step = (WizardStep)Wizard1.FindControl(wizardstepid);
            RadioButtonList radio = (RadioButtonList)step.FindControl(wizardstepid+controlid);
            radio.ClearSelection();
            radio.Visible = false;
        
        }
        protected void clearRadioControl(string wizardstepid, string controlid) {
            WizardStep step = (WizardStep)Wizard1.FindControl(wizardstepid);
            RadioButtonList radio = (RadioButtonList)step.FindControl(wizardstepid + controlid);
            radio.ClearSelection();
        }
        protected List<string> getListOfUGroups() {
            List<string> ans = new List<string>();
            string[] ans1 = {"UGroups0", "UGroups1", "UGroups2", "UGroups3", "UGroups4", "UGroups5", "UGroups6", "UGroups7", "UGroups8", "UGroups9", "UGroups10", "UGroups11", "UGroups12", "UGroups13"};
            ans = ans1.ToList();
            return ans;
        }
        protected List<string> getListOfPricing()
        {
            List<string> ans = new List<string>();
            string[] ans1 = { "Pricing0", "Pricing1", "Pricing2", "Pricing3", "Pricing4", "Pricing5", "Pricing6", "Pricing7", "Pricing8", "Pricing9", "Pricing10", "Pricing11", "Pricing12", "Pricing13" };
            ans = ans1.ToList();
            return ans;
        }
        protected List<string> getListOfFlowSteps()
        {
            List<string> ans = new List<string>();
            string[] ans1 = {"flowStep1","flowStep2","flowStep3","flowStep4","flowStep5","flowStep6","flowStep7","flowStep8"};
            ans = ans1.ToList();
            return ans;
        }
        protected List<string> getListOfOtherOPs() {
            List<string> ans = new List<string>();
            string[] OpLabelStrings = { "Enforcement", "SHours", "IRemoval", "Traffic", "Ramp", "Design", "Publicity", "Others1", "Others2" };
            ans = OpLabelStrings.ToList();
            return ans;
        }
        protected List<string> getListOfOtherOpsRadio() {
            List<string> inList = getListOfOtherOPs();
            List<string> ans = new List<string>();
            foreach (string s in inList)
                ans.Add(s + "Radio");
            return ans;
        }
        protected List<string> getListOfOtherOpsFix() {
            List<string> inList = getListOfOtherOPs();
            List<string> ans = new List<string>();
            foreach (string s in inList)
                ans.Add(s + "Fix");
            return ans;
        }
        protected List<string> getListOfOtherOpsFixRadio()
        {
            List<string> inList = getListOfOtherOpsFix();
            List<string> ans = new List<string>();
            foreach (string s in inList)
                ans.Add(s + "Radio");
            return ans;
        }
        protected List<string> getListOfUGroupsFix() {
            List<string> listUGroups = getListOfUGroups();
            List<string> ans = new List<string>();
            foreach (string s in listUGroups)
                ans.Add(s + "Fix");
            return ans;
        }
        protected List<string> getListOfPricingFix() {
            List<string> listPricing = getListOfPricing();
            List<string> ans = new List<string>();
            foreach (string s in listPricing)
                ans.Add(s + "Fix");
            return ans;
        }
        protected List<string> getListOfUGroupsRadio() {
            List<string> inList = getListOfUGroups();
            List<string> ans = new List<string>();
            foreach (string s in inList)
                ans.Add(s + "Radio");
            return ans;
        }
        protected List<string> getListOfUGroupsFixRadio()
        {
            List<string> inList = getListOfUGroupsFix();
            List<string> ans = new List<string>();
            foreach (string s in inList)
                ans.Add(s + "Radio");
            return ans;
        }
        protected List<string> getListOfPricingRadio() {
            List<string> inList = getListOfPricing();
            List<string> ans = new List<string>();
            foreach (string s in inList)
                ans.Add(s + "Radio");
            return ans;
        }
        protected List<string> getListOfPricingFixRadio() {
            List<string> inList = getListOfPricingFix();
            List<string> ans = new List<string>();
            foreach (string s in inList)
                ans.Add(s + "Radio");
            return ans;
        }
        protected void enableRadioControl(string currStepID, string controlid) {
            WizardStep wizstep = (WizardStep)Wizard1.FindControl(currStepID);
            RadioButtonList radioB = (RadioButtonList)wizstep.FindControl(currStepID + controlid);
            radioB.Enabled = true;
        }
        protected void enableCurrentStepUGroupsRadio(string currStepID) {
            List<string> inList = getListOfUGroupsRadio();
            List<string> inList2 = getListOfUGroupsFixRadio();
            foreach (string s in inList)
                enableRadioControl(currStepID, s);
            foreach (string s in inList2)
                enableRadioControl(currStepID, s);
        }
        protected void enableCurrentStepPricingRadio(string currStepID)
        {
            List<string> inList = getListOfPricingRadio();
            List<string> inList2 = getListOfPricingFixRadio();
            foreach (string s in inList)
                enableRadioControl(currStepID, s);
            foreach (string s in inList2)
                enableRadioControl(currStepID, s);
        }
        protected void enableCurrentStepOtherFixRadio(string currStepID) {
            List<string> inList = getListOfOtherOpsRadio();
            foreach (string s in inList)
                enableRadioControl(currStepID, s);
            List<string> inList2 = getListOfOtherOpsFixRadio();
            foreach (string s in inList2)
                enableRadioControl(currStepID, s);
        }
        protected void enableCurrentStepControls(string currStepID) {
            enableRadioControl(currStepID, "BeginRadio");
            enableCurrentStepUGroupsRadio(currStepID);
            enableCurrentStepPricingRadio(currStepID);
            enableCurrentStepOtherFixRadio(currStepID);
        }
        protected void enableAllStepControls() {
            List<string> inList = getListOfFlowSteps();
            foreach (string s in inList)
                enableCurrentStepControls(s);
        }
        protected void enableAllUGroupsRadio() {
            List<string> allsteps = getListOfFlowSteps();
            foreach (string s in allsteps)
                enableCurrentStepUGroupsRadio(s);
        }
        protected void enableAllPricingRadio() {
            List<string> allsteps = getListOfFlowSteps();
            foreach (string s in allsteps)
                enableCurrentStepPricingRadio(s);
        }
        protected void clearCurrentStepUGroupsControls(string currStepID) {
            //clear and hide UGroups0, UGroups1 etc labels
            List<string> listLabels1 = getListOfUGroups();
            foreach (string s in listLabels1)
                hideAndClearLabelControl(currStepID, s);
            //clear and hide UGroups0Fix etc labels
            List<string> listLabels2 = getListOfUGroupsFix();
            foreach (string s in listLabels2)
                hideAndClearLabelControl(currStepID, s);
            //clear and hide UGroups0Radio etc radiobuttons
            List<string> listRadios1 = getListOfUGroupsRadio();
            foreach (string s in listRadios1)
                hideAndClearRadioControl(currStepID, s);
            //clear and hide UGroups0FixRadio etc radiobuttons
            List<string> listRadios2 = getListOfUGroupsFixRadio();
            foreach (string s in listRadios2)
                hideAndClearRadioControl(currStepID, s);
            hideAndClearLabelControl(currStepID, "UGroupsSummary");
        }
        protected void clearCurrentStepPricingControls(string currStepID)
        {
            //clear and hide Pricing0,Pricing1 etc labels
            List<string> listLabels1 = getListOfPricing();
            foreach (string s in listLabels1)
                hideAndClearLabelControl(currStepID, s);
            //clear and hide Pricing0Fix etc labels
            List<string> listLabels2 = getListOfPricingFix();
            foreach (string s in listLabels2)
                hideAndClearLabelControl(currStepID, s);
            //clear and hide Pricing0Radio etc radiobuttons
            List<string> listRadios1 = getListOfPricingRadio();
            foreach (string s in listRadios1)
                hideAndClearRadioControl(currStepID, s);
            //clear and hide Pricing0FixRadio etc radiobuttons
            List<string> listRadios2 = getListOfPricingFixRadio();
            foreach (string s in listRadios2)
                hideAndClearRadioControl(currStepID, s);
            hideAndClearLabelControl(currStepID, "PricingSummary");
        }
        protected void clearCurrentStepOtherFixesControls(string currStepID) {
            //clear and hide Enforcement etc labels
            List<string> listLabels1 = getListOfOtherOPs();
            foreach (string s in listLabels1)
                hideAndClearLabelControl(currStepID, s);
            //clear and hide EnforcementFix etc labels
            List<string> listLabels2 = getListOfOtherOpsFix();
            foreach (string s in listLabels2)
                hideAndClearLabelControl(currStepID, s);
            //clear and hide EnforcementRadio etc radio buttons
            List<string> listRadios1 = getListOfOtherOpsRadio();
            foreach (string s in listRadios1)
                hideAndClearRadioControl(currStepID, s);
            //clear and hide EnforcementFixRadio etc radio buttons
            List<string> listRadios2 = getListOfOtherOpsFixRadio();
            foreach (string s in listRadios2)
                hideAndClearRadioControl(currStepID, s);

        }
        protected void clearCurrentStepControls(string currStepID) {
            //first radiobutton on the step is "Is the MOE satisfactory, Yes or No answer so we will clear that
            //first
            clearRadioControl(currStepID, "BeginRadio");
            clearCurrentStepUGroupsControls(currStepID);
            clearCurrentStepPricingControls(currStepID);
            clearCurrentStepOtherFixesControls(currStepID);
        }
        protected void clearAllStepControls() {
            List<string> inList = getListOfFlowSteps();
            foreach (string s in inList)
                clearCurrentStepControls(s);
        }
        /* Process the values from the hidden groups and returns a string
         * depending upon the input string, it can be used to process newFreeID,newFreeRank,newTollID,newTollRank,
         * newNAID,newNARank and same for the tempFreeRank tempFreeID etc
         * The list will be in this format
         * 1-0,2-1,3-1_1-1,3-2_2-3,4-2 etc if say the toll vehicles list is empty it will display as "X" so 
         * X_1-0,2-1_2-1,2-3 etc
         */
        protected string getStringFromHiddenFieldVehGroups(string input) {
            HiddenField tollID = (HiddenField)Page.FindControl(input + "TollID");
            HiddenField tollRank = (HiddenField)Page.FindControl(input + "TollRank");
            HiddenField freeID = (HiddenField)Page.FindControl(input + "FreeID");
            HiddenField freeRank = (HiddenField)Page.FindControl(input + "FreeRank");
            HiddenField naID = (HiddenField)Page.FindControl(input + "NAID");
            HiddenField naRank = (HiddenField)Page.FindControl(input + "NARank");
            string tollString = "X";
            string freeString = "X";
            string naString = "X";
            if (tollID.Value != "") {
                List<string> ans = new List<string>();
                List<string> vehgroup = new List<string>();
                vehgroup = tollID.Value.Split(',').ToList();
                List<string> vehrank = new List<string>();
                vehrank = tollRank.Value.Split(',').ToList();
                for (int i = 0; i < vehgroup.Count; i++) {
                    string temp = vehgroup[i] + "-" + vehrank[i];
                    ans.Add(temp);
                }
                tollString = String.Join(",", ans);
            }
            
            if (freeID.Value != "") {
                List<string> ans = new List<string>();
                List<string> vehgroup = new List<string>();
                vehgroup = freeID.Value.Split(',').ToList();
                List<string> vehrank = new List<string>();
                vehrank = freeRank.Value.Split(',').ToList();
                for (int i = 0; i < vehgroup.Count; i++)
                {
                    string temp = vehgroup[i] + "-" + vehrank[i];
                    ans.Add(temp);
                }
                freeString = String.Join(",", ans);
            }
            
            if (naID.Value != "") {
                List<string> ans = new List<string>();
                List<string> vehgroup = new List<string>();
                System.Diagnostics.Debug.WriteLine("Value to split is " + naID.Value);
                vehgroup = naID.Value.Split(',').ToList();
                List<string> vehrank = new List<string>();
                vehrank = naRank.Value.Split(',').ToList();
                for (int i = 0; i < vehgroup.Count; i++)
                {
                    string temp = vehgroup[i] + "-" + vehrank[i];
                    ans.Add(temp);
                }
                naString = String.Join(",", ans);
            }
            System.Diagnostics.Debug.WriteLine("Returning String " + tollString + "_" + freeString + "_" + naString);
            return tollString + "_" + freeString + "_" + naString;
            
        }
        /* Process the string returned from the getStringFromHiddenFieldVehGroups function which are stored in 
         * the flowStep1Groups, flowStep2Groups, flowStep3Groups, flowStep4Groups etc 
         *and stores
         * it in the veh group hidden fields, newTollID,newTollRank etc or tempTollID,tempTollRank based on
         * the input string ..
         */
        protected void restoreFromHiddenFieldGroups(string hfieldtype,string inputStr) {
            System.Diagnostics.Debug.WriteLine("Restoring to hiddenfield type " + hfieldtype + " with values of " + inputStr);
            HiddenField tollID = (HiddenField)Page.FindControl(hfieldtype + "TollID");
            HiddenField tollRank = (HiddenField)Page.FindControl(hfieldtype + "TollRank");
            HiddenField freeID = (HiddenField)Page.FindControl(hfieldtype + "FreeID");
            HiddenField freeRank = (HiddenField)Page.FindControl(hfieldtype + "FreeRank");
            HiddenField naID = (HiddenField)Page.FindControl(hfieldtype + "NAID");
            HiddenField naRank = (HiddenField)Page.FindControl(hfieldtype + "NARank");
        
            // the first list in inputStr is for toll, second for free and third for na, each 
            //separated by a "_" 
            tollID.Value = "";
            tollRank.Value = "";
            freeID.Value = "";
            freeRank.Value = "";
            naID.Value = "";
            naRank.Value = "";
            List<string> inputList = inputStr.Split('_').ToList();
            //process tolled veh list
            if (inputList[0] != "X") {
                List<string> vehID = new List<string>();
                List<string> vehRank = new List<string>();
                List<string> temp = new List<string>();
                temp = inputList[0].Split(',').ToList();
                for (int i = 0; i < temp.Count; i++) {
                    List<string> temp2 = new List<string>();
                    temp2 = temp[i].Split('-').ToList();
                    vehID.Add(temp2[0]);
                    vehRank.Add(temp2[1]);
                }
                tollID.Value = String.Join(",", vehID);
                tollRank.Value = String.Join(",", vehRank);
            }
            //process free veh list
            if (inputList[1] != "X")
            {
                List<string> vehID = new List<string>();
                List<string> vehRank = new List<string>();
                List<string> temp = new List<string>();
                temp = inputList[1].Split(',').ToList();
                for (int i = 0; i < temp.Count; i++)
                {
                    List<string> temp2 = new List<string>();
                    temp2 = temp[i].Split('-').ToList();
                    vehID.Add(temp2[0]);
                    vehRank.Add(temp2[1]);
                }
                freeID.Value = String.Join(",", vehID);
                freeRank.Value = String.Join(",", vehRank);
            }
            //process not allowed veh list
            if (inputList[2] != "X")
            {
                List<string> vehID = new List<string>();
                List<string> vehRank = new List<string>();
                List<string> temp = new List<string>();
                temp = inputList[2].Split(',').ToList();
                for (int i = 0; i < temp.Count; i++)
                {
                    List<string> temp2 = new List<string>();
                    temp2 = temp[i].Split('-').ToList();
                    vehID.Add(temp2[0]);
                    vehRank.Add(temp2[1]);
                }
                naID.Value = String.Join(",", vehID);
                naRank.Value = String.Join(",", vehRank);
            }
        }

        /* Process the reset button clicked on the flowstep
         */
        protected void flowStepReset_Click(Object sender, EventArgs e) {
            clearCurrentStepControls(Wizard1.ActiveStep.ID);
            enableCurrentStepControls(Wizard1.ActiveStep.ID);
            HiddenField hfield = (HiddenField)Page.FindControl(Wizard1.ActiveStep.ID + "Groups");
            restoreFromHiddenFieldGroups("new", hfield.Value);
        }
        protected void resetFlowStepGroups(string currStep) {
            List<string> listFlowSteps = getListOfFlowSteps();
            HiddenField[] hfields = {flowStep1Groups,flowStep2Groups,flowStep3Groups,flowStep4Groups,flowStep5Groups,flowStep6Groups,flowStep7Groups,flowStep8Groups };
            int index = listFlowSteps.FindIndex(s => s == currStep)+1;
            for (int i = index; i < listFlowSteps.Count(); i++) {
                hfields[i].Value = "";
            }
        }
        protected string findSelectedFix(string wizStepID) {
            WizardStep wizstep = (WizardStep) Wizard1.FindControl(wizStepID);
            List<string> fixes = new List<string>();
            List<string> ugroupsFixRadio = getListOfUGroupsFixRadio();
            foreach (string s in ugroupsFixRadio) {
                RadioButtonList radioList = (RadioButtonList)wizstep.FindControl(wizStepID + s);
                if (radioList.Visible==true && radioList.SelectedValue == "Yes")
                    fixes.Add(returnActualOpFixNames("UGroups"));
            }
            List<string> pricingFixRadio = getListOfPricingFixRadio();
            foreach (string s in pricingFixRadio) {
                RadioButtonList radioList = (RadioButtonList)wizstep.FindControl(wizStepID + s);
                if (radioList.Visible == true && radioList.SelectedValue == "Yes")
                    fixes.Add(returnActualOpFixNames("Pricing"));
            }
            List<string> otherfixesRadio = getListOfOtherOpsFixRadio();
            List<string> otherfixes = getListOfOtherOPs();
            for (int i = 0; i < otherfixesRadio.Count(); i++) {
                RadioButtonList radioList = (RadioButtonList)wizstep.FindControl(wizStepID + otherfixesRadio[i]);
                if (radioList.Visible == true && radioList.SelectedValue == "Yes")
                    fixes.Add(returnActualOpFixNames(otherfixes[i]));
            }
            if (fixes.Count() > 0)
            {
                return String.Join(",", fixes);
            }
            else {
                return "None";
            }

        }
        protected string wrapStringInADiv(string inputStr,string cssClassStr) {
           
            String ans = "";
            ans = "BEGINDIV"+cssClassStr+inputStr + "ENDDIV";
            return ans;
        }
        protected string getFlowStepInput(string wizStepID) {
            WizardStep currStep = (WizardStep)Wizard1.FindControl(wizStepID);
            List<string> ans = new List<string>();
            Label label;
            RadioButtonList radio;
            //label = (Label)currStep.FindControl(wizStepID + "GoalName");
            //ans.Add(label.Text);
            //label = (Label)currStep.FindControl(wizStepID + "MOE");
            //ans.Add(label.Text);
            label = (Label)currStep.FindControl(wizStepID + "Begin");
            ans.Add(wrapStringInADiv(label.Text,"fix"));
            radio = (RadioButtonList)currStep.FindControl(wizStepID + "BeginRadio");
            ans.Add(wrapStringInADiv(radio.SelectedValue=="Yes"?"Chose Yes":"Chose No","fix"));

            List<string> firstList = getListOfUGroups();
            List<string> secondList = getListOfUGroupsRadio();
            List<string> thirdList = getListOfUGroupsFix();
            List<string> fourthList = getListOfUGroupsFixRadio();
            List<string> pricing = getListOfPricing();
            List<string> pricingradio = getListOfPricingRadio();
            List<string> pricingfix = getListOfPricingFix();
            List<string> pricingfixradio = getListOfPricingFixRadio();
            List<string> others = getListOfOtherOPs();
            List<string> othersRadio = getListOfOtherOpsRadio();
            List<string> othersfix = getListOfOtherOpsFix();
            List<string> othersfixRadio = getListOfOtherOpsFixRadio();

            firstList.AddRange(pricing);
            firstList.AddRange(others);
            secondList.AddRange(pricingradio);
            secondList.AddRange(othersRadio);
            thirdList.AddRange(pricingfix);
            thirdList.AddRange(othersfix);
            fourthList.AddRange(pricingfixradio);
            fourthList.AddRange(othersfixRadio);

            for (int i = 0; i < firstList.Count(); i++) {
                label = (Label)currStep.FindControl(wizStepID + firstList[i]);
                if (label.Visible == true)
                {
                    string[] strArray = {"Begin tolling"};
                    //ans.Add(wrapStringInADiv(label.Text, "lineBox"));
                    string str1 = wrapStringInADiv(label.Text, "line1");
                    radio = (RadioButtonList)currStep.FindControl(wizStepID + secondList[i]);
                    //ans.Add(wrapStringInADiv(radio.SelectedValue == "Yes" ? "Chose Yes" : "Chose No", "lineBox"));
                    string str2 = wrapStringInADiv(radio.SelectedValue == "Yes" ? "Chose Yes" : "Chose No", "line2");
                    if(strArray.Any(s=>str1.Contains(s)) && str2.Contains("Chose Yes"))
                        ans.Add(wrapStringInADiv(str1 + str2, "dollar"));
                    else
                        ans.Add(wrapStringInADiv(str1 + str2, "value"));
                }
                label = (Label)currStep.FindControl(wizStepID + thirdList[i]);
                
                if (label.Visible == true)
                {
                    //ans.Add(wrapStringInADiv(label.Text, "lineBox"));
                    string str1 = wrapStringInADiv(label.Text, "line1");
                    radio = (RadioButtonList)currStep.FindControl(wizStepID + fourthList[i]);
                    //ans.Add(wrapStringInADiv(radio.SelectedValue == "Yes" ? "Chose Yes" : "Chose No", "lineBox"));
                    string str2 = wrapStringInADiv(radio.SelectedValue == "Yes" ? "Chose Yes" : "Chose No", "line2");
                    ans.Add(wrapStringInADiv(str1 + str2, "fix"));

                }
            
            }

            
            return String.Join("$$$",ans);
        }
        protected void resetHFFlowStepValues() {
            flowStep1Values.Value = "";
            flowStep2Values.Value = "";
            flowStep3Values.Value = "";
            flowStep4Values.Value = "";
            flowStep5Values.Value = "";
            flowStep6Values.Value = "";
            flowStep7Values.Value = "";
            flowStep8Values.Value = "";
        
        }
        protected void resetHFFlowStepFixes() {
            flowStep1Fixes.Value = "";
            flowStep2Fixes.Value = "";
            flowStep3Fixes.Value = "";
            flowStep4Fixes.Value = "";
            flowStep5Fixes.Value = "";
            flowStep6Fixes.Value = "";
            flowStep7Fixes.Value = "";
            flowStep8Fixes.Value = "";
        
        }
        protected string buildTableForVehGroups(string fieldType) {
            HiddenField toll = (HiddenField)Page.FindControl(fieldType + "TollID");
            HiddenField tollRank = (HiddenField)Page.FindControl(fieldType + "TollRank");
            HiddenField free = (HiddenField)Page.FindControl(fieldType + "FreeID");
            HiddenField freeRank = (HiddenField)Page.FindControl(fieldType + "FreeRank");
            HiddenField na = (HiddenField)Page.FindControl(fieldType + "NAID");
            HiddenField naRank = (HiddenField)Page.FindControl(fieldType + "NARank");
            List<string> tollStr = new List<string>();
            List<string> tollRankStr = new List<string>();
            List<string> freeStr = new List<string>();
            List<string> freeRankStr = new List<string>();
            List<string> naStr = new List<string>();
            List<string> naRankStr = new List<string>();
            if(toll.Value !="")
                tollStr = toll.Value.Split(',').ToList();
            if(tollRank.Value !="")
                tollRankStr = tollRank.Value.Split(',').ToList();
            if (free.Value != "")
                freeStr = free.Value.Split(',').ToList();
            if(freeRank.Value != "")
                freeRankStr = freeRank.Value.Split(',').ToList();
            if(na.Value !="")
                naStr = na.Value.Split(',').ToList();
            if(naRank.Value !="")
                naRankStr = naRank.Value.Split(',').ToList();



            string tableString = "";
            string tollprocess = "";
            tableString = "<table class=\"resultTable\"><tr><th>Vehicle Group</th><th>Type</th><th>Priority</th></tr>";
            for(int i=0;i<tollStr.Count();i++) {
                tollprocess = "<tr><td>";
                string vehName = returnVehGroupName(int.Parse(tollStr[i]));
                tollprocess = tollprocess + vehName + "</td><td>Tolled</td><td>" + tollRankStr[i] + "</td></tr>";
                tableString = tableString + tollprocess;
            }
            for (int i = 0; i < freeStr.Count(); i++)
            {
                tollprocess = "<tr><td>";
                string vehName = returnVehGroupName(int.Parse(freeStr[i]));
                tollprocess = tollprocess + vehName + "</td><td>Free</td><td>" + freeRankStr[i] + "</td></tr>";
                tableString = tableString + tollprocess;
            }
            for (int i = 0; i < naStr.Count(); i++)
            {
                tollprocess = "<tr><td>";
                string vehName = returnVehGroupName(int.Parse(naStr[i]));
                tollprocess = tollprocess + vehName + "</td><td>Not Allowed</td><td>" + naRankStr[i] + "</td></tr>";
                tableString = tableString + tollprocess;
            }
            tableString = tableString + "</table>";
            return tableString;
        }
        }
